/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.mon.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonCaseInsensitiveEnumDeserializer<T extends Enum<T>>
extends StdDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(MonCaseInsensitiveEnumDeserializer.class);
    private final Class<T> tClass;

    protected MonCaseInsensitiveEnumDeserializer(Class<T> tClass) {
        super(tClass);
        this.tClass = tClass;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec codec = jsonParser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jsonParser);
        String value = node.textValue();
        return Enum.valueOf(this.tClass, value.toUpperCase());
    }
}

