/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.mon.monitoring.v4.serviceability;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.mon.common.v1.response.ApiLink;
import com.nutanix.dp1.mon.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.mon.deserializers.MonObjectTypeTypedObject;
import com.nutanix.dp1.mon.monitoring.v4.common.EntityReference;
import com.nutanix.dp1.mon.monitoring.v4.common.MetricDetail;
import com.nutanix.dp1.mon.monitoring.v4.common.Parameter;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.EventEntityReference;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event
extends ExternalizableAbstractModel
implements Serializable,
MonObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    @JsonProperty(value="sourceEntity")
    public EventEntityReference sourceEntity = null;
    @Size(min=0, max=50)
    @JsonProperty(value="affectedEntities")
    public @Size(min=0, max=50) List<EntityReference> affectedEntities = null;
    @Size(min=0, max=100)
    @JsonProperty(value="metricDetails")
    public @Size(min=0, max=100) List<MetricDetail> metricDetails = null;
    @JsonProperty(value="eventType")
    public String eventType = null;
    @Size(min=0, max=15)
    @JsonProperty(value="classifications")
    public @Size(min=0, max=15) List<String> classifications = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="sourceClusterUUID")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String sourceClusterUUID = null;
    @JsonProperty(value="creationTime")
    public OffsetDateTime creationTime = null;
    @Size(max=1024)
    @JsonProperty(value="message")
    public @Size(max=1024) String message = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterUUID")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterUUID = null;
    @Size(min=0, max=100)
    @JsonProperty(value="parameters")
    public @Size(min=0, max=100) List<Parameter> parameters = null;
    @Size(max=50)
    @JsonProperty(value="serviceName")
    public @Size(max=50) String serviceName = null;

    public Event() {
    }

    public Event(String tenantId, String extId, List<ApiLink> links, EventEntityReference sourceEntity, List<EntityReference> affectedEntities, List<MetricDetail> metricDetails, String eventType, List<String> classifications, String sourceClusterUUID, OffsetDateTime creationTime, String message, String clusterUUID, List<Parameter> parameters, String serviceName) {
        super(tenantId, extId, links);
        this.setSourceEntity(sourceEntity);
        this.setAffectedEntities(affectedEntities);
        this.setMetricDetails(metricDetails);
        this.setEventType(eventType);
        this.setClassifications(classifications);
        this.setSourceClusterUUID(sourceClusterUUID);
        this.setCreationTime(creationTime);
        this.setMessage(message);
        this.setClusterUUID(clusterUUID);
        this.setParameters(parameters);
        this.setServiceName(serviceName);
    }

    @Override
    protected String initialize$objectType() {
        return "monitoring.v4.serviceability.Event";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static EventBuilder EventBuilder() {
        return new EventBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventEntityReference this$sourceEntity = this.getSourceEntity();
        EventEntityReference other$sourceEntity = other.getSourceEntity();
        if (this$sourceEntity == null ? other$sourceEntity != null : !((Object)this$sourceEntity).equals(other$sourceEntity)) {
            return false;
        }
        List<EntityReference> this$affectedEntities = this.getAffectedEntities();
        List<EntityReference> other$affectedEntities = other.getAffectedEntities();
        if (this$affectedEntities == null ? other$affectedEntities != null : !((Object)this$affectedEntities).equals(other$affectedEntities)) {
            return false;
        }
        List<MetricDetail> this$metricDetails = this.getMetricDetails();
        List<MetricDetail> other$metricDetails = other.getMetricDetails();
        if (this$metricDetails == null ? other$metricDetails != null : !((Object)this$metricDetails).equals(other$metricDetails)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        List<String> this$classifications = this.getClassifications();
        List<String> other$classifications = other.getClassifications();
        if (this$classifications == null ? other$classifications != null : !((Object)this$classifications).equals(other$classifications)) {
            return false;
        }
        String this$sourceClusterUUID = this.getSourceClusterUUID();
        String other$sourceClusterUUID = other.getSourceClusterUUID();
        if (this$sourceClusterUUID == null ? other$sourceClusterUUID != null : !this$sourceClusterUUID.equals(other$sourceClusterUUID)) {
            return false;
        }
        OffsetDateTime this$creationTime = this.getCreationTime();
        OffsetDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$clusterUUID = this.getClusterUUID();
        String other$clusterUUID = other.getClusterUUID();
        if (this$clusterUUID == null ? other$clusterUUID != null : !this$clusterUUID.equals(other$clusterUUID)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        return !(this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EventEntityReference $sourceEntity = this.getSourceEntity();
        result = result * 59 + ($sourceEntity == null ? 43 : ((Object)$sourceEntity).hashCode());
        List<EntityReference> $affectedEntities = this.getAffectedEntities();
        result = result * 59 + ($affectedEntities == null ? 43 : ((Object)$affectedEntities).hashCode());
        List<MetricDetail> $metricDetails = this.getMetricDetails();
        result = result * 59 + ($metricDetails == null ? 43 : ((Object)$metricDetails).hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        List<String> $classifications = this.getClassifications();
        result = result * 59 + ($classifications == null ? 43 : ((Object)$classifications).hashCode());
        String $sourceClusterUUID = this.getSourceClusterUUID();
        result = result * 59 + ($sourceClusterUUID == null ? 43 : $sourceClusterUUID.hashCode());
        OffsetDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $clusterUUID = this.getClusterUUID();
        result = result * 59 + ($clusterUUID == null ? 43 : $clusterUUID.hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        return result;
    }

    public EventEntityReference getSourceEntity() {
        return this.sourceEntity;
    }

    public List<EntityReference> getAffectedEntities() {
        return this.affectedEntities;
    }

    public List<MetricDetail> getMetricDetails() {
        return this.metricDetails;
    }

    public String getEventType() {
        return this.eventType;
    }

    public List<String> getClassifications() {
        return this.classifications;
    }

    public String getSourceClusterUUID() {
        return this.sourceClusterUUID;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="sourceEntity")
    public void setSourceEntity(EventEntityReference sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    @JsonProperty(value="affectedEntities")
    public void setAffectedEntities(List<EntityReference> affectedEntities) {
        this.affectedEntities = affectedEntities;
    }

    @JsonProperty(value="metricDetails")
    public void setMetricDetails(List<MetricDetail> metricDetails) {
        this.metricDetails = metricDetails;
    }

    @JsonProperty(value="eventType")
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @JsonProperty(value="classifications")
    public void setClassifications(List<String> classifications) {
        this.classifications = classifications;
    }

    @JsonProperty(value="sourceClusterUUID")
    public void setSourceClusterUUID(String sourceClusterUUID) {
        this.sourceClusterUUID = sourceClusterUUID;
    }

    @JsonProperty(value="creationTime")
    public void setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="clusterUUID")
    public void setClusterUUID(String clusterUUID) {
        this.clusterUUID = clusterUUID;
    }

    @JsonProperty(value="parameters")
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String toString() {
        return "Event(sourceEntity=" + this.getSourceEntity() + ", affectedEntities=" + this.getAffectedEntities() + ", metricDetails=" + this.getMetricDetails() + ", eventType=" + this.getEventType() + ", classifications=" + this.getClassifications() + ", sourceClusterUUID=" + this.getSourceClusterUUID() + ", creationTime=" + this.getCreationTime() + ", message=" + this.getMessage() + ", clusterUUID=" + this.getClusterUUID() + ", parameters=" + this.getParameters() + ", serviceName=" + this.getServiceName() + ")";
    }

    public static class EventBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private EventEntityReference sourceEntity;
        private List<EntityReference> affectedEntities;
        private List<MetricDetail> metricDetails;
        private String eventType;
        private List<String> classifications;
        private String sourceClusterUUID;
        private OffsetDateTime creationTime;
        private String message;
        private String clusterUUID;
        private List<Parameter> parameters;
        private String serviceName;

        EventBuilder() {
        }

        public EventBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public EventBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public EventBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public EventBuilder sourceEntity(EventEntityReference sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public EventBuilder affectedEntities(List<EntityReference> affectedEntities) {
            this.affectedEntities = affectedEntities;
            return this;
        }

        public EventBuilder metricDetails(List<MetricDetail> metricDetails) {
            this.metricDetails = metricDetails;
            return this;
        }

        public EventBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public EventBuilder classifications(List<String> classifications) {
            this.classifications = classifications;
            return this;
        }

        public EventBuilder sourceClusterUUID(String sourceClusterUUID) {
            this.sourceClusterUUID = sourceClusterUUID;
            return this;
        }

        public EventBuilder creationTime(OffsetDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public EventBuilder message(String message) {
            this.message = message;
            return this;
        }

        public EventBuilder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public EventBuilder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public EventBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Event build() {
            return new Event(this.tenantId, this.extId, this.links, this.sourceEntity, this.affectedEntities, this.metricDetails, this.eventType, this.classifications, this.sourceClusterUUID, this.creationTime, this.message, this.clusterUUID, this.parameters, this.serviceName);
        }

        public String toString() {
            return "Event.EventBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", sourceEntity=" + this.sourceEntity + ", affectedEntities=" + this.affectedEntities + ", metricDetails=" + this.metricDetails + ", eventType=" + this.eventType + ", classifications=" + this.classifications + ", sourceClusterUUID=" + this.sourceClusterUUID + ", creationTime=" + this.creationTime + ", message=" + this.message + ", clusterUUID=" + this.clusterUUID + ", parameters=" + this.parameters + ", serviceName=" + this.serviceName + ")";
        }
    }
}

