/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.mon.monitoring.v4.serviceability;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.mon.common.v1.config.TenantAwareModel;
import com.nutanix.dp1.mon.common.v1.response.ApiLink;
import com.nutanix.dp1.mon.deserializers.MonObjectTypeTypedObject;
import com.nutanix.dp1.mon.monitoring.v4.common.ImpactType;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.ClusterConfig;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.ClusterType;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.EntityType;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.Scope;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.SdaSubType;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.SdaType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemDefinedPolicy
extends TenantAwareModel
implements Serializable,
MonObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(SystemDefinedPolicy.class);
    @Size(min=0, max=20)
    private @Size(min=0, max=20) List<ApiLink> links = null;
    @Pattern(regexp="^\\d+$")
    @Size(max=100)
    @JsonProperty(value="extId")
    public @Pattern(regexp="^\\d+$") @Size(max=100) String extId = null;
    @Size(max=1000)
    @JsonProperty(value="name")
    public @Size(max=1000) String name = null;
    @Size(max=400)
    @JsonProperty(value="description")
    public @Size(max=400) String description = null;
    @Pattern(regexp="^{A}\\d+$")
    @JsonProperty(value="policyId")
    public @Pattern(regexp="^{A}\\d+$") String policyId = null;
    @Size(max=250)
    @JsonProperty(value="title")
    public @Size(max=250) String title = null;
    @JsonProperty(value="type")
    public SdaType type = null;
    @JsonProperty(value="subType")
    public SdaSubType subType = null;
    @JsonProperty(value="scope")
    public Scope scope = null;
    @JsonProperty(value="entityType")
    public EntityType entityType = null;
    @Size(min=0, max=15)
    @JsonProperty(value="classifications")
    public @Size(min=0, max=15) List<String> classifications = null;
    @Size(min=0, max=8)
    @JsonProperty(value="impactTypes")
    public @Size(min=0, max=8) List<ImpactType> impactTypes = null;
    @JsonProperty(value="kbArticles")
    public List<String> kbArticles = null;
    @Size(min=1, max=2)
    @JsonProperty(value="targetClusters")
    public @Size(min=1, max=2) List<ClusterType> targetClusters = null;
    @Size(min=1)
    @JsonProperty(value="publisher")
    public @Size(min=1) String publisher = "NCC";
    @Size(min=1, max=350)
    @JsonProperty(value="clusterConfigs")
    public @Size(min=1, max=350) List<ClusterConfig> clusterConfigs = null;

    public SystemDefinedPolicy() {
    }

    public SystemDefinedPolicy(String tenantId, String extId, List<ApiLink> links, String name, String description, String policyId, String title, SdaType type, SdaSubType subType, Scope scope, EntityType entityType, List<String> classifications, List<ImpactType> impactTypes, List<String> kbArticles, List<ClusterType> targetClusters, String publisher, List<ClusterConfig> clusterConfigs) {
        super(tenantId);
        this.setExtId(extId);
        this.setLinks(links);
        this.setName(name);
        this.setDescription(description);
        this.setPolicyId(policyId);
        this.setTitle(title);
        this.setType(type);
        this.setSubType(subType);
        this.setScope(scope);
        this.setEntityType(entityType);
        this.setClassifications(classifications);
        this.setImpactTypes(impactTypes);
        this.setKbArticles(kbArticles);
        this.setTargetClusters(targetClusters);
        this.setPublisher(publisher);
        this.setClusterConfigs(clusterConfigs);
    }

    @Override
    protected String initialize$objectType() {
        return "monitoring.v4.serviceability.SystemDefinedPolicy";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setLinks(List<ApiLink> links) {
        if (this.links == null) {
            this.links = links;
        } else {
            log.warn("Read-only property links already contains a non-null value and cannot be set again");
        }
    }

    public static SystemDefinedPolicyBuilder SystemDefinedPolicyBuilder() {
        return new SystemDefinedPolicyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemDefinedPolicy)) {
            return false;
        }
        SystemDefinedPolicy other = (SystemDefinedPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<ApiLink> this$links = this.getLinks();
        List<ApiLink> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$extId = this.getExtId();
        String other$extId = other.getExtId();
        if (this$extId == null ? other$extId != null : !this$extId.equals(other$extId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        SdaType this$type = this.getType();
        SdaType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        SdaSubType this$subType = this.getSubType();
        SdaSubType other$subType = other.getSubType();
        if (this$subType == null ? other$subType != null : !((Object)((Object)this$subType)).equals((Object)other$subType)) {
            return false;
        }
        Scope this$scope = this.getScope();
        Scope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        List<String> this$classifications = this.getClassifications();
        List<String> other$classifications = other.getClassifications();
        if (this$classifications == null ? other$classifications != null : !((Object)this$classifications).equals(other$classifications)) {
            return false;
        }
        List<ImpactType> this$impactTypes = this.getImpactTypes();
        List<ImpactType> other$impactTypes = other.getImpactTypes();
        if (this$impactTypes == null ? other$impactTypes != null : !((Object)this$impactTypes).equals(other$impactTypes)) {
            return false;
        }
        List<String> this$kbArticles = this.getKbArticles();
        List<String> other$kbArticles = other.getKbArticles();
        if (this$kbArticles == null ? other$kbArticles != null : !((Object)this$kbArticles).equals(other$kbArticles)) {
            return false;
        }
        List<ClusterType> this$targetClusters = this.getTargetClusters();
        List<ClusterType> other$targetClusters = other.getTargetClusters();
        if (this$targetClusters == null ? other$targetClusters != null : !((Object)this$targetClusters).equals(other$targetClusters)) {
            return false;
        }
        String this$publisher = this.getPublisher();
        String other$publisher = other.getPublisher();
        if (this$publisher == null ? other$publisher != null : !this$publisher.equals(other$publisher)) {
            return false;
        }
        List<ClusterConfig> this$clusterConfigs = this.getClusterConfigs();
        List<ClusterConfig> other$clusterConfigs = other.getClusterConfigs();
        return !(this$clusterConfigs == null ? other$clusterConfigs != null : !((Object)this$clusterConfigs).equals(other$clusterConfigs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SystemDefinedPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<ApiLink> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $extId = this.getExtId();
        result = result * 59 + ($extId == null ? 43 : $extId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        SdaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        SdaSubType $subType = this.getSubType();
        result = result * 59 + ($subType == null ? 43 : ((Object)((Object)$subType)).hashCode());
        Scope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        List<String> $classifications = this.getClassifications();
        result = result * 59 + ($classifications == null ? 43 : ((Object)$classifications).hashCode());
        List<ImpactType> $impactTypes = this.getImpactTypes();
        result = result * 59 + ($impactTypes == null ? 43 : ((Object)$impactTypes).hashCode());
        List<String> $kbArticles = this.getKbArticles();
        result = result * 59 + ($kbArticles == null ? 43 : ((Object)$kbArticles).hashCode());
        List<ClusterType> $targetClusters = this.getTargetClusters();
        result = result * 59 + ($targetClusters == null ? 43 : ((Object)$targetClusters).hashCode());
        String $publisher = this.getPublisher();
        result = result * 59 + ($publisher == null ? 43 : $publisher.hashCode());
        List<ClusterConfig> $clusterConfigs = this.getClusterConfigs();
        result = result * 59 + ($clusterConfigs == null ? 43 : ((Object)$clusterConfigs).hashCode());
        return result;
    }

    public List<ApiLink> getLinks() {
        return this.links;
    }

    public String getExtId() {
        return this.extId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getTitle() {
        return this.title;
    }

    public SdaType getType() {
        return this.type;
    }

    public SdaSubType getSubType() {
        return this.subType;
    }

    public Scope getScope() {
        return this.scope;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public List<String> getClassifications() {
        return this.classifications;
    }

    public List<ImpactType> getImpactTypes() {
        return this.impactTypes;
    }

    public List<String> getKbArticles() {
        return this.kbArticles;
    }

    public List<ClusterType> getTargetClusters() {
        return this.targetClusters;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ClusterConfig> getClusterConfigs() {
        return this.clusterConfigs;
    }

    @JsonProperty(value="extId")
    public void setExtId(String extId) {
        this.extId = extId;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="policyId")
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="type")
    public void setType(SdaType type) {
        this.type = type;
    }

    @JsonProperty(value="subType")
    public void setSubType(SdaSubType subType) {
        this.subType = subType;
    }

    @JsonProperty(value="scope")
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    @JsonProperty(value="classifications")
    public void setClassifications(List<String> classifications) {
        this.classifications = classifications;
    }

    @JsonProperty(value="impactTypes")
    public void setImpactTypes(List<ImpactType> impactTypes) {
        this.impactTypes = impactTypes;
    }

    @JsonProperty(value="kbArticles")
    public void setKbArticles(List<String> kbArticles) {
        this.kbArticles = kbArticles;
    }

    @JsonProperty(value="targetClusters")
    public void setTargetClusters(List<ClusterType> targetClusters) {
        this.targetClusters = targetClusters;
    }

    @JsonProperty(value="publisher")
    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    @JsonProperty(value="clusterConfigs")
    public void setClusterConfigs(List<ClusterConfig> clusterConfigs) {
        this.clusterConfigs = clusterConfigs;
    }

    @Override
    public String toString() {
        return "SystemDefinedPolicy(links=" + this.getLinks() + ", extId=" + this.getExtId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", policyId=" + this.getPolicyId() + ", title=" + this.getTitle() + ", type=" + (Object)((Object)this.getType()) + ", subType=" + (Object)((Object)this.getSubType()) + ", scope=" + (Object)((Object)this.getScope()) + ", entityType=" + (Object)((Object)this.getEntityType()) + ", classifications=" + this.getClassifications() + ", impactTypes=" + this.getImpactTypes() + ", kbArticles=" + this.getKbArticles() + ", targetClusters=" + this.getTargetClusters() + ", publisher=" + this.getPublisher() + ", clusterConfigs=" + this.getClusterConfigs() + ")";
    }

    public static class SystemDefinedPolicyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private String policyId;
        private String title;
        private SdaType type;
        private SdaSubType subType;
        private Scope scope;
        private EntityType entityType;
        private List<String> classifications;
        private List<ImpactType> impactTypes;
        private List<String> kbArticles;
        private List<ClusterType> targetClusters;
        private String publisher;
        private List<ClusterConfig> clusterConfigs;

        SystemDefinedPolicyBuilder() {
        }

        public SystemDefinedPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SystemDefinedPolicyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public SystemDefinedPolicyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public SystemDefinedPolicyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SystemDefinedPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SystemDefinedPolicyBuilder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public SystemDefinedPolicyBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SystemDefinedPolicyBuilder type(SdaType type) {
            this.type = type;
            return this;
        }

        public SystemDefinedPolicyBuilder subType(SdaSubType subType) {
            this.subType = subType;
            return this;
        }

        public SystemDefinedPolicyBuilder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public SystemDefinedPolicyBuilder entityType(EntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public SystemDefinedPolicyBuilder classifications(List<String> classifications) {
            this.classifications = classifications;
            return this;
        }

        public SystemDefinedPolicyBuilder impactTypes(List<ImpactType> impactTypes) {
            this.impactTypes = impactTypes;
            return this;
        }

        public SystemDefinedPolicyBuilder kbArticles(List<String> kbArticles) {
            this.kbArticles = kbArticles;
            return this;
        }

        public SystemDefinedPolicyBuilder targetClusters(List<ClusterType> targetClusters) {
            this.targetClusters = targetClusters;
            return this;
        }

        public SystemDefinedPolicyBuilder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public SystemDefinedPolicyBuilder clusterConfigs(List<ClusterConfig> clusterConfigs) {
            this.clusterConfigs = clusterConfigs;
            return this;
        }

        public SystemDefinedPolicy build() {
            return new SystemDefinedPolicy(this.tenantId, this.extId, this.links, this.name, this.description, this.policyId, this.title, this.type, this.subType, this.scope, this.entityType, this.classifications, this.impactTypes, this.kbArticles, this.targetClusters, this.publisher, this.clusterConfigs);
        }

        public String toString() {
            return "SystemDefinedPolicy.SystemDefinedPolicyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", policyId=" + this.policyId + ", title=" + this.title + ", type=" + (Object)((Object)this.type) + ", subType=" + (Object)((Object)this.subType) + ", scope=" + (Object)((Object)this.scope) + ", entityType=" + (Object)((Object)this.entityType) + ", classifications=" + this.classifications + ", impactTypes=" + this.impactTypes + ", kbArticles=" + this.kbArticles + ", targetClusters=" + this.targetClusters + ", publisher=" + this.publisher + ", clusterConfigs=" + this.clusterConfigs + ")";
        }
    }
}

