/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.mon.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonAbstractBoundedMap<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonAbstractBoundedMap.class);
    protected Map<String, T> boundedMap;
    @JsonIgnore
    protected final Class<T> valueClass;
    @JsonIgnore
    protected Map<String, T> unknownKeysMap = new LinkedHashMap<String, T>();

    protected MonAbstractBoundedMap(Class<T> valueClass) {
        this.valueClass = valueClass;
    }

    public T get(String key) {
        if (key == null || this.boundedMap == null || !this.boundedMap.containsKey(key)) {
            log.debug("Null or invalid key {} ", (Object)key);
            throw new IllegalArgumentException("key:" + key + " not recognized");
        }
        return this.boundedMap.get(key);
    }

    public void put(String key, T value) {
        if (this.boundedMap == null) {
            throw new IllegalStateException("BoundedMap is not initialized");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key is not supported");
        }
        if (!this.boundedMap.containsKey(key)) {
            log.debug("Putting unrecognized key {} into unknown map", (Object)key);
            this.unknownKeysMap.put(key, value);
            return;
        }
        this.boundedMap.replace(key, value);
    }

    @JsonIgnore
    public Set<String> getKeys() {
        return this.boundedMap.keySet();
    }

    protected final void init(List<String> allowedKeys, T defaultValue) {
        if (this.boundedMap == null) {
            this.boundedMap = new LinkedHashMap<String, T>();
            allowedKeys.forEach(k -> this.boundedMap.put((String)k, defaultValue));
        }
    }

    @Generated
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonAbstractBoundedMap)) {
            return false;
        }
        MonAbstractBoundedMap other = (MonAbstractBoundedMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, T> this$boundedMap = this.boundedMap;
        Map<String, T> other$boundedMap = other.boundedMap;
        if (this$boundedMap == null ? other$boundedMap != null : !((Object)this$boundedMap).equals(other$boundedMap)) {
            return false;
        }
        Class<T> this$valueClass = this.getValueClass();
        Class<T> other$valueClass = other.getValueClass();
        if (this$valueClass == null ? other$valueClass != null : !this$valueClass.equals(other$valueClass)) {
            return false;
        }
        Map<String, T> this$unknownKeysMap = this.unknownKeysMap;
        Map<String, T> other$unknownKeysMap = other.unknownKeysMap;
        return !(this$unknownKeysMap == null ? other$unknownKeysMap != null : !((Object)this$unknownKeysMap).equals(other$unknownKeysMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MonAbstractBoundedMap;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, T> $boundedMap = this.boundedMap;
        result = result * 59 + ($boundedMap == null ? 43 : ((Object)$boundedMap).hashCode());
        Class<T> $valueClass = this.getValueClass();
        result = result * 59 + ($valueClass == null ? 43 : $valueClass.hashCode());
        Map<String, T> $unknownKeysMap = this.unknownKeysMap;
        result = result * 59 + ($unknownKeysMap == null ? 43 : ((Object)$unknownKeysMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MonAbstractBoundedMap(boundedMap=" + this.boundedMap + ", valueClass=" + this.getValueClass() + ", unknownKeysMap=" + this.unknownKeysMap + ")";
    }
}

