/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.mon.monitoring.v4.serviceability;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.mon.common.v1.response.ApiLink;
import com.nutanix.dp1.mon.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.mon.deserializers.MonObjectTypeTypedObject;
import com.nutanix.dp1.mon.monitoring.v4.common.EntityReference;
import com.nutanix.dp1.mon.monitoring.v4.common.MetricDetail;
import com.nutanix.dp1.mon.monitoring.v4.common.OperationType;
import com.nutanix.dp1.mon.monitoring.v4.common.Parameter;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.EventEntityReference;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event
extends ExternalizableAbstractModel
implements Serializable,
MonObjectTypeTypedObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    @JsonProperty(value="sourceEntity")
    public EventEntityReference sourceEntity = null;
    @Size(min=0, max=50)
    @JsonProperty(value="affectedEntities")
    public @Size(min=0, max=50) List<EntityReference> affectedEntities = null;
    @Size(min=0, max=100)
    @JsonProperty(value="metricDetails")
    public @Size(min=0, max=100) List<MetricDetail> metricDetails = null;
    @JsonProperty(value="eventType")
    public String eventType = null;
    @Size(min=0, max=15)
    @JsonProperty(value="classifications")
    public @Size(min=0, max=15) List<String> classifications = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="sourceClusterUUID")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String sourceClusterUUID = null;
    @JsonProperty(value="creationTime")
    public OffsetDateTime creationTime = null;
    @Size(max=1024)
    @JsonProperty(value="message")
    public @Size(max=1024) String message = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterUUID")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterUUID = null;
    @Size(min=0, max=100)
    @JsonProperty(value="parameters")
    public @Size(min=0, max=100) List<Parameter> parameters = null;
    @Size(max=50)
    @JsonProperty(value="serviceName")
    public @Size(max=50) String serviceName = null;
    @JsonProperty(value="operationType")
    public OperationType operationType = null;
    @Size(max=1000)
    @JsonProperty(value="clusterName")
    public @Size(max=1000) String clusterName = null;

    public Event() {
    }

    public Event(String tenantId, String extId, List<ApiLink> links, EventEntityReference sourceEntity, List<EntityReference> affectedEntities, List<MetricDetail> metricDetails, String eventType, List<String> classifications, String sourceClusterUUID, OffsetDateTime creationTime, String message, String clusterUUID, List<Parameter> parameters, String serviceName, OperationType operationType, String clusterName) {
        super(tenantId, extId, links);
        this.setSourceEntity(sourceEntity);
        this.setAffectedEntities(affectedEntities);
        this.setMetricDetails(metricDetails);
        this.setEventType(eventType);
        this.setClassifications(classifications);
        this.setSourceClusterUUID(sourceClusterUUID);
        this.setCreationTime(creationTime);
        this.setMessage(message);
        this.setClusterUUID(clusterUUID);
        this.setParameters(parameters);
        this.setServiceName(serviceName);
        this.setOperationType(operationType);
        this.setClusterName(clusterName);
    }

    @Override
    protected String initialize$objectType() {
        return "monitoring.v4.serviceability.Event";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r2";
    }

    @Generated
    public static EventBuilder EventBuilder() {
        return new EventBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventEntityReference this$sourceEntity = this.getSourceEntity();
        EventEntityReference other$sourceEntity = other.getSourceEntity();
        if (this$sourceEntity == null ? other$sourceEntity != null : !((Object)this$sourceEntity).equals(other$sourceEntity)) {
            return false;
        }
        List<EntityReference> this$affectedEntities = this.getAffectedEntities();
        List<EntityReference> other$affectedEntities = other.getAffectedEntities();
        if (this$affectedEntities == null ? other$affectedEntities != null : !((Object)this$affectedEntities).equals(other$affectedEntities)) {
            return false;
        }
        List<MetricDetail> this$metricDetails = this.getMetricDetails();
        List<MetricDetail> other$metricDetails = other.getMetricDetails();
        if (this$metricDetails == null ? other$metricDetails != null : !((Object)this$metricDetails).equals(other$metricDetails)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        List<String> this$classifications = this.getClassifications();
        List<String> other$classifications = other.getClassifications();
        if (this$classifications == null ? other$classifications != null : !((Object)this$classifications).equals(other$classifications)) {
            return false;
        }
        String this$sourceClusterUUID = this.getSourceClusterUUID();
        String other$sourceClusterUUID = other.getSourceClusterUUID();
        if (this$sourceClusterUUID == null ? other$sourceClusterUUID != null : !this$sourceClusterUUID.equals(other$sourceClusterUUID)) {
            return false;
        }
        OffsetDateTime this$creationTime = this.getCreationTime();
        OffsetDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$clusterUUID = this.getClusterUUID();
        String other$clusterUUID = other.getClusterUUID();
        if (this$clusterUUID == null ? other$clusterUUID != null : !this$clusterUUID.equals(other$clusterUUID)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        OperationType this$operationType = this.getOperationType();
        OperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        return !(this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EventEntityReference $sourceEntity = this.getSourceEntity();
        result = result * 59 + ($sourceEntity == null ? 43 : ((Object)$sourceEntity).hashCode());
        List<EntityReference> $affectedEntities = this.getAffectedEntities();
        result = result * 59 + ($affectedEntities == null ? 43 : ((Object)$affectedEntities).hashCode());
        List<MetricDetail> $metricDetails = this.getMetricDetails();
        result = result * 59 + ($metricDetails == null ? 43 : ((Object)$metricDetails).hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        List<String> $classifications = this.getClassifications();
        result = result * 59 + ($classifications == null ? 43 : ((Object)$classifications).hashCode());
        String $sourceClusterUUID = this.getSourceClusterUUID();
        result = result * 59 + ($sourceClusterUUID == null ? 43 : $sourceClusterUUID.hashCode());
        OffsetDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $clusterUUID = this.getClusterUUID();
        result = result * 59 + ($clusterUUID == null ? 43 : $clusterUUID.hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        OperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        return result;
    }

    @Generated
    public EventEntityReference getSourceEntity() {
        return this.sourceEntity;
    }

    @Generated
    public List<EntityReference> getAffectedEntities() {
        return this.affectedEntities;
    }

    @Generated
    public List<MetricDetail> getMetricDetails() {
        return this.metricDetails;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public List<String> getClassifications() {
        return this.classifications;
    }

    @Generated
    public String getSourceClusterUUID() {
        return this.sourceClusterUUID;
    }

    @Generated
    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getClusterUUID() {
        return this.clusterUUID;
    }

    @Generated
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public OperationType getOperationType() {
        return this.operationType;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @JsonProperty(value="sourceEntity")
    @Generated
    public void setSourceEntity(EventEntityReference sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    @JsonProperty(value="affectedEntities")
    @Generated
    public void setAffectedEntities(List<EntityReference> affectedEntities) {
        this.affectedEntities = affectedEntities;
    }

    @JsonProperty(value="metricDetails")
    @Generated
    public void setMetricDetails(List<MetricDetail> metricDetails) {
        this.metricDetails = metricDetails;
    }

    @JsonProperty(value="eventType")
    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @JsonProperty(value="classifications")
    @Generated
    public void setClassifications(List<String> classifications) {
        this.classifications = classifications;
    }

    @JsonProperty(value="sourceClusterUUID")
    @Generated
    public void setSourceClusterUUID(String sourceClusterUUID) {
        this.sourceClusterUUID = sourceClusterUUID;
    }

    @JsonProperty(value="creationTime")
    @Generated
    public void setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @JsonProperty(value="message")
    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="clusterUUID")
    @Generated
    public void setClusterUUID(String clusterUUID) {
        this.clusterUUID = clusterUUID;
    }

    @JsonProperty(value="parameters")
    @Generated
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @JsonProperty(value="serviceName")
    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @JsonProperty(value="operationType")
    @Generated
    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    @JsonProperty(value="clusterName")
    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    @Generated
    public String toString() {
        return "Event(sourceEntity=" + this.getSourceEntity() + ", affectedEntities=" + this.getAffectedEntities() + ", metricDetails=" + this.getMetricDetails() + ", eventType=" + this.getEventType() + ", classifications=" + this.getClassifications() + ", sourceClusterUUID=" + this.getSourceClusterUUID() + ", creationTime=" + this.getCreationTime() + ", message=" + this.getMessage() + ", clusterUUID=" + this.getClusterUUID() + ", parameters=" + this.getParameters() + ", serviceName=" + this.getServiceName() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", clusterName=" + this.getClusterName() + ")";
    }

    public static class EventBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String extId;
        @Generated
        private List<ApiLink> links;
        @Generated
        private EventEntityReference sourceEntity;
        @Generated
        private List<EntityReference> affectedEntities;
        @Generated
        private List<MetricDetail> metricDetails;
        @Generated
        private String eventType;
        @Generated
        private List<String> classifications;
        @Generated
        private String sourceClusterUUID;
        @Generated
        private OffsetDateTime creationTime;
        @Generated
        private String message;
        @Generated
        private String clusterUUID;
        @Generated
        private List<Parameter> parameters;
        @Generated
        private String serviceName;
        @Generated
        private OperationType operationType;
        @Generated
        private String clusterName;
        protected final Map<String, Object> $reserved = new LinkedHashMap<String, Object>();

        public EventBuilder addToReservedMap(String key, Object value) {
            this.$reserved.put(key, value);
            return this;
        }

        public Event build() {
            Event obj = new Event(this.tenantId, this.extId, this.links, this.sourceEntity, this.affectedEntities, this.metricDetails, this.eventType, this.classifications, this.sourceClusterUUID, this.creationTime, this.message, this.clusterUUID, this.parameters, this.serviceName, this.operationType, this.clusterName);
            obj.$reserved.putAll(this.$reserved);
            return obj;
        }

        @Generated
        EventBuilder() {
        }

        @Generated
        public EventBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public EventBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        @Generated
        public EventBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        @Generated
        public EventBuilder sourceEntity(EventEntityReference sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        @Generated
        public EventBuilder affectedEntities(List<EntityReference> affectedEntities) {
            this.affectedEntities = affectedEntities;
            return this;
        }

        @Generated
        public EventBuilder metricDetails(List<MetricDetail> metricDetails) {
            this.metricDetails = metricDetails;
            return this;
        }

        @Generated
        public EventBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Generated
        public EventBuilder classifications(List<String> classifications) {
            this.classifications = classifications;
            return this;
        }

        @Generated
        public EventBuilder sourceClusterUUID(String sourceClusterUUID) {
            this.sourceClusterUUID = sourceClusterUUID;
            return this;
        }

        @Generated
        public EventBuilder creationTime(OffsetDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Generated
        public EventBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public EventBuilder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        @Generated
        public EventBuilder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public EventBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Generated
        public EventBuilder operationType(OperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        @Generated
        public EventBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Generated
        public String toString() {
            return "Event.EventBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", sourceEntity=" + this.sourceEntity + ", affectedEntities=" + this.affectedEntities + ", metricDetails=" + this.metricDetails + ", eventType=" + this.eventType + ", classifications=" + this.classifications + ", sourceClusterUUID=" + this.sourceClusterUUID + ", creationTime=" + this.creationTime + ", message=" + this.message + ", clusterUUID=" + this.clusterUUID + ", parameters=" + this.parameters + ", serviceName=" + this.serviceName + ", operationType=" + (Object)((Object)this.operationType) + ", clusterName=" + this.clusterName + ")";
        }
    }
}

