/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.mon.java.client.api;

import com.nutanix.dp1.mon.monitoring.v4.serviceability.AlertActionSpec;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.ManageAlertApiResponse;
import com.nutanix.mon.java.client.ApiClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.mon.java.client.api.ManageAlertsApi")
public class ManageAlertsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManageAlertsApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public ManageAlertsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ManageAlertsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ManageAlertApiResponse manageAlert(String extId, AlertActionSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        AlertActionSpec postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling manageAlert");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling manageAlert");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/monitoring/v4.2/serviceability/alerts/{extId}/$actions/manage-alert").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ManageAlertApiResponse> returnType = new ParameterizedTypeReference<ManageAlertApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

