/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.mon.java.client.api;

import com.nutanix.dp1.mon.monitoring.v4.serviceability.RunSystemDefinedChecksApiResponse;
import com.nutanix.dp1.mon.monitoring.v4.serviceability.RunSystemDefinedChecksSpec;
import com.nutanix.mon.java.client.ApiClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.mon.java.client.api.SystemDefinedChecksApi")
public class SystemDefinedChecksApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemDefinedChecksApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public SystemDefinedChecksApi() {
        this(new ApiClient());
    }

    @Autowired
    public SystemDefinedChecksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RunSystemDefinedChecksApiResponse runSystemDefinedChecks(String clusterExtId, RunSystemDefinedChecksSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        RunSystemDefinedChecksSpec postBody = body;
        if (clusterExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clusterExtId' when calling runSystemDefinedChecks");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling runSystemDefinedChecks");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("clusterExtId", clusterExtId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/monitoring/v4.2/serviceability/clusters/{clusterExtId}/$actions/run-system-defined-checks").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<RunSystemDefinedChecksApiResponse> returnType = new ParameterizedTypeReference<RunSystemDefinedChecksApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

