/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Anc
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Anc.class);
    @Size(min=0, max=10)
    private @Size(min=0, max=10) List<IPAddress> ancDomainNameServerList = null;
    @Size(min=0, max=200)
    private @Size(min=0, max=200) List<String> excludedClusters = null;
    @JsonProperty(value="configVersion")
    public Long configVersion = null;
    @JsonProperty(value="isAtlasNetworkingEnabled")
    public Boolean isAtlasNetworkingEnabled = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @JsonProperty(value="ancUrl")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") String ancUrl = null;
    @JsonProperty(value="ovnRemoteAddress")
    public String ovnRemoteAddress = null;

    public Anc() {
    }

    public Anc(String tenantId, String extId, List<ApiLink> links, Metadata metadata, Long configVersion, Boolean isAtlasNetworkingEnabled, String ancUrl, String ovnRemoteAddress, List<IPAddress> ancDomainNameServerList, List<String> excludedClusters) {
        super(tenantId, extId, links, metadata);
        this.setConfigVersion(configVersion);
        this.setIsAtlasNetworkingEnabled(isAtlasNetworkingEnabled);
        this.setAncUrl(ancUrl);
        this.setOvnRemoteAddress(ovnRemoteAddress);
        this.setAncDomainNameServerList(ancDomainNameServerList);
        this.setExcludedClusters(excludedClusters);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Anc";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setAncDomainNameServerList(List<IPAddress> ancDomainNameServerList) {
        if (this.ancDomainNameServerList == null) {
            this.ancDomainNameServerList = ancDomainNameServerList;
        } else {
            log.warn("Read-only property ancDomainNameServerList already contains a non-null value and cannot be set again");
        }
    }

    public void setExcludedClusters(List<String> excludedClusters) {
        if (this.excludedClusters == null) {
            this.excludedClusters = excludedClusters;
        } else {
            log.warn("Read-only property excludedClusters already contains a non-null value and cannot be set again");
        }
    }

    public static AncBuilder AncBuilder() {
        return new AncBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Anc)) {
            return false;
        }
        Anc other = (Anc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<IPAddress> this$ancDomainNameServerList = this.getAncDomainNameServerList();
        List<IPAddress> other$ancDomainNameServerList = other.getAncDomainNameServerList();
        if (this$ancDomainNameServerList == null ? other$ancDomainNameServerList != null : !((Object)this$ancDomainNameServerList).equals(other$ancDomainNameServerList)) {
            return false;
        }
        List<String> this$excludedClusters = this.getExcludedClusters();
        List<String> other$excludedClusters = other.getExcludedClusters();
        if (this$excludedClusters == null ? other$excludedClusters != null : !((Object)this$excludedClusters).equals(other$excludedClusters)) {
            return false;
        }
        Long this$configVersion = this.getConfigVersion();
        Long other$configVersion = other.getConfigVersion();
        if (this$configVersion == null ? other$configVersion != null : !((Object)this$configVersion).equals(other$configVersion)) {
            return false;
        }
        Boolean this$isAtlasNetworkingEnabled = this.getIsAtlasNetworkingEnabled();
        Boolean other$isAtlasNetworkingEnabled = other.getIsAtlasNetworkingEnabled();
        if (this$isAtlasNetworkingEnabled == null ? other$isAtlasNetworkingEnabled != null : !((Object)this$isAtlasNetworkingEnabled).equals(other$isAtlasNetworkingEnabled)) {
            return false;
        }
        String this$ancUrl = this.getAncUrl();
        String other$ancUrl = other.getAncUrl();
        if (this$ancUrl == null ? other$ancUrl != null : !this$ancUrl.equals(other$ancUrl)) {
            return false;
        }
        String this$ovnRemoteAddress = this.getOvnRemoteAddress();
        String other$ovnRemoteAddress = other.getOvnRemoteAddress();
        return !(this$ovnRemoteAddress == null ? other$ovnRemoteAddress != null : !this$ovnRemoteAddress.equals(other$ovnRemoteAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Anc;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<IPAddress> $ancDomainNameServerList = this.getAncDomainNameServerList();
        result = result * 59 + ($ancDomainNameServerList == null ? 43 : ((Object)$ancDomainNameServerList).hashCode());
        List<String> $excludedClusters = this.getExcludedClusters();
        result = result * 59 + ($excludedClusters == null ? 43 : ((Object)$excludedClusters).hashCode());
        Long $configVersion = this.getConfigVersion();
        result = result * 59 + ($configVersion == null ? 43 : ((Object)$configVersion).hashCode());
        Boolean $isAtlasNetworkingEnabled = this.getIsAtlasNetworkingEnabled();
        result = result * 59 + ($isAtlasNetworkingEnabled == null ? 43 : ((Object)$isAtlasNetworkingEnabled).hashCode());
        String $ancUrl = this.getAncUrl();
        result = result * 59 + ($ancUrl == null ? 43 : $ancUrl.hashCode());
        String $ovnRemoteAddress = this.getOvnRemoteAddress();
        result = result * 59 + ($ovnRemoteAddress == null ? 43 : $ovnRemoteAddress.hashCode());
        return result;
    }

    public List<IPAddress> getAncDomainNameServerList() {
        return this.ancDomainNameServerList;
    }

    public List<String> getExcludedClusters() {
        return this.excludedClusters;
    }

    public Long getConfigVersion() {
        return this.configVersion;
    }

    public Boolean getIsAtlasNetworkingEnabled() {
        return this.isAtlasNetworkingEnabled;
    }

    public String getAncUrl() {
        return this.ancUrl;
    }

    public String getOvnRemoteAddress() {
        return this.ovnRemoteAddress;
    }

    @JsonProperty(value="configVersion")
    public void setConfigVersion(Long configVersion) {
        this.configVersion = configVersion;
    }

    @JsonProperty(value="isAtlasNetworkingEnabled")
    public void setIsAtlasNetworkingEnabled(Boolean isAtlasNetworkingEnabled) {
        this.isAtlasNetworkingEnabled = isAtlasNetworkingEnabled;
    }

    @JsonProperty(value="ancUrl")
    public void setAncUrl(String ancUrl) {
        this.ancUrl = ancUrl;
    }

    @JsonProperty(value="ovnRemoteAddress")
    public void setOvnRemoteAddress(String ovnRemoteAddress) {
        this.ovnRemoteAddress = ovnRemoteAddress;
    }

    @Override
    public String toString() {
        return "Anc(ancDomainNameServerList=" + this.getAncDomainNameServerList() + ", excludedClusters=" + this.getExcludedClusters() + ", configVersion=" + this.getConfigVersion() + ", isAtlasNetworkingEnabled=" + this.getIsAtlasNetworkingEnabled() + ", ancUrl=" + this.getAncUrl() + ", ovnRemoteAddress=" + this.getOvnRemoteAddress() + ")";
    }

    public static class AncBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private Long configVersion;
        private Boolean isAtlasNetworkingEnabled;
        private String ancUrl;
        private String ovnRemoteAddress;
        private List<IPAddress> ancDomainNameServerList;
        private List<String> excludedClusters;

        AncBuilder() {
        }

        public AncBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AncBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public AncBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public AncBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public AncBuilder configVersion(Long configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        public AncBuilder isAtlasNetworkingEnabled(Boolean isAtlasNetworkingEnabled) {
            this.isAtlasNetworkingEnabled = isAtlasNetworkingEnabled;
            return this;
        }

        public AncBuilder ancUrl(String ancUrl) {
            this.ancUrl = ancUrl;
            return this;
        }

        public AncBuilder ovnRemoteAddress(String ovnRemoteAddress) {
            this.ovnRemoteAddress = ovnRemoteAddress;
            return this;
        }

        public AncBuilder ancDomainNameServerList(List<IPAddress> ancDomainNameServerList) {
            this.ancDomainNameServerList = ancDomainNameServerList;
            return this;
        }

        public AncBuilder excludedClusters(List<String> excludedClusters) {
            this.excludedClusters = excludedClusters;
            return this;
        }

        public Anc build() {
            return new Anc(this.tenantId, this.extId, this.links, this.metadata, this.configVersion, this.isAtlasNetworkingEnabled, this.ancUrl, this.ovnRemoteAddress, this.ancDomainNameServerList, this.excludedClusters);
        }

        public String toString() {
            return "Anc.AncBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", configVersion=" + this.configVersion + ", isAtlasNetworkingEnabled=" + this.isAtlasNetworkingEnabled + ", ancUrl=" + this.ancUrl + ", ovnRemoteAddress=" + this.ovnRemoteAddress + ", ancDomainNameServerList=" + this.ancDomainNameServerList + ", excludedClusters=" + this.excludedClusters + ")";
        }
    }
}

