/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPConfig;
import com.nutanix.dp1.net.networking.v4.config.PublicIpMapping;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureExternalSubnetConfig
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(AzureExternalSubnetConfig.class);
    @JsonProperty(value="ipConfig")
    public IPConfig ipConfig = null;
    @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$")
    @JsonProperty(value="gatewayMacAddress")
    public @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$") String gatewayMacAddress = null;
    @Size(min=0, max=250)
    @JsonProperty(value="publicIpMappingList")
    public @Size(min=0, max=250) List<PublicIpMapping> publicIpMappingList = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public AzureExternalSubnetConfig() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public AzureExternalSubnetConfig(IPConfig ipConfig, String gatewayMacAddress, List<PublicIpMapping> publicIpMappingList) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setIpConfig(ipConfig);
        this.setGatewayMacAddress(gatewayMacAddress);
        this.setPublicIpMappingList(publicIpMappingList);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.AzureExternalSubnetConfig";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static AzureExternalSubnetConfigBuilder AzureExternalSubnetConfigBuilder() {
        return new AzureExternalSubnetConfigBuilder();
    }

    public IPConfig getIpConfig() {
        return this.ipConfig;
    }

    public String getGatewayMacAddress() {
        return this.gatewayMacAddress;
    }

    public List<PublicIpMapping> getPublicIpMappingList() {
        return this.publicIpMappingList;
    }

    @JsonProperty(value="ipConfig")
    public void setIpConfig(IPConfig ipConfig) {
        this.ipConfig = ipConfig;
    }

    @JsonProperty(value="gatewayMacAddress")
    public void setGatewayMacAddress(String gatewayMacAddress) {
        this.gatewayMacAddress = gatewayMacAddress;
    }

    @JsonProperty(value="publicIpMappingList")
    public void setPublicIpMappingList(List<PublicIpMapping> publicIpMappingList) {
        this.publicIpMappingList = publicIpMappingList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureExternalSubnetConfig)) {
            return false;
        }
        AzureExternalSubnetConfig other = (AzureExternalSubnetConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPConfig this$ipConfig = this.getIpConfig();
        IPConfig other$ipConfig = other.getIpConfig();
        if (this$ipConfig == null ? other$ipConfig != null : !((Object)this$ipConfig).equals(other$ipConfig)) {
            return false;
        }
        String this$gatewayMacAddress = this.getGatewayMacAddress();
        String other$gatewayMacAddress = other.getGatewayMacAddress();
        if (this$gatewayMacAddress == null ? other$gatewayMacAddress != null : !this$gatewayMacAddress.equals(other$gatewayMacAddress)) {
            return false;
        }
        List<PublicIpMapping> this$publicIpMappingList = this.getPublicIpMappingList();
        List<PublicIpMapping> other$publicIpMappingList = other.getPublicIpMappingList();
        return !(this$publicIpMappingList == null ? other$publicIpMappingList != null : !((Object)this$publicIpMappingList).equals(other$publicIpMappingList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AzureExternalSubnetConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPConfig $ipConfig = this.getIpConfig();
        result = result * 59 + ($ipConfig == null ? 43 : ((Object)$ipConfig).hashCode());
        String $gatewayMacAddress = this.getGatewayMacAddress();
        result = result * 59 + ($gatewayMacAddress == null ? 43 : $gatewayMacAddress.hashCode());
        List<PublicIpMapping> $publicIpMappingList = this.getPublicIpMappingList();
        result = result * 59 + ($publicIpMappingList == null ? 43 : ((Object)$publicIpMappingList).hashCode());
        return result;
    }

    public String toString() {
        return "AzureExternalSubnetConfig(ipConfig=" + this.getIpConfig() + ", gatewayMacAddress=" + this.getGatewayMacAddress() + ", publicIpMappingList=" + this.getPublicIpMappingList() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class AzureExternalSubnetConfigBuilder {
        private IPConfig ipConfig;
        private String gatewayMacAddress;
        private List<PublicIpMapping> publicIpMappingList;

        AzureExternalSubnetConfigBuilder() {
        }

        public AzureExternalSubnetConfigBuilder ipConfig(IPConfig ipConfig) {
            this.ipConfig = ipConfig;
            return this;
        }

        public AzureExternalSubnetConfigBuilder gatewayMacAddress(String gatewayMacAddress) {
            this.gatewayMacAddress = gatewayMacAddress;
            return this;
        }

        public AzureExternalSubnetConfigBuilder publicIpMappingList(List<PublicIpMapping> publicIpMappingList) {
            this.publicIpMappingList = publicIpMappingList;
            return this;
        }

        public AzureExternalSubnetConfig build() {
            return new AzureExternalSubnetConfig(this.ipConfig, this.gatewayMacAddress, this.publicIpMappingList);
        }

        public String toString() {
            return "AzureExternalSubnetConfig.AzureExternalSubnetConfigBuilder(ipConfig=" + this.ipConfig + ", gatewayMacAddress=" + this.gatewayMacAddress + ", publicIpMappingList=" + this.publicIpMappingList + ")";
        }
    }
}

