/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPSubnet;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.Nexthop;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRoute
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BaseRoute.class);
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="destination")
    public IPSubnet destination = null;
    @JsonProperty(value="nexthop")
    public Nexthop nexthop = null;

    public BaseRoute() {
    }

    public BaseRoute(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, IPSubnet destination, Nexthop nexthop) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setDestination(destination);
        this.setNexthop(nexthop);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.BaseRoute";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static BaseRouteBuilder BaseRouteBuilder() {
        return new BaseRouteBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRoute)) {
            return false;
        }
        BaseRoute other = (BaseRoute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        IPSubnet this$destination = this.getDestination();
        IPSubnet other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        Nexthop this$nexthop = this.getNexthop();
        Nexthop other$nexthop = other.getNexthop();
        return !(this$nexthop == null ? other$nexthop != null : !((Object)this$nexthop).equals(other$nexthop));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseRoute;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        IPSubnet $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        Nexthop $nexthop = this.getNexthop();
        result = result * 59 + ($nexthop == null ? 43 : ((Object)$nexthop).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public IPSubnet getDestination() {
        return this.destination;
    }

    public Nexthop getNexthop() {
        return this.nexthop;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="destination")
    public void setDestination(IPSubnet destination) {
        this.destination = destination;
    }

    @JsonProperty(value="nexthop")
    public void setNexthop(Nexthop nexthop) {
        this.nexthop = nexthop;
    }

    @Override
    public String toString() {
        return "BaseRoute(name=" + this.getName() + ", description=" + this.getDescription() + ", destination=" + this.getDestination() + ", nexthop=" + this.getNexthop() + ")";
    }

    public static class BaseRouteBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private IPSubnet destination;
        private Nexthop nexthop;

        BaseRouteBuilder() {
        }

        public BaseRouteBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BaseRouteBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BaseRouteBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BaseRouteBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public BaseRouteBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BaseRouteBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BaseRouteBuilder destination(IPSubnet destination) {
            this.destination = destination;
            return this;
        }

        public BaseRouteBuilder nexthop(Nexthop nexthop) {
            this.nexthop = nexthop;
            return this;
        }

        public BaseRoute build() {
            return new BaseRoute(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.destination, this.nexthop);
        }

        public String toString() {
            return "BaseRoute.BaseRouteBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", destination=" + this.destination + ", nexthop=" + this.nexthop + ")";
        }
    }
}

