/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpConfig
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BgpConfig.class);
    @Max(value=0xFFFFFFFEL)
    @Min(value=1L)
    @JsonProperty(value="asn")
    public @Max(value=0xFFFFFFFEL) @Min(value=1L) Long asn = null;
    @JsonProperty(value="password")
    public String password = null;
    @JsonProperty(value="shouldRedistributeRoutes")
    public Boolean shouldRedistributeRoutes = false;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public BgpConfig() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public BgpConfig(Long asn, String password, Boolean shouldRedistributeRoutes) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setAsn(asn);
        this.setPassword(password);
        this.setShouldRedistributeRoutes(shouldRedistributeRoutes);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.BgpConfig";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static BgpConfigBuilder BgpConfigBuilder() {
        return new BgpConfigBuilder();
    }

    public Long getAsn() {
        return this.asn;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getShouldRedistributeRoutes() {
        return this.shouldRedistributeRoutes;
    }

    @JsonProperty(value="asn")
    public void setAsn(Long asn) {
        this.asn = asn;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="shouldRedistributeRoutes")
    public void setShouldRedistributeRoutes(Boolean shouldRedistributeRoutes) {
        this.shouldRedistributeRoutes = shouldRedistributeRoutes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BgpConfig)) {
            return false;
        }
        BgpConfig other = (BgpConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$asn = this.getAsn();
        Long other$asn = other.getAsn();
        if (this$asn == null ? other$asn != null : !((Object)this$asn).equals(other$asn)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Boolean this$shouldRedistributeRoutes = this.getShouldRedistributeRoutes();
        Boolean other$shouldRedistributeRoutes = other.getShouldRedistributeRoutes();
        return !(this$shouldRedistributeRoutes == null ? other$shouldRedistributeRoutes != null : !((Object)this$shouldRedistributeRoutes).equals(other$shouldRedistributeRoutes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BgpConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $asn = this.getAsn();
        result = result * 59 + ($asn == null ? 43 : ((Object)$asn).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Boolean $shouldRedistributeRoutes = this.getShouldRedistributeRoutes();
        result = result * 59 + ($shouldRedistributeRoutes == null ? 43 : ((Object)$shouldRedistributeRoutes).hashCode());
        return result;
    }

    public String toString() {
        return "BgpConfig(asn=" + this.getAsn() + ", password=" + this.getPassword() + ", shouldRedistributeRoutes=" + this.getShouldRedistributeRoutes() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class BgpConfigBuilder {
        private Long asn;
        private String password;
        private Boolean shouldRedistributeRoutes;

        BgpConfigBuilder() {
        }

        public BgpConfigBuilder asn(Long asn) {
            this.asn = asn;
            return this;
        }

        public BgpConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BgpConfigBuilder shouldRedistributeRoutes(Boolean shouldRedistributeRoutes) {
            this.shouldRedistributeRoutes = shouldRedistributeRoutes;
            return this;
        }

        public BgpConfig build() {
            return new BgpConfig(this.asn, this.password, this.shouldRedistributeRoutes);
        }

        public String toString() {
            return "BgpConfig.BgpConfigBuilder(asn=" + this.asn + ", password=" + this.password + ", shouldRedistributeRoutes=" + this.shouldRedistributeRoutes + ")";
        }
    }
}

