/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.BaseRoute;
import com.nutanix.dp1.net.networking.v4.config.BgpRouteType;
import com.nutanix.dp1.net.networking.v4.config.IPSubnet;
import com.nutanix.dp1.net.networking.v4.config.Nexthop;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpRoute
extends BaseRoute
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BgpRoute.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="bgpSessionReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String bgpSessionReference = null;
    @JsonProperty(value="bgpRouteType")
    public BgpRouteType bgpRouteType = null;

    public BgpRoute() {
    }

    public BgpRoute(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, IPSubnet destination, Nexthop nexthop, String bgpSessionReference, BgpRouteType bgpRouteType) {
        super(tenantId, extId, links, metadata, name, description, destination, nexthop);
        this.setBgpSessionReference(bgpSessionReference);
        this.setBgpRouteType(bgpRouteType);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.BgpRoute";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static BgpRouteBuilder BgpRouteBuilder() {
        return new BgpRouteBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BgpRoute)) {
            return false;
        }
        BgpRoute other = (BgpRoute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$bgpSessionReference = this.getBgpSessionReference();
        String other$bgpSessionReference = other.getBgpSessionReference();
        if (this$bgpSessionReference == null ? other$bgpSessionReference != null : !this$bgpSessionReference.equals(other$bgpSessionReference)) {
            return false;
        }
        BgpRouteType this$bgpRouteType = this.getBgpRouteType();
        BgpRouteType other$bgpRouteType = other.getBgpRouteType();
        return !(this$bgpRouteType == null ? other$bgpRouteType != null : !((Object)((Object)this$bgpRouteType)).equals((Object)other$bgpRouteType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BgpRoute;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $bgpSessionReference = this.getBgpSessionReference();
        result = result * 59 + ($bgpSessionReference == null ? 43 : $bgpSessionReference.hashCode());
        BgpRouteType $bgpRouteType = this.getBgpRouteType();
        result = result * 59 + ($bgpRouteType == null ? 43 : ((Object)((Object)$bgpRouteType)).hashCode());
        return result;
    }

    public String getBgpSessionReference() {
        return this.bgpSessionReference;
    }

    public BgpRouteType getBgpRouteType() {
        return this.bgpRouteType;
    }

    @JsonProperty(value="bgpSessionReference")
    public void setBgpSessionReference(String bgpSessionReference) {
        this.bgpSessionReference = bgpSessionReference;
    }

    @JsonProperty(value="bgpRouteType")
    public void setBgpRouteType(BgpRouteType bgpRouteType) {
        this.bgpRouteType = bgpRouteType;
    }

    @Override
    public String toString() {
        return "BgpRoute(bgpSessionReference=" + this.getBgpSessionReference() + ", bgpRouteType=" + (Object)((Object)this.getBgpRouteType()) + ")";
    }

    public static class BgpRouteBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private IPSubnet destination;
        private Nexthop nexthop;
        private String bgpSessionReference;
        private BgpRouteType bgpRouteType;

        BgpRouteBuilder() {
        }

        public BgpRouteBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BgpRouteBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BgpRouteBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BgpRouteBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public BgpRouteBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BgpRouteBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BgpRouteBuilder destination(IPSubnet destination) {
            this.destination = destination;
            return this;
        }

        public BgpRouteBuilder nexthop(Nexthop nexthop) {
            this.nexthop = nexthop;
            return this;
        }

        public BgpRouteBuilder bgpSessionReference(String bgpSessionReference) {
            this.bgpSessionReference = bgpSessionReference;
            return this;
        }

        public BgpRouteBuilder bgpRouteType(BgpRouteType bgpRouteType) {
            this.bgpRouteType = bgpRouteType;
            return this;
        }

        public BgpRoute build() {
            return new BgpRoute(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.destination, this.nexthop, this.bgpSessionReference, this.bgpRouteType);
        }

        public String toString() {
            return "BgpRoute.BgpRouteBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", destination=" + this.destination + ", nexthop=" + this.nexthop + ", bgpSessionReference=" + this.bgpSessionReference + ", bgpRouteType=" + (Object)((Object)this.bgpRouteType) + ")";
        }
    }
}

