/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.Gateway;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.Status;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpSession
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BgpSession.class);
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="localGatewayReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String localGatewayReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="remoteGatewayReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String remoteGatewayReference = null;
    @JsonProperty(value="localGatewayInterfaceIpAddress")
    public IPAddress localGatewayInterfaceIpAddress = null;
    @Max(value=1000L)
    @Min(value=300L)
    @JsonProperty(value="dynamicRoutePriority")
    public @Max(value=1000L) @Min(value=300L) Integer dynamicRoutePriority = null;
    @JsonProperty(value="password")
    public String password = null;
    @JsonProperty(value="status")
    public Status status = null;
    @JsonProperty(value="localGateway")
    public Gateway localGateway = null;
    @JsonProperty(value="remoteGateway")
    public Gateway remoteGateway = null;

    public BgpSession() {
    }

    public BgpSession(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, String localGatewayReference, String remoteGatewayReference, IPAddress localGatewayInterfaceIpAddress, Integer dynamicRoutePriority, String password, Status status, Gateway localGateway, Gateway remoteGateway) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setLocalGatewayReference(localGatewayReference);
        this.setRemoteGatewayReference(remoteGatewayReference);
        this.setLocalGatewayInterfaceIpAddress(localGatewayInterfaceIpAddress);
        this.setDynamicRoutePriority(dynamicRoutePriority);
        this.setPassword(password);
        this.setStatus(status);
        this.setLocalGateway(localGateway);
        this.setRemoteGateway(remoteGateway);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.BgpSession";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static BgpSessionBuilder BgpSessionBuilder() {
        return new BgpSessionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BgpSession)) {
            return false;
        }
        BgpSession other = (BgpSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$localGatewayReference = this.getLocalGatewayReference();
        String other$localGatewayReference = other.getLocalGatewayReference();
        if (this$localGatewayReference == null ? other$localGatewayReference != null : !this$localGatewayReference.equals(other$localGatewayReference)) {
            return false;
        }
        String this$remoteGatewayReference = this.getRemoteGatewayReference();
        String other$remoteGatewayReference = other.getRemoteGatewayReference();
        if (this$remoteGatewayReference == null ? other$remoteGatewayReference != null : !this$remoteGatewayReference.equals(other$remoteGatewayReference)) {
            return false;
        }
        IPAddress this$localGatewayInterfaceIpAddress = this.getLocalGatewayInterfaceIpAddress();
        IPAddress other$localGatewayInterfaceIpAddress = other.getLocalGatewayInterfaceIpAddress();
        if (this$localGatewayInterfaceIpAddress == null ? other$localGatewayInterfaceIpAddress != null : !((Object)this$localGatewayInterfaceIpAddress).equals(other$localGatewayInterfaceIpAddress)) {
            return false;
        }
        Integer this$dynamicRoutePriority = this.getDynamicRoutePriority();
        Integer other$dynamicRoutePriority = other.getDynamicRoutePriority();
        if (this$dynamicRoutePriority == null ? other$dynamicRoutePriority != null : !((Object)this$dynamicRoutePriority).equals(other$dynamicRoutePriority)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Gateway this$localGateway = this.getLocalGateway();
        Gateway other$localGateway = other.getLocalGateway();
        if (this$localGateway == null ? other$localGateway != null : !((Object)this$localGateway).equals(other$localGateway)) {
            return false;
        }
        Gateway this$remoteGateway = this.getRemoteGateway();
        Gateway other$remoteGateway = other.getRemoteGateway();
        return !(this$remoteGateway == null ? other$remoteGateway != null : !((Object)this$remoteGateway).equals(other$remoteGateway));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BgpSession;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $localGatewayReference = this.getLocalGatewayReference();
        result = result * 59 + ($localGatewayReference == null ? 43 : $localGatewayReference.hashCode());
        String $remoteGatewayReference = this.getRemoteGatewayReference();
        result = result * 59 + ($remoteGatewayReference == null ? 43 : $remoteGatewayReference.hashCode());
        IPAddress $localGatewayInterfaceIpAddress = this.getLocalGatewayInterfaceIpAddress();
        result = result * 59 + ($localGatewayInterfaceIpAddress == null ? 43 : ((Object)$localGatewayInterfaceIpAddress).hashCode());
        Integer $dynamicRoutePriority = this.getDynamicRoutePriority();
        result = result * 59 + ($dynamicRoutePriority == null ? 43 : ((Object)$dynamicRoutePriority).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Gateway $localGateway = this.getLocalGateway();
        result = result * 59 + ($localGateway == null ? 43 : ((Object)$localGateway).hashCode());
        Gateway $remoteGateway = this.getRemoteGateway();
        result = result * 59 + ($remoteGateway == null ? 43 : ((Object)$remoteGateway).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocalGatewayReference() {
        return this.localGatewayReference;
    }

    public String getRemoteGatewayReference() {
        return this.remoteGatewayReference;
    }

    public IPAddress getLocalGatewayInterfaceIpAddress() {
        return this.localGatewayInterfaceIpAddress;
    }

    public Integer getDynamicRoutePriority() {
        return this.dynamicRoutePriority;
    }

    public String getPassword() {
        return this.password;
    }

    public Status getStatus() {
        return this.status;
    }

    public Gateway getLocalGateway() {
        return this.localGateway;
    }

    public Gateway getRemoteGateway() {
        return this.remoteGateway;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="localGatewayReference")
    public void setLocalGatewayReference(String localGatewayReference) {
        this.localGatewayReference = localGatewayReference;
    }

    @JsonProperty(value="remoteGatewayReference")
    public void setRemoteGatewayReference(String remoteGatewayReference) {
        this.remoteGatewayReference = remoteGatewayReference;
    }

    @JsonProperty(value="localGatewayInterfaceIpAddress")
    public void setLocalGatewayInterfaceIpAddress(IPAddress localGatewayInterfaceIpAddress) {
        this.localGatewayInterfaceIpAddress = localGatewayInterfaceIpAddress;
    }

    @JsonProperty(value="dynamicRoutePriority")
    public void setDynamicRoutePriority(Integer dynamicRoutePriority) {
        this.dynamicRoutePriority = dynamicRoutePriority;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty(value="localGateway")
    public void setLocalGateway(Gateway localGateway) {
        this.localGateway = localGateway;
    }

    @JsonProperty(value="remoteGateway")
    public void setRemoteGateway(Gateway remoteGateway) {
        this.remoteGateway = remoteGateway;
    }

    @Override
    public String toString() {
        return "BgpSession(name=" + this.getName() + ", description=" + this.getDescription() + ", localGatewayReference=" + this.getLocalGatewayReference() + ", remoteGatewayReference=" + this.getRemoteGatewayReference() + ", localGatewayInterfaceIpAddress=" + this.getLocalGatewayInterfaceIpAddress() + ", dynamicRoutePriority=" + this.getDynamicRoutePriority() + ", password=" + this.getPassword() + ", status=" + this.getStatus() + ", localGateway=" + this.getLocalGateway() + ", remoteGateway=" + this.getRemoteGateway() + ")";
    }

    public static class BgpSessionBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private String localGatewayReference;
        private String remoteGatewayReference;
        private IPAddress localGatewayInterfaceIpAddress;
        private Integer dynamicRoutePriority;
        private String password;
        private Status status;
        private Gateway localGateway;
        private Gateway remoteGateway;

        BgpSessionBuilder() {
        }

        public BgpSessionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BgpSessionBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BgpSessionBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BgpSessionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public BgpSessionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BgpSessionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BgpSessionBuilder localGatewayReference(String localGatewayReference) {
            this.localGatewayReference = localGatewayReference;
            return this;
        }

        public BgpSessionBuilder remoteGatewayReference(String remoteGatewayReference) {
            this.remoteGatewayReference = remoteGatewayReference;
            return this;
        }

        public BgpSessionBuilder localGatewayInterfaceIpAddress(IPAddress localGatewayInterfaceIpAddress) {
            this.localGatewayInterfaceIpAddress = localGatewayInterfaceIpAddress;
            return this;
        }

        public BgpSessionBuilder dynamicRoutePriority(Integer dynamicRoutePriority) {
            this.dynamicRoutePriority = dynamicRoutePriority;
            return this;
        }

        public BgpSessionBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BgpSessionBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public BgpSessionBuilder localGateway(Gateway localGateway) {
            this.localGateway = localGateway;
            return this;
        }

        public BgpSessionBuilder remoteGateway(Gateway remoteGateway) {
            this.remoteGateway = remoteGateway;
            return this;
        }

        public BgpSession build() {
            return new BgpSession(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.localGatewayReference, this.remoteGatewayReference, this.localGatewayInterfaceIpAddress, this.dynamicRoutePriority, this.password, this.status, this.localGateway, this.remoteGateway);
        }

        public String toString() {
            return "BgpSession.BgpSessionBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", localGatewayReference=" + this.localGatewayReference + ", remoteGatewayReference=" + this.remoteGatewayReference + ", localGatewayInterfaceIpAddress=" + this.localGatewayInterfaceIpAddress + ", dynamicRoutePriority=" + this.dynamicRoutePriority + ", password=" + this.password + ", status=" + this.status + ", localGateway=" + this.localGateway + ", remoteGateway=" + this.remoteGateway + ")";
        }
    }
}

