/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.BgpSession;
import com.nutanix.dp1.net.networking.v4.config.Gateway;
import com.nutanix.dp1.net.networking.v4.config.GatewayProjection;
import com.nutanix.dp1.net.networking.v4.config.Status;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpSessionProjection
extends BgpSession
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BgpSessionProjection.class);
    @JsonProperty(value="gatewayProjection")
    public GatewayProjection gatewayProjection = null;

    public BgpSessionProjection() {
    }

    public BgpSessionProjection(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, String localGatewayReference, String remoteGatewayReference, IPAddress localGatewayInterfaceIpAddress, Integer dynamicRoutePriority, String password, Status status, Gateway localGateway, Gateway remoteGateway, GatewayProjection gatewayProjection) {
        super(tenantId, extId, links, metadata, name, description, localGatewayReference, remoteGatewayReference, localGatewayInterfaceIpAddress, dynamicRoutePriority, password, status, localGateway, remoteGateway);
        this.setGatewayProjection(gatewayProjection);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.BgpSessionProjection";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static BgpSessionProjectionBuilder BgpSessionProjectionBuilder() {
        return new BgpSessionProjectionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BgpSessionProjection)) {
            return false;
        }
        BgpSessionProjection other = (BgpSessionProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewayProjection this$gatewayProjection = this.getGatewayProjection();
        GatewayProjection other$gatewayProjection = other.getGatewayProjection();
        return !(this$gatewayProjection == null ? other$gatewayProjection != null : !((Object)this$gatewayProjection).equals(other$gatewayProjection));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BgpSessionProjection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GatewayProjection $gatewayProjection = this.getGatewayProjection();
        result = result * 59 + ($gatewayProjection == null ? 43 : ((Object)$gatewayProjection).hashCode());
        return result;
    }

    public GatewayProjection getGatewayProjection() {
        return this.gatewayProjection;
    }

    @JsonProperty(value="gatewayProjection")
    public void setGatewayProjection(GatewayProjection gatewayProjection) {
        this.gatewayProjection = gatewayProjection;
    }

    @Override
    public String toString() {
        return "BgpSessionProjection(gatewayProjection=" + this.getGatewayProjection() + ")";
    }

    public static class BgpSessionProjectionBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private String localGatewayReference;
        private String remoteGatewayReference;
        private IPAddress localGatewayInterfaceIpAddress;
        private Integer dynamicRoutePriority;
        private String password;
        private Status status;
        private Gateway localGateway;
        private Gateway remoteGateway;
        private GatewayProjection gatewayProjection;

        BgpSessionProjectionBuilder() {
        }

        public BgpSessionProjectionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BgpSessionProjectionBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BgpSessionProjectionBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BgpSessionProjectionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public BgpSessionProjectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BgpSessionProjectionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BgpSessionProjectionBuilder localGatewayReference(String localGatewayReference) {
            this.localGatewayReference = localGatewayReference;
            return this;
        }

        public BgpSessionProjectionBuilder remoteGatewayReference(String remoteGatewayReference) {
            this.remoteGatewayReference = remoteGatewayReference;
            return this;
        }

        public BgpSessionProjectionBuilder localGatewayInterfaceIpAddress(IPAddress localGatewayInterfaceIpAddress) {
            this.localGatewayInterfaceIpAddress = localGatewayInterfaceIpAddress;
            return this;
        }

        public BgpSessionProjectionBuilder dynamicRoutePriority(Integer dynamicRoutePriority) {
            this.dynamicRoutePriority = dynamicRoutePriority;
            return this;
        }

        public BgpSessionProjectionBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BgpSessionProjectionBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public BgpSessionProjectionBuilder localGateway(Gateway localGateway) {
            this.localGateway = localGateway;
            return this;
        }

        public BgpSessionProjectionBuilder remoteGateway(Gateway remoteGateway) {
            this.remoteGateway = remoteGateway;
            return this;
        }

        public BgpSessionProjectionBuilder gatewayProjection(GatewayProjection gatewayProjection) {
            this.gatewayProjection = gatewayProjection;
            return this;
        }

        public BgpSessionProjection build() {
            return new BgpSessionProjection(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.localGatewayReference, this.remoteGatewayReference, this.localGatewayInterfaceIpAddress, this.dynamicRoutePriority, this.password, this.status, this.localGateway, this.remoteGateway, this.gatewayProjection);
        }

        public String toString() {
            return "BgpSessionProjection.BgpSessionProjectionBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", localGatewayReference=" + this.localGatewayReference + ", remoteGatewayReference=" + this.remoteGatewayReference + ", localGatewayInterfaceIpAddress=" + this.localGatewayInterfaceIpAddress + ", dynamicRoutePriority=" + this.dynamicRoutePriority + ", password=" + this.password + ", status=" + this.status + ", localGateway=" + this.localGateway + ", remoteGateway=" + this.remoteGateway + ", gatewayProjection=" + this.gatewayProjection + ")";
        }
    }
}

