/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bridge
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Bridge.class);
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Size(max=128)
    @JsonProperty(value="existingBridgeName")
    public @Size(max=128) String existingBridgeName = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterReference = null;

    public Bridge() {
    }

    public Bridge(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, String existingBridgeName, String clusterReference) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setExistingBridgeName(existingBridgeName);
        this.setClusterReference(clusterReference);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Bridge";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static BridgeBuilder BridgeBuilder() {
        return new BridgeBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bridge)) {
            return false;
        }
        Bridge other = (Bridge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$existingBridgeName = this.getExistingBridgeName();
        String other$existingBridgeName = other.getExistingBridgeName();
        if (this$existingBridgeName == null ? other$existingBridgeName != null : !this$existingBridgeName.equals(other$existingBridgeName)) {
            return false;
        }
        String this$clusterReference = this.getClusterReference();
        String other$clusterReference = other.getClusterReference();
        return !(this$clusterReference == null ? other$clusterReference != null : !this$clusterReference.equals(other$clusterReference));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Bridge;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $existingBridgeName = this.getExistingBridgeName();
        result = result * 59 + ($existingBridgeName == null ? 43 : $existingBridgeName.hashCode());
        String $clusterReference = this.getClusterReference();
        result = result * 59 + ($clusterReference == null ? 43 : $clusterReference.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExistingBridgeName() {
        return this.existingBridgeName;
    }

    public String getClusterReference() {
        return this.clusterReference;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="existingBridgeName")
    public void setExistingBridgeName(String existingBridgeName) {
        this.existingBridgeName = existingBridgeName;
    }

    @JsonProperty(value="clusterReference")
    public void setClusterReference(String clusterReference) {
        this.clusterReference = clusterReference;
    }

    @Override
    public String toString() {
        return "Bridge(name=" + this.getName() + ", description=" + this.getDescription() + ", existingBridgeName=" + this.getExistingBridgeName() + ", clusterReference=" + this.getClusterReference() + ")";
    }

    public static class BridgeBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private String existingBridgeName;
        private String clusterReference;

        BridgeBuilder() {
        }

        public BridgeBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BridgeBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BridgeBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BridgeBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public BridgeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BridgeBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BridgeBuilder existingBridgeName(String existingBridgeName) {
            this.existingBridgeName = existingBridgeName;
            return this;
        }

        public BridgeBuilder clusterReference(String clusterReference) {
            this.clusterReference = clusterReference;
            return this;
        }

        public Bridge build() {
            return new Bridge(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.existingBridgeName, this.clusterReference);
        }

        public String toString() {
            return "Bridge.BridgeBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", existingBridgeName=" + this.existingBridgeName + ", clusterReference=" + this.clusterReference + ")";
        }
    }
}

