/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPv4Address;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.Host;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Cluster.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="extId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String extId = null;
    @Size(min=1, max=64)
    @JsonProperty(value="hosts")
    public @Size(min=1, max=64) List<Host> hosts = null;
    @JsonProperty(value="gatewayIpAddress")
    public IPv4Address gatewayIpAddress = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public Cluster() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public Cluster(String extId, List<Host> hosts, IPv4Address gatewayIpAddress) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setExtId(extId);
        this.setHosts(hosts);
        this.setGatewayIpAddress(gatewayIpAddress);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.Cluster";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static ClusterBuilder ClusterBuilder() {
        return new ClusterBuilder();
    }

    public String getExtId() {
        return this.extId;
    }

    public List<Host> getHosts() {
        return this.hosts;
    }

    public IPv4Address getGatewayIpAddress() {
        return this.gatewayIpAddress;
    }

    @JsonProperty(value="extId")
    public void setExtId(String extId) {
        this.extId = extId;
    }

    @JsonProperty(value="hosts")
    public void setHosts(List<Host> hosts) {
        this.hosts = hosts;
    }

    @JsonProperty(value="gatewayIpAddress")
    public void setGatewayIpAddress(IPv4Address gatewayIpAddress) {
        this.gatewayIpAddress = gatewayIpAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$extId = this.getExtId();
        String other$extId = other.getExtId();
        if (this$extId == null ? other$extId != null : !this$extId.equals(other$extId)) {
            return false;
        }
        List<Host> this$hosts = this.getHosts();
        List<Host> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        IPv4Address this$gatewayIpAddress = this.getGatewayIpAddress();
        IPv4Address other$gatewayIpAddress = other.getGatewayIpAddress();
        return !(this$gatewayIpAddress == null ? other$gatewayIpAddress != null : !((Object)this$gatewayIpAddress).equals(other$gatewayIpAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cluster;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $extId = this.getExtId();
        result = result * 59 + ($extId == null ? 43 : $extId.hashCode());
        List<Host> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        IPv4Address $gatewayIpAddress = this.getGatewayIpAddress();
        result = result * 59 + ($gatewayIpAddress == null ? 43 : ((Object)$gatewayIpAddress).hashCode());
        return result;
    }

    public String toString() {
        return "Cluster(extId=" + this.getExtId() + ", hosts=" + this.getHosts() + ", gatewayIpAddress=" + this.getGatewayIpAddress() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class ClusterBuilder {
        private String extId;
        private List<Host> hosts;
        private IPv4Address gatewayIpAddress;

        ClusterBuilder() {
        }

        public ClusterBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ClusterBuilder hosts(List<Host> hosts) {
            this.hosts = hosts;
            return this;
        }

        public ClusterBuilder gatewayIpAddress(IPv4Address gatewayIpAddress) {
            this.gatewayIpAddress = gatewayIpAddress;
            return this;
        }

        public Cluster build() {
            return new Cluster(this.extId, this.hosts, this.gatewayIpAddress);
        }

        public String toString() {
            return "Cluster.ClusterBuilder(extId=" + this.extId + ", hosts=" + this.hosts + ", gatewayIpAddress=" + this.gatewayIpAddress + ")";
        }
    }
}

