/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.Capability;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterCapability
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(ClusterCapability.class);
    @Size(min=0, max=10)
    private @Size(min=0, max=10) List<Capability> capabilities = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterId = null;

    public ClusterCapability() {
    }

    public ClusterCapability(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String clusterId, List<Capability> capabilities) {
        super(tenantId, extId, links, metadata);
        this.setClusterId(clusterId);
        this.setCapabilities(capabilities);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.ClusterCapability";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCapabilities(List<Capability> capabilities) {
        if (this.capabilities == null) {
            this.capabilities = capabilities;
        } else {
            log.warn("Read-only property capabilities already contains a non-null value and cannot be set again");
        }
    }

    public static ClusterCapabilityBuilder ClusterCapabilityBuilder() {
        return new ClusterCapabilityBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterCapability)) {
            return false;
        }
        ClusterCapability other = (ClusterCapability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Capability> this$capabilities = this.getCapabilities();
        List<Capability> other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        return !(this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClusterCapability;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Capability> $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        return result;
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty(value="clusterId")
    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public String toString() {
        return "ClusterCapability(capabilities=" + this.getCapabilities() + ", clusterId=" + this.getClusterId() + ")";
    }

    public static class ClusterCapabilityBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String clusterId;
        private List<Capability> capabilities;

        ClusterCapabilityBuilder() {
        }

        public ClusterCapabilityBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ClusterCapabilityBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ClusterCapabilityBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ClusterCapabilityBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ClusterCapabilityBuilder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public ClusterCapabilityBuilder capabilities(List<Capability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public ClusterCapability build() {
            return new ClusterCapability(this.tenantId, this.extId, this.links, this.metadata, this.clusterId, this.capabilities);
        }

        public String toString() {
            return "ClusterCapability.ClusterCapabilityBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", capabilities=" + this.capabilities + ")";
        }
    }
}

