/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpOptions
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(DhcpOptions.class);
    @Size(min=0, max=32)
    @JsonProperty(value="domainNameServers")
    public @Size(min=0, max=32) List<IPAddress> domainNameServers = null;
    @Pattern(regexp="^([a-z0-9]+(-[a-z0-9]+)*\\.)+([a-z0-9]+(-[a-z0-9]+)*){1,63}$")
    @Size(max=255)
    @JsonProperty(value="domainName")
    public @Pattern(regexp="^([a-z0-9]+(-[a-z0-9]+)*\\.)+([a-z0-9]+(-[a-z0-9]+)*){1,63}$") @Size(max=255) String domainName = null;
    @Size(min=0, max=32)
    @JsonProperty(value="searchDomains")
    public @Size(min=0, max=32) List<String> searchDomains = null;
    @Size(max=255)
    @JsonProperty(value="tftpServerName")
    public @Size(max=255) String tftpServerName = null;
    @Size(max=1000)
    @JsonProperty(value="bootFileName")
    public @Size(max=1000) String bootFileName = null;
    @Size(min=0, max=32)
    @JsonProperty(value="ntpServers")
    public @Size(min=0, max=32) List<IPAddress> ntpServers = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public DhcpOptions() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public DhcpOptions(List<IPAddress> domainNameServers, String domainName, List<String> searchDomains, String tftpServerName, String bootFileName, List<IPAddress> ntpServers) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setDomainNameServers(domainNameServers);
        this.setDomainName(domainName);
        this.setSearchDomains(searchDomains);
        this.setTftpServerName(tftpServerName);
        this.setBootFileName(bootFileName);
        this.setNtpServers(ntpServers);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.DhcpOptions";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static DhcpOptionsBuilder DhcpOptionsBuilder() {
        return new DhcpOptionsBuilder();
    }

    public List<IPAddress> getDomainNameServers() {
        return this.domainNameServers;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<String> getSearchDomains() {
        return this.searchDomains;
    }

    public String getTftpServerName() {
        return this.tftpServerName;
    }

    public String getBootFileName() {
        return this.bootFileName;
    }

    public List<IPAddress> getNtpServers() {
        return this.ntpServers;
    }

    @JsonProperty(value="domainNameServers")
    public void setDomainNameServers(List<IPAddress> domainNameServers) {
        this.domainNameServers = domainNameServers;
    }

    @JsonProperty(value="domainName")
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @JsonProperty(value="searchDomains")
    public void setSearchDomains(List<String> searchDomains) {
        this.searchDomains = searchDomains;
    }

    @JsonProperty(value="tftpServerName")
    public void setTftpServerName(String tftpServerName) {
        this.tftpServerName = tftpServerName;
    }

    @JsonProperty(value="bootFileName")
    public void setBootFileName(String bootFileName) {
        this.bootFileName = bootFileName;
    }

    @JsonProperty(value="ntpServers")
    public void setNtpServers(List<IPAddress> ntpServers) {
        this.ntpServers = ntpServers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IPAddress> this$domainNameServers = this.getDomainNameServers();
        List<IPAddress> other$domainNameServers = other.getDomainNameServers();
        if (this$domainNameServers == null ? other$domainNameServers != null : !((Object)this$domainNameServers).equals(other$domainNameServers)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        List<String> this$searchDomains = this.getSearchDomains();
        List<String> other$searchDomains = other.getSearchDomains();
        if (this$searchDomains == null ? other$searchDomains != null : !((Object)this$searchDomains).equals(other$searchDomains)) {
            return false;
        }
        String this$tftpServerName = this.getTftpServerName();
        String other$tftpServerName = other.getTftpServerName();
        if (this$tftpServerName == null ? other$tftpServerName != null : !this$tftpServerName.equals(other$tftpServerName)) {
            return false;
        }
        String this$bootFileName = this.getBootFileName();
        String other$bootFileName = other.getBootFileName();
        if (this$bootFileName == null ? other$bootFileName != null : !this$bootFileName.equals(other$bootFileName)) {
            return false;
        }
        List<IPAddress> this$ntpServers = this.getNtpServers();
        List<IPAddress> other$ntpServers = other.getNtpServers();
        return !(this$ntpServers == null ? other$ntpServers != null : !((Object)this$ntpServers).equals(other$ntpServers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DhcpOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IPAddress> $domainNameServers = this.getDomainNameServers();
        result = result * 59 + ($domainNameServers == null ? 43 : ((Object)$domainNameServers).hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        List<String> $searchDomains = this.getSearchDomains();
        result = result * 59 + ($searchDomains == null ? 43 : ((Object)$searchDomains).hashCode());
        String $tftpServerName = this.getTftpServerName();
        result = result * 59 + ($tftpServerName == null ? 43 : $tftpServerName.hashCode());
        String $bootFileName = this.getBootFileName();
        result = result * 59 + ($bootFileName == null ? 43 : $bootFileName.hashCode());
        List<IPAddress> $ntpServers = this.getNtpServers();
        result = result * 59 + ($ntpServers == null ? 43 : ((Object)$ntpServers).hashCode());
        return result;
    }

    public String toString() {
        return "DhcpOptions(domainNameServers=" + this.getDomainNameServers() + ", domainName=" + this.getDomainName() + ", searchDomains=" + this.getSearchDomains() + ", tftpServerName=" + this.getTftpServerName() + ", bootFileName=" + this.getBootFileName() + ", ntpServers=" + this.getNtpServers() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class DhcpOptionsBuilder {
        private List<IPAddress> domainNameServers;
        private String domainName;
        private List<String> searchDomains;
        private String tftpServerName;
        private String bootFileName;
        private List<IPAddress> ntpServers;

        DhcpOptionsBuilder() {
        }

        public DhcpOptionsBuilder domainNameServers(List<IPAddress> domainNameServers) {
            this.domainNameServers = domainNameServers;
            return this;
        }

        public DhcpOptionsBuilder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public DhcpOptionsBuilder searchDomains(List<String> searchDomains) {
            this.searchDomains = searchDomains;
            return this;
        }

        public DhcpOptionsBuilder tftpServerName(String tftpServerName) {
            this.tftpServerName = tftpServerName;
            return this;
        }

        public DhcpOptionsBuilder bootFileName(String bootFileName) {
            this.bootFileName = bootFileName;
            return this;
        }

        public DhcpOptionsBuilder ntpServers(List<IPAddress> ntpServers) {
            this.ntpServers = ntpServers;
            return this;
        }

        public DhcpOptions build() {
            return new DhcpOptions(this.domainNameServers, this.domainName, this.searchDomains, this.tftpServerName, this.bootFileName, this.ntpServers);
        }

        public String toString() {
            return "DhcpOptions.DhcpOptionsBuilder(domainNameServers=" + this.domainNameServers + ", domainName=" + this.domainName + ", searchDomains=" + this.searchDomains + ", tftpServerName=" + this.tftpServerName + ", bootFileName=" + this.bootFileName + ", ntpServers=" + this.ntpServers + ")";
        }
    }
}

