/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.GatewayNodeReference;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalSubnet
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(ExternalSubnet.class);
    @Size(min=0, max=4)
    private @Size(min=0, max=4) List<GatewayNodeReference> activeGatewayNodes = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="subnetReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String subnetReference = null;
    @Size(min=0, max=4)
    @JsonProperty(value="externalIps")
    public @Size(min=0, max=4) List<IPAddress> externalIps = null;
    @Size(min=3, max=32)
    @JsonProperty(value="gatewayNodes")
    public @Size(min=3, max=32) List<String> gatewayNodes = null;
    @Max(value=4L)
    @Min(value=1L)
    @JsonProperty(value="activeGatewayCount")
    public @Max(value=4L) @Min(value=1L) Integer activeGatewayCount = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public ExternalSubnet() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public ExternalSubnet(String subnetReference, List<IPAddress> externalIps, List<String> gatewayNodes, List<GatewayNodeReference> activeGatewayNodes, Integer activeGatewayCount) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setSubnetReference(subnetReference);
        this.setExternalIps(externalIps);
        this.setGatewayNodes(gatewayNodes);
        this.setActiveGatewayNodes(activeGatewayNodes);
        this.setActiveGatewayCount(activeGatewayCount);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.ExternalSubnet";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setActiveGatewayNodes(List<GatewayNodeReference> activeGatewayNodes) {
        if (this.activeGatewayNodes == null) {
            this.activeGatewayNodes = activeGatewayNodes;
        } else {
            log.warn("Read-only property activeGatewayNodes already contains a non-null value and cannot be set again");
        }
    }

    public static ExternalSubnetBuilder ExternalSubnetBuilder() {
        return new ExternalSubnetBuilder();
    }

    public List<GatewayNodeReference> getActiveGatewayNodes() {
        return this.activeGatewayNodes;
    }

    public String getSubnetReference() {
        return this.subnetReference;
    }

    public List<IPAddress> getExternalIps() {
        return this.externalIps;
    }

    public List<String> getGatewayNodes() {
        return this.gatewayNodes;
    }

    public Integer getActiveGatewayCount() {
        return this.activeGatewayCount;
    }

    @JsonProperty(value="subnetReference")
    public void setSubnetReference(String subnetReference) {
        this.subnetReference = subnetReference;
    }

    @JsonProperty(value="externalIps")
    public void setExternalIps(List<IPAddress> externalIps) {
        this.externalIps = externalIps;
    }

    @JsonProperty(value="gatewayNodes")
    public void setGatewayNodes(List<String> gatewayNodes) {
        this.gatewayNodes = gatewayNodes;
    }

    @JsonProperty(value="activeGatewayCount")
    public void setActiveGatewayCount(Integer activeGatewayCount) {
        this.activeGatewayCount = activeGatewayCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalSubnet)) {
            return false;
        }
        ExternalSubnet other = (ExternalSubnet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GatewayNodeReference> this$activeGatewayNodes = this.getActiveGatewayNodes();
        List<GatewayNodeReference> other$activeGatewayNodes = other.getActiveGatewayNodes();
        if (this$activeGatewayNodes == null ? other$activeGatewayNodes != null : !((Object)this$activeGatewayNodes).equals(other$activeGatewayNodes)) {
            return false;
        }
        String this$subnetReference = this.getSubnetReference();
        String other$subnetReference = other.getSubnetReference();
        if (this$subnetReference == null ? other$subnetReference != null : !this$subnetReference.equals(other$subnetReference)) {
            return false;
        }
        List<IPAddress> this$externalIps = this.getExternalIps();
        List<IPAddress> other$externalIps = other.getExternalIps();
        if (this$externalIps == null ? other$externalIps != null : !((Object)this$externalIps).equals(other$externalIps)) {
            return false;
        }
        List<String> this$gatewayNodes = this.getGatewayNodes();
        List<String> other$gatewayNodes = other.getGatewayNodes();
        if (this$gatewayNodes == null ? other$gatewayNodes != null : !((Object)this$gatewayNodes).equals(other$gatewayNodes)) {
            return false;
        }
        Integer this$activeGatewayCount = this.getActiveGatewayCount();
        Integer other$activeGatewayCount = other.getActiveGatewayCount();
        return !(this$activeGatewayCount == null ? other$activeGatewayCount != null : !((Object)this$activeGatewayCount).equals(other$activeGatewayCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalSubnet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GatewayNodeReference> $activeGatewayNodes = this.getActiveGatewayNodes();
        result = result * 59 + ($activeGatewayNodes == null ? 43 : ((Object)$activeGatewayNodes).hashCode());
        String $subnetReference = this.getSubnetReference();
        result = result * 59 + ($subnetReference == null ? 43 : $subnetReference.hashCode());
        List<IPAddress> $externalIps = this.getExternalIps();
        result = result * 59 + ($externalIps == null ? 43 : ((Object)$externalIps).hashCode());
        List<String> $gatewayNodes = this.getGatewayNodes();
        result = result * 59 + ($gatewayNodes == null ? 43 : ((Object)$gatewayNodes).hashCode());
        Integer $activeGatewayCount = this.getActiveGatewayCount();
        result = result * 59 + ($activeGatewayCount == null ? 43 : ((Object)$activeGatewayCount).hashCode());
        return result;
    }

    public String toString() {
        return "ExternalSubnet(activeGatewayNodes=" + this.getActiveGatewayNodes() + ", subnetReference=" + this.getSubnetReference() + ", externalIps=" + this.getExternalIps() + ", gatewayNodes=" + this.getGatewayNodes() + ", activeGatewayCount=" + this.getActiveGatewayCount() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class ExternalSubnetBuilder {
        private String subnetReference;
        private List<IPAddress> externalIps;
        private List<String> gatewayNodes;
        private List<GatewayNodeReference> activeGatewayNodes;
        private Integer activeGatewayCount;

        ExternalSubnetBuilder() {
        }

        public ExternalSubnetBuilder subnetReference(String subnetReference) {
            this.subnetReference = subnetReference;
            return this;
        }

        public ExternalSubnetBuilder externalIps(List<IPAddress> externalIps) {
            this.externalIps = externalIps;
            return this;
        }

        public ExternalSubnetBuilder gatewayNodes(List<String> gatewayNodes) {
            this.gatewayNodes = gatewayNodes;
            return this;
        }

        public ExternalSubnetBuilder activeGatewayNodes(List<GatewayNodeReference> activeGatewayNodes) {
            this.activeGatewayNodes = activeGatewayNodes;
            return this;
        }

        public ExternalSubnetBuilder activeGatewayCount(Integer activeGatewayCount) {
            this.activeGatewayCount = activeGatewayCount;
            return this;
        }

        public ExternalSubnet build() {
            return new ExternalSubnet(this.subnetReference, this.externalIps, this.gatewayNodes, this.activeGatewayNodes, this.activeGatewayCount);
        }

        public String toString() {
            return "ExternalSubnet.ExternalSubnetBuilder(subnetReference=" + this.subnetReference + ", externalIps=" + this.externalIps + ", gatewayNodes=" + this.gatewayNodes + ", activeGatewayNodes=" + this.activeGatewayNodes + ", activeGatewayCount=" + this.activeGatewayCount + ")";
        }
    }
}

