/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatingIPv6Address
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(FloatingIPv6Address.class);
    @Pattern(regexp="^(?:(?:(?:[A-Fa-f0-9]{1,4}:){6}|(?=(?:[A-Fa-f0-9]{0,4}:){0,6}(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$)(([0-9a-fA-F]{1,4}:){0,5}|:)((:[0-9a-fA-F]{1,4}){1,5}:|:)|::(?:[A-Fa-f0-9]{1,4}:){5})(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])|(?:[A-Fa-f0-9]{1,4}:){7}[A-Fa-f0-9]{1,4}|(?=(?:[A-Fa-f0-9]{0,4}:){0,7}[A-Fa-f0-9]{0,4}$)(([0-9a-fA-F]{1,4}:){1,7}|:)((:[0-9a-fA-F]{1,4}){1,7}|:)|(?:[A-Fa-f0-9]{1,4}:){7}:|:(:[A-Fa-f0-9]{1,4}){7})$")
    @JsonProperty(value="value")
    public @Pattern(regexp="^(?:(?:(?:[A-Fa-f0-9]{1,4}:){6}|(?=(?:[A-Fa-f0-9]{0,4}:){0,6}(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$)(([0-9a-fA-F]{1,4}:){0,5}|:)((:[0-9a-fA-F]{1,4}){1,5}:|:)|::(?:[A-Fa-f0-9]{1,4}:){5})(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])|(?:[A-Fa-f0-9]{1,4}:){7}[A-Fa-f0-9]{1,4}|(?=(?:[A-Fa-f0-9]{0,4}:){0,7}[A-Fa-f0-9]{0,4}$)(([0-9a-fA-F]{1,4}:){1,7}|:)((:[0-9a-fA-F]{1,4}){1,7}|:)|(?:[A-Fa-f0-9]{1,4}:){7}:|:(:[A-Fa-f0-9]{1,4}){7})$") String value = null;
    @Max(value=128L)
    @Min(value=0L)
    @JsonProperty(value="prefixLength")
    public @Max(value=128L) @Min(value=0L) Integer prefixLength = 128;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public FloatingIPv6Address() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public FloatingIPv6Address(String value, Integer prefixLength) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setValue(value);
        this.setPrefixLength(prefixLength);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.FloatingIPv6Address";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static FloatingIPv6AddressBuilder FloatingIPv6AddressBuilder() {
        return new FloatingIPv6AddressBuilder();
    }

    public String getValue() {
        return this.value;
    }

    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="prefixLength")
    public void setPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatingIPv6Address)) {
            return false;
        }
        FloatingIPv6Address other = (FloatingIPv6Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Integer this$prefixLength = this.getPrefixLength();
        Integer other$prefixLength = other.getPrefixLength();
        return !(this$prefixLength == null ? other$prefixLength != null : !((Object)this$prefixLength).equals(other$prefixLength));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FloatingIPv6Address;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Integer $prefixLength = this.getPrefixLength();
        result = result * 59 + ($prefixLength == null ? 43 : ((Object)$prefixLength).hashCode());
        return result;
    }

    public String toString() {
        return "FloatingIPv6Address(value=" + this.getValue() + ", prefixLength=" + this.getPrefixLength() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class FloatingIPv6AddressBuilder {
        private String value;
        private Integer prefixLength;

        FloatingIPv6AddressBuilder() {
        }

        public FloatingIPv6AddressBuilder value(String value) {
            this.value = value;
            return this;
        }

        public FloatingIPv6AddressBuilder prefixLength(Integer prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public FloatingIPv6Address build() {
            return new FloatingIPv6Address(this.value, this.prefixLength);
        }

        public String toString() {
            return "FloatingIPv6Address.FloatingIPv6AddressBuilder(value=" + this.value + ", prefixLength=" + this.prefixLength + ")";
        }
    }
}

