/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.net.annotations.NetJsonDeserializer;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.deserializers.NetOneOfDeserializer;
import com.nutanix.dp1.net.networking.v4.config.FloatingIPAddress;
import com.nutanix.dp1.net.networking.v4.config.LoadBalancerSessionAssociation;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.PrivateIpAssociation;
import com.nutanix.dp1.net.networking.v4.config.Subnet;
import com.nutanix.dp1.net.networking.v4.config.VmNic;
import com.nutanix.dp1.net.networking.v4.config.VmNicAssociation;
import com.nutanix.dp1.net.networking.v4.config.Vpc;
import com.nutanix.dp1.net.serializers.NetOneOfSerializer;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatingIp
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(FloatingIp.class);
    private String privateIp = null;
    private String floatingIpValue = null;
    private String associationStatus = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $associationItemDiscriminator = null;
    private OneOfAssociationWrapper association = null;
    @JsonProperty(value="floatingIp")
    public FloatingIPAddress floatingIp = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="externalSubnetReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String externalSubnetReference = null;
    @JsonProperty(value="externalSubnet")
    public Subnet externalSubnet = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vmNicReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vmNicReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="loadBalancerSessionReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String loadBalancerSessionReference = null;
    @JsonProperty(value="vpc")
    public Vpc vpc = null;
    @JsonProperty(value="vmNic")
    public VmNic vmNic = null;

    public FloatingIp() {
    }

    public FloatingIp(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, Object association, FloatingIPAddress floatingIp, String externalSubnetReference, Subnet externalSubnet, String privateIp, String floatingIpValue, String associationStatus, String vpcReference, String vmNicReference, String loadBalancerSessionReference, Vpc vpc, VmNic vmNic) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setAssociationInWrapper(association);
        this.setFloatingIp(floatingIp);
        this.setExternalSubnetReference(externalSubnetReference);
        this.setExternalSubnet(externalSubnet);
        this.setPrivateIp(privateIp);
        this.setFloatingIpValue(floatingIpValue);
        this.setAssociationStatus(associationStatus);
        this.setVpcReference(vpcReference);
        this.setVmNicReference(vmNicReference);
        this.setLoadBalancerSessionReference(loadBalancerSessionReference);
        this.setVpc(vpc);
        this.setVmNic(vmNic);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.FloatingIp";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setPrivateIp(String privateIp) {
        if (this.privateIp == null) {
            this.privateIp = privateIp;
        } else {
            log.warn("Read-only property privateIp already contains a non-null value and cannot be set again");
        }
    }

    public void setFloatingIpValue(String floatingIpValue) {
        if (this.floatingIpValue == null) {
            this.floatingIpValue = floatingIpValue;
        } else {
            log.warn("Read-only property floatingIpValue already contains a non-null value and cannot be set again");
        }
    }

    public void setAssociationStatus(String associationStatus) {
        if (this.associationStatus == null) {
            this.associationStatus = associationStatus;
        } else {
            log.warn("Read-only property associationStatus already contains a non-null value and cannot be set again");
        }
    }

    public String get$associationItemDiscriminator() {
        if (this.association != null && this.$associationItemDiscriminator == null) {
            this.$associationItemDiscriminator = this.association.getDiscriminator();
        }
        return this.$associationItemDiscriminator;
    }

    @JsonIgnore
    public void setAssociationInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.association == null) {
            this.association = new OneOfAssociationWrapper();
        }
        this.association.setValue(value);
        this.$associationItemDiscriminator = this.association.getDiscriminator();
    }

    @JsonSerialize(using=NetOneOfSerializer.class)
    public Object getAssociation() {
        if (this.association == null) {
            log.debug("OneOf property association was never set. Returning null...");
            return null;
        }
        return this.association.getValue();
    }

    public static FloatingIpBuilder FloatingIpBuilder() {
        return new FloatingIpBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatingIp)) {
            return false;
        }
        FloatingIp other = (FloatingIp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$privateIp = this.getPrivateIp();
        String other$privateIp = other.getPrivateIp();
        if (this$privateIp == null ? other$privateIp != null : !this$privateIp.equals(other$privateIp)) {
            return false;
        }
        String this$floatingIpValue = this.getFloatingIpValue();
        String other$floatingIpValue = other.getFloatingIpValue();
        if (this$floatingIpValue == null ? other$floatingIpValue != null : !this$floatingIpValue.equals(other$floatingIpValue)) {
            return false;
        }
        String this$associationStatus = this.getAssociationStatus();
        String other$associationStatus = other.getAssociationStatus();
        if (this$associationStatus == null ? other$associationStatus != null : !this$associationStatus.equals(other$associationStatus)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Object this$association = this.getAssociation();
        Object other$association = other.getAssociation();
        if (this$association == null ? other$association != null : !this$association.equals(other$association)) {
            return false;
        }
        FloatingIPAddress this$floatingIp = this.getFloatingIp();
        FloatingIPAddress other$floatingIp = other.getFloatingIp();
        if (this$floatingIp == null ? other$floatingIp != null : !((Object)this$floatingIp).equals(other$floatingIp)) {
            return false;
        }
        String this$externalSubnetReference = this.getExternalSubnetReference();
        String other$externalSubnetReference = other.getExternalSubnetReference();
        if (this$externalSubnetReference == null ? other$externalSubnetReference != null : !this$externalSubnetReference.equals(other$externalSubnetReference)) {
            return false;
        }
        Subnet this$externalSubnet = this.getExternalSubnet();
        Subnet other$externalSubnet = other.getExternalSubnet();
        if (this$externalSubnet == null ? other$externalSubnet != null : !((Object)this$externalSubnet).equals(other$externalSubnet)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        String this$vmNicReference = this.getVmNicReference();
        String other$vmNicReference = other.getVmNicReference();
        if (this$vmNicReference == null ? other$vmNicReference != null : !this$vmNicReference.equals(other$vmNicReference)) {
            return false;
        }
        String this$loadBalancerSessionReference = this.getLoadBalancerSessionReference();
        String other$loadBalancerSessionReference = other.getLoadBalancerSessionReference();
        if (this$loadBalancerSessionReference == null ? other$loadBalancerSessionReference != null : !this$loadBalancerSessionReference.equals(other$loadBalancerSessionReference)) {
            return false;
        }
        Vpc this$vpc = this.getVpc();
        Vpc other$vpc = other.getVpc();
        if (this$vpc == null ? other$vpc != null : !((Object)this$vpc).equals(other$vpc)) {
            return false;
        }
        VmNic this$vmNic = this.getVmNic();
        VmNic other$vmNic = other.getVmNic();
        return !(this$vmNic == null ? other$vmNic != null : !((Object)this$vmNic).equals(other$vmNic));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FloatingIp;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $privateIp = this.getPrivateIp();
        result = result * 59 + ($privateIp == null ? 43 : $privateIp.hashCode());
        String $floatingIpValue = this.getFloatingIpValue();
        result = result * 59 + ($floatingIpValue == null ? 43 : $floatingIpValue.hashCode());
        String $associationStatus = this.getAssociationStatus();
        result = result * 59 + ($associationStatus == null ? 43 : $associationStatus.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Object $association = this.getAssociation();
        result = result * 59 + ($association == null ? 43 : $association.hashCode());
        FloatingIPAddress $floatingIp = this.getFloatingIp();
        result = result * 59 + ($floatingIp == null ? 43 : ((Object)$floatingIp).hashCode());
        String $externalSubnetReference = this.getExternalSubnetReference();
        result = result * 59 + ($externalSubnetReference == null ? 43 : $externalSubnetReference.hashCode());
        Subnet $externalSubnet = this.getExternalSubnet();
        result = result * 59 + ($externalSubnet == null ? 43 : ((Object)$externalSubnet).hashCode());
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        String $vmNicReference = this.getVmNicReference();
        result = result * 59 + ($vmNicReference == null ? 43 : $vmNicReference.hashCode());
        String $loadBalancerSessionReference = this.getLoadBalancerSessionReference();
        result = result * 59 + ($loadBalancerSessionReference == null ? 43 : $loadBalancerSessionReference.hashCode());
        Vpc $vpc = this.getVpc();
        result = result * 59 + ($vpc == null ? 43 : ((Object)$vpc).hashCode());
        VmNic $vmNic = this.getVmNic();
        result = result * 59 + ($vmNic == null ? 43 : ((Object)$vmNic).hashCode());
        return result;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public String getFloatingIpValue() {
        return this.floatingIpValue;
    }

    public String getAssociationStatus() {
        return this.associationStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public FloatingIPAddress getFloatingIp() {
        return this.floatingIp;
    }

    public String getExternalSubnetReference() {
        return this.externalSubnetReference;
    }

    public Subnet getExternalSubnet() {
        return this.externalSubnet;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public String getVmNicReference() {
        return this.vmNicReference;
    }

    public String getLoadBalancerSessionReference() {
        return this.loadBalancerSessionReference;
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public VmNic getVmNic() {
        return this.vmNic;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public void setAssociation(OneOfAssociationWrapper association) {
        this.association = association;
    }

    @JsonProperty(value="floatingIp")
    public void setFloatingIp(FloatingIPAddress floatingIp) {
        this.floatingIp = floatingIp;
    }

    @JsonProperty(value="externalSubnetReference")
    public void setExternalSubnetReference(String externalSubnetReference) {
        this.externalSubnetReference = externalSubnetReference;
    }

    @JsonProperty(value="externalSubnet")
    public void setExternalSubnet(Subnet externalSubnet) {
        this.externalSubnet = externalSubnet;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="vmNicReference")
    public void setVmNicReference(String vmNicReference) {
        this.vmNicReference = vmNicReference;
    }

    @JsonProperty(value="loadBalancerSessionReference")
    public void setLoadBalancerSessionReference(String loadBalancerSessionReference) {
        this.loadBalancerSessionReference = loadBalancerSessionReference;
    }

    @JsonProperty(value="vpc")
    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    @JsonProperty(value="vmNic")
    public void setVmNic(VmNic vmNic) {
        this.vmNic = vmNic;
    }

    @Override
    public String toString() {
        return "FloatingIp(privateIp=" + this.getPrivateIp() + ", floatingIpValue=" + this.getFloatingIpValue() + ", associationStatus=" + this.getAssociationStatus() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", association=" + this.getAssociation() + ", floatingIp=" + this.getFloatingIp() + ", externalSubnetReference=" + this.getExternalSubnetReference() + ", externalSubnet=" + this.getExternalSubnet() + ", vpcReference=" + this.getVpcReference() + ", vmNicReference=" + this.getVmNicReference() + ", loadBalancerSessionReference=" + this.getLoadBalancerSessionReference() + ", vpc=" + this.getVpc() + ", vmNic=" + this.getVmNic() + ")";
    }

    public static class FloatingIpBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private Object association;
        private FloatingIPAddress floatingIp;
        private String externalSubnetReference;
        private Subnet externalSubnet;
        private String privateIp;
        private String floatingIpValue;
        private String associationStatus;
        private String vpcReference;
        private String vmNicReference;
        private String loadBalancerSessionReference;
        private Vpc vpc;
        private VmNic vmNic;

        FloatingIpBuilder() {
        }

        public FloatingIpBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public FloatingIpBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public FloatingIpBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public FloatingIpBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public FloatingIpBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FloatingIpBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FloatingIpBuilder association(Object association) {
            this.association = association;
            return this;
        }

        public FloatingIpBuilder floatingIp(FloatingIPAddress floatingIp) {
            this.floatingIp = floatingIp;
            return this;
        }

        public FloatingIpBuilder externalSubnetReference(String externalSubnetReference) {
            this.externalSubnetReference = externalSubnetReference;
            return this;
        }

        public FloatingIpBuilder externalSubnet(Subnet externalSubnet) {
            this.externalSubnet = externalSubnet;
            return this;
        }

        public FloatingIpBuilder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public FloatingIpBuilder floatingIpValue(String floatingIpValue) {
            this.floatingIpValue = floatingIpValue;
            return this;
        }

        public FloatingIpBuilder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public FloatingIpBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public FloatingIpBuilder vmNicReference(String vmNicReference) {
            this.vmNicReference = vmNicReference;
            return this;
        }

        public FloatingIpBuilder loadBalancerSessionReference(String loadBalancerSessionReference) {
            this.loadBalancerSessionReference = loadBalancerSessionReference;
            return this;
        }

        public FloatingIpBuilder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public FloatingIpBuilder vmNic(VmNic vmNic) {
            this.vmNic = vmNic;
            return this;
        }

        public FloatingIp build() {
            return new FloatingIp(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.association, this.floatingIp, this.externalSubnetReference, this.externalSubnet, this.privateIp, this.floatingIpValue, this.associationStatus, this.vpcReference, this.vmNicReference, this.loadBalancerSessionReference, this.vpc, this.vmNic);
        }

        public String toString() {
            return "FloatingIp.FloatingIpBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", association=" + this.association + ", floatingIp=" + this.floatingIp + ", externalSubnetReference=" + this.externalSubnetReference + ", externalSubnet=" + this.externalSubnet + ", privateIp=" + this.privateIp + ", floatingIpValue=" + this.floatingIpValue + ", associationStatus=" + this.associationStatus + ", vpcReference=" + this.vpcReference + ", vmNicReference=" + this.vmNicReference + ", loadBalancerSessionReference=" + this.loadBalancerSessionReference + ", vpc=" + this.vpc + ", vmNic=" + this.vmNic + ")";
        }
    }

    @JsonDeserialize(using=OneOfAssociationWrapperJsonDeserializer.class)
    public static class OneOfAssociationWrapper {
        @JsonIgnore
        private VmNicAssociation oneOfType0;
        @JsonIgnore
        private PrivateIpAssociation oneOfType1;
        @JsonIgnore
        private LoadBalancerSessionAssociation oneOfType2;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfAssociationWrapper() {
        }

        public OneOfAssociationWrapper(VmNicAssociation data) {
            this.oneOfType0 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfAssociationWrapper(PrivateIpAssociation data) {
            this.oneOfType1 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfAssociationWrapper(LoadBalancerSessionAssociation data) {
            this.oneOfType2 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType0 != null && this.oneOfType0.get$objectType().equals(this.discriminator)) {
                return this.oneOfType0;
            }
            if (this.oneOfType1 != null && this.oneOfType1.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1;
            }
            if (this.oneOfType2 != null && this.oneOfType2.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof VmNicAssociation) {
                this.oneOfType0 = (VmNicAssociation)value;
                this.discriminator = this.oneOfType0.get$objectType();
                this.$objectType = this.oneOfType0.get$objectType();
                return;
            }
            if (value instanceof PrivateIpAssociation) {
                this.oneOfType1 = (PrivateIpAssociation)value;
                this.discriminator = this.oneOfType1.get$objectType();
                this.$objectType = this.oneOfType1.get$objectType();
                return;
            }
            if (value instanceof LoadBalancerSessionAssociation) {
                this.oneOfType2 = (LoadBalancerSessionAssociation)value;
                this.discriminator = this.oneOfType2.get$objectType();
                this.$objectType = this.oneOfType2.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfAssociationWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfAssociationWrapper)) {
                return false;
            }
            OneOfAssociationWrapper other = (OneOfAssociationWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VmNicAssociation this$oneOfType0 = this.oneOfType0;
            VmNicAssociation other$oneOfType0 = other.oneOfType0;
            if (this$oneOfType0 == null ? other$oneOfType0 != null : !((Object)this$oneOfType0).equals(other$oneOfType0)) {
                return false;
            }
            PrivateIpAssociation this$oneOfType1 = this.oneOfType1;
            PrivateIpAssociation other$oneOfType1 = other.oneOfType1;
            if (this$oneOfType1 == null ? other$oneOfType1 != null : !((Object)this$oneOfType1).equals(other$oneOfType1)) {
                return false;
            }
            LoadBalancerSessionAssociation this$oneOfType2 = this.oneOfType2;
            LoadBalancerSessionAssociation other$oneOfType2 = other.oneOfType2;
            if (this$oneOfType2 == null ? other$oneOfType2 != null : !((Object)this$oneOfType2).equals(other$oneOfType2)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfAssociationWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VmNicAssociation $oneOfType0 = this.oneOfType0;
            result = result * 59 + ($oneOfType0 == null ? 43 : ((Object)$oneOfType0).hashCode());
            PrivateIpAssociation $oneOfType1 = this.oneOfType1;
            result = result * 59 + ($oneOfType1 == null ? 43 : ((Object)$oneOfType1).hashCode());
            LoadBalancerSessionAssociation $oneOfType2 = this.oneOfType2;
            result = result * 59 + ($oneOfType2 == null ? 43 : ((Object)$oneOfType2).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "FloatingIp.OneOfAssociationWrapper(oneOfType0=" + this.oneOfType0 + ", oneOfType1=" + this.oneOfType1 + ", oneOfType2=" + this.oneOfType2 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @NetJsonDeserializer
        private static class OneOfAssociationWrapperJsonDeserializer
        extends NetOneOfDeserializer<OneOfAssociationWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE0 = TYPE_FACTORY.constructType(VmNicAssociation.class);
            private static final JavaType ONE_OF_TYPE1 = TYPE_FACTORY.constructType(PrivateIpAssociation.class);
            private static final JavaType ONE_OF_TYPE2 = TYPE_FACTORY.constructType(LoadBalancerSessionAssociation.class);

            public OneOfAssociationWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfAssociationWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfAssociationWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfAssociationWrapper provided is null");
                }
                if (ONE_OF_TYPE0.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE2.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfAssociationWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.net";
            }
        }
    }
}

