/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.FloatingIPAddress;
import com.nutanix.dp1.net.networking.v4.config.FloatingIp;
import com.nutanix.dp1.net.networking.v4.config.Subnet;
import com.nutanix.dp1.net.networking.v4.config.SubnetProjection;
import com.nutanix.dp1.net.networking.v4.config.VmNic;
import com.nutanix.dp1.net.networking.v4.config.VmNicProjection;
import com.nutanix.dp1.net.networking.v4.config.Vpc;
import com.nutanix.dp1.net.networking.v4.config.VpcProjection;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatingIpProjection
extends FloatingIp
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(FloatingIpProjection.class);
    @JsonProperty(value="subnetProjection")
    public SubnetProjection subnetProjection = null;
    @JsonProperty(value="vmNicProjection")
    public VmNicProjection vmNicProjection = null;
    @JsonProperty(value="vpcProjection")
    public VpcProjection vpcProjection = null;

    public FloatingIpProjection() {
    }

    public FloatingIpProjection(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, Object association, FloatingIPAddress floatingIp, String externalSubnetReference, Subnet externalSubnet, String privateIp, String floatingIpValue, String associationStatus, String vpcReference, String vmNicReference, String loadBalancerSessionReference, Vpc vpc, VmNic vmNic, SubnetProjection subnetProjection, VmNicProjection vmNicProjection, VpcProjection vpcProjection) {
        super(tenantId, extId, links, metadata, name, description, association, floatingIp, externalSubnetReference, externalSubnet, privateIp, floatingIpValue, associationStatus, vpcReference, vmNicReference, loadBalancerSessionReference, vpc, vmNic);
        this.setSubnetProjection(subnetProjection);
        this.setVmNicProjection(vmNicProjection);
        this.setVpcProjection(vpcProjection);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.FloatingIpProjection";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static FloatingIpProjectionBuilder FloatingIpProjectionBuilder() {
        return new FloatingIpProjectionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatingIpProjection)) {
            return false;
        }
        FloatingIpProjection other = (FloatingIpProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubnetProjection this$subnetProjection = this.getSubnetProjection();
        SubnetProjection other$subnetProjection = other.getSubnetProjection();
        if (this$subnetProjection == null ? other$subnetProjection != null : !((Object)this$subnetProjection).equals(other$subnetProjection)) {
            return false;
        }
        VmNicProjection this$vmNicProjection = this.getVmNicProjection();
        VmNicProjection other$vmNicProjection = other.getVmNicProjection();
        if (this$vmNicProjection == null ? other$vmNicProjection != null : !((Object)this$vmNicProjection).equals(other$vmNicProjection)) {
            return false;
        }
        VpcProjection this$vpcProjection = this.getVpcProjection();
        VpcProjection other$vpcProjection = other.getVpcProjection();
        return !(this$vpcProjection == null ? other$vpcProjection != null : !((Object)this$vpcProjection).equals(other$vpcProjection));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FloatingIpProjection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SubnetProjection $subnetProjection = this.getSubnetProjection();
        result = result * 59 + ($subnetProjection == null ? 43 : ((Object)$subnetProjection).hashCode());
        VmNicProjection $vmNicProjection = this.getVmNicProjection();
        result = result * 59 + ($vmNicProjection == null ? 43 : ((Object)$vmNicProjection).hashCode());
        VpcProjection $vpcProjection = this.getVpcProjection();
        result = result * 59 + ($vpcProjection == null ? 43 : ((Object)$vpcProjection).hashCode());
        return result;
    }

    public SubnetProjection getSubnetProjection() {
        return this.subnetProjection;
    }

    public VmNicProjection getVmNicProjection() {
        return this.vmNicProjection;
    }

    public VpcProjection getVpcProjection() {
        return this.vpcProjection;
    }

    @JsonProperty(value="subnetProjection")
    public void setSubnetProjection(SubnetProjection subnetProjection) {
        this.subnetProjection = subnetProjection;
    }

    @JsonProperty(value="vmNicProjection")
    public void setVmNicProjection(VmNicProjection vmNicProjection) {
        this.vmNicProjection = vmNicProjection;
    }

    @JsonProperty(value="vpcProjection")
    public void setVpcProjection(VpcProjection vpcProjection) {
        this.vpcProjection = vpcProjection;
    }

    @Override
    public String toString() {
        return "FloatingIpProjection(subnetProjection=" + this.getSubnetProjection() + ", vmNicProjection=" + this.getVmNicProjection() + ", vpcProjection=" + this.getVpcProjection() + ")";
    }

    public static class FloatingIpProjectionBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private Object association;
        private FloatingIPAddress floatingIp;
        private String externalSubnetReference;
        private Subnet externalSubnet;
        private String privateIp;
        private String floatingIpValue;
        private String associationStatus;
        private String vpcReference;
        private String vmNicReference;
        private String loadBalancerSessionReference;
        private Vpc vpc;
        private VmNic vmNic;
        private SubnetProjection subnetProjection;
        private VmNicProjection vmNicProjection;
        private VpcProjection vpcProjection;

        FloatingIpProjectionBuilder() {
        }

        public FloatingIpProjectionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public FloatingIpProjectionBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public FloatingIpProjectionBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public FloatingIpProjectionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public FloatingIpProjectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FloatingIpProjectionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FloatingIpProjectionBuilder association(Object association) {
            this.association = association;
            return this;
        }

        public FloatingIpProjectionBuilder floatingIp(FloatingIPAddress floatingIp) {
            this.floatingIp = floatingIp;
            return this;
        }

        public FloatingIpProjectionBuilder externalSubnetReference(String externalSubnetReference) {
            this.externalSubnetReference = externalSubnetReference;
            return this;
        }

        public FloatingIpProjectionBuilder externalSubnet(Subnet externalSubnet) {
            this.externalSubnet = externalSubnet;
            return this;
        }

        public FloatingIpProjectionBuilder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public FloatingIpProjectionBuilder floatingIpValue(String floatingIpValue) {
            this.floatingIpValue = floatingIpValue;
            return this;
        }

        public FloatingIpProjectionBuilder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public FloatingIpProjectionBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public FloatingIpProjectionBuilder vmNicReference(String vmNicReference) {
            this.vmNicReference = vmNicReference;
            return this;
        }

        public FloatingIpProjectionBuilder loadBalancerSessionReference(String loadBalancerSessionReference) {
            this.loadBalancerSessionReference = loadBalancerSessionReference;
            return this;
        }

        public FloatingIpProjectionBuilder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public FloatingIpProjectionBuilder vmNic(VmNic vmNic) {
            this.vmNic = vmNic;
            return this;
        }

        public FloatingIpProjectionBuilder subnetProjection(SubnetProjection subnetProjection) {
            this.subnetProjection = subnetProjection;
            return this;
        }

        public FloatingIpProjectionBuilder vmNicProjection(VmNicProjection vmNicProjection) {
            this.vmNicProjection = vmNicProjection;
            return this;
        }

        public FloatingIpProjectionBuilder vpcProjection(VpcProjection vpcProjection) {
            this.vpcProjection = vpcProjection;
            return this;
        }

        public FloatingIpProjection build() {
            return new FloatingIpProjection(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.association, this.floatingIp, this.externalSubnetReference, this.externalSubnet, this.privateIp, this.floatingIpValue, this.associationStatus, this.vpcReference, this.vmNicReference, this.loadBalancerSessionReference, this.vpc, this.vmNic, this.subnetProjection, this.vmNicProjection, this.vpcProjection);
        }

        public String toString() {
            return "FloatingIpProjection.FloatingIpProjectionBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", association=" + this.association + ", floatingIp=" + this.floatingIp + ", externalSubnetReference=" + this.externalSubnetReference + ", externalSubnet=" + this.externalSubnet + ", privateIp=" + this.privateIp + ", floatingIpValue=" + this.floatingIpValue + ", associationStatus=" + this.associationStatus + ", vpcReference=" + this.vpcReference + ", vmNicReference=" + this.vmNicReference + ", loadBalancerSessionReference=" + this.loadBalancerSessionReference + ", vpc=" + this.vpc + ", vmNic=" + this.vmNic + ", subnetProjection=" + this.subnetProjection + ", vmNicProjection=" + this.vmNicProjection + ", vpcProjection=" + this.vpcProjection + ")";
        }
    }
}

