/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.AzureExternalSubnetBinding;
import com.nutanix.dp1.net.networking.v4.config.FlowGatewayStatus;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowGateway
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(FlowGateway.class);
    @Pattern(regexp="^(\\d+\\.)?(\\d+\\.)?(\\d+)$")
    private @Pattern(regexp="^(\\d+\\.)?(\\d+\\.)?(\\d+)$") String ovnControllerVersion = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="chassisUuid")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String chassisUuid = null;
    @Size(min=1, max=1)
    @JsonProperty(value="azureExternalSubnetBindingList")
    public @Size(min=1, max=1) List<AzureExternalSubnetBinding> azureExternalSubnetBindingList = null;
    @JsonProperty(value="gatewayStatus")
    public FlowGatewayStatus gatewayStatus = null;

    public FlowGateway() {
    }

    public FlowGateway(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String chassisUuid, List<AzureExternalSubnetBinding> azureExternalSubnetBindingList, FlowGatewayStatus gatewayStatus, String ovnControllerVersion) {
        super(tenantId, extId, links, metadata);
        this.setChassisUuid(chassisUuid);
        this.setAzureExternalSubnetBindingList(azureExternalSubnetBindingList);
        this.setGatewayStatus(gatewayStatus);
        this.setOvnControllerVersion(ovnControllerVersion);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.FlowGateway";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setOvnControllerVersion(String ovnControllerVersion) {
        if (this.ovnControllerVersion == null) {
            this.ovnControllerVersion = ovnControllerVersion;
        } else {
            log.warn("Read-only property ovnControllerVersion already contains a non-null value and cannot be set again");
        }
    }

    public static FlowGatewayBuilder FlowGatewayBuilder() {
        return new FlowGatewayBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowGateway)) {
            return false;
        }
        FlowGateway other = (FlowGateway)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ovnControllerVersion = this.getOvnControllerVersion();
        String other$ovnControllerVersion = other.getOvnControllerVersion();
        if (this$ovnControllerVersion == null ? other$ovnControllerVersion != null : !this$ovnControllerVersion.equals(other$ovnControllerVersion)) {
            return false;
        }
        String this$chassisUuid = this.getChassisUuid();
        String other$chassisUuid = other.getChassisUuid();
        if (this$chassisUuid == null ? other$chassisUuid != null : !this$chassisUuid.equals(other$chassisUuid)) {
            return false;
        }
        List<AzureExternalSubnetBinding> this$azureExternalSubnetBindingList = this.getAzureExternalSubnetBindingList();
        List<AzureExternalSubnetBinding> other$azureExternalSubnetBindingList = other.getAzureExternalSubnetBindingList();
        if (this$azureExternalSubnetBindingList == null ? other$azureExternalSubnetBindingList != null : !((Object)this$azureExternalSubnetBindingList).equals(other$azureExternalSubnetBindingList)) {
            return false;
        }
        FlowGatewayStatus this$gatewayStatus = this.getGatewayStatus();
        FlowGatewayStatus other$gatewayStatus = other.getGatewayStatus();
        return !(this$gatewayStatus == null ? other$gatewayStatus != null : !((Object)this$gatewayStatus).equals(other$gatewayStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FlowGateway;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ovnControllerVersion = this.getOvnControllerVersion();
        result = result * 59 + ($ovnControllerVersion == null ? 43 : $ovnControllerVersion.hashCode());
        String $chassisUuid = this.getChassisUuid();
        result = result * 59 + ($chassisUuid == null ? 43 : $chassisUuid.hashCode());
        List<AzureExternalSubnetBinding> $azureExternalSubnetBindingList = this.getAzureExternalSubnetBindingList();
        result = result * 59 + ($azureExternalSubnetBindingList == null ? 43 : ((Object)$azureExternalSubnetBindingList).hashCode());
        FlowGatewayStatus $gatewayStatus = this.getGatewayStatus();
        result = result * 59 + ($gatewayStatus == null ? 43 : ((Object)$gatewayStatus).hashCode());
        return result;
    }

    public String getOvnControllerVersion() {
        return this.ovnControllerVersion;
    }

    public String getChassisUuid() {
        return this.chassisUuid;
    }

    public List<AzureExternalSubnetBinding> getAzureExternalSubnetBindingList() {
        return this.azureExternalSubnetBindingList;
    }

    public FlowGatewayStatus getGatewayStatus() {
        return this.gatewayStatus;
    }

    @JsonProperty(value="chassisUuid")
    public void setChassisUuid(String chassisUuid) {
        this.chassisUuid = chassisUuid;
    }

    @JsonProperty(value="azureExternalSubnetBindingList")
    public void setAzureExternalSubnetBindingList(List<AzureExternalSubnetBinding> azureExternalSubnetBindingList) {
        this.azureExternalSubnetBindingList = azureExternalSubnetBindingList;
    }

    @JsonProperty(value="gatewayStatus")
    public void setGatewayStatus(FlowGatewayStatus gatewayStatus) {
        this.gatewayStatus = gatewayStatus;
    }

    @Override
    public String toString() {
        return "FlowGateway(ovnControllerVersion=" + this.getOvnControllerVersion() + ", chassisUuid=" + this.getChassisUuid() + ", azureExternalSubnetBindingList=" + this.getAzureExternalSubnetBindingList() + ", gatewayStatus=" + this.getGatewayStatus() + ")";
    }

    public static class FlowGatewayBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String chassisUuid;
        private List<AzureExternalSubnetBinding> azureExternalSubnetBindingList;
        private FlowGatewayStatus gatewayStatus;
        private String ovnControllerVersion;

        FlowGatewayBuilder() {
        }

        public FlowGatewayBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public FlowGatewayBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public FlowGatewayBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public FlowGatewayBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public FlowGatewayBuilder chassisUuid(String chassisUuid) {
            this.chassisUuid = chassisUuid;
            return this;
        }

        public FlowGatewayBuilder azureExternalSubnetBindingList(List<AzureExternalSubnetBinding> azureExternalSubnetBindingList) {
            this.azureExternalSubnetBindingList = azureExternalSubnetBindingList;
            return this;
        }

        public FlowGatewayBuilder gatewayStatus(FlowGatewayStatus gatewayStatus) {
            this.gatewayStatus = gatewayStatus;
            return this;
        }

        public FlowGatewayBuilder ovnControllerVersion(String ovnControllerVersion) {
            this.ovnControllerVersion = ovnControllerVersion;
            return this;
        }

        public FlowGateway build() {
            return new FlowGateway(this.tenantId, this.extId, this.links, this.metadata, this.chassisUuid, this.azureExternalSubnetBindingList, this.gatewayStatus, this.ovnControllerVersion);
        }

        public String toString() {
            return "FlowGateway.FlowGatewayBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", chassisUuid=" + this.chassisUuid + ", azureExternalSubnetBindingList=" + this.azureExternalSubnetBindingList + ", gatewayStatus=" + this.gatewayStatus + ", ovnControllerVersion=" + this.ovnControllerVersion + ")";
        }
    }
}

