/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.FlowGatewayStatus;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowGatewayKeepAliveRequestSpec
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(FlowGatewayKeepAliveRequestSpec.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="chassisUuid")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String chassisUuid = null;
    @JsonProperty(value="gatewayStatus")
    public FlowGatewayStatus gatewayStatus = null;
    @Pattern(regexp="^(\\d+\\.)?(\\d+\\.)?(\\d+)$")
    @JsonProperty(value="ovnControllerVersion")
    public @Pattern(regexp="^(\\d+\\.)?(\\d+\\.)?(\\d+)$") String ovnControllerVersion = null;
    @Size(min=1, max=1)
    @JsonProperty(value="eniPrimaryIpList")
    public @Size(min=1, max=1) List<IPAddress> eniPrimaryIpList = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public FlowGatewayKeepAliveRequestSpec() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public FlowGatewayKeepAliveRequestSpec(String chassisUuid, FlowGatewayStatus gatewayStatus, String ovnControllerVersion, List<IPAddress> eniPrimaryIpList) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setChassisUuid(chassisUuid);
        this.setGatewayStatus(gatewayStatus);
        this.setOvnControllerVersion(ovnControllerVersion);
        this.setEniPrimaryIpList(eniPrimaryIpList);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.FlowGatewayKeepAliveRequestSpec";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static FlowGatewayKeepAliveRequestSpecBuilder FlowGatewayKeepAliveRequestSpecBuilder() {
        return new FlowGatewayKeepAliveRequestSpecBuilder();
    }

    public String getChassisUuid() {
        return this.chassisUuid;
    }

    public FlowGatewayStatus getGatewayStatus() {
        return this.gatewayStatus;
    }

    public String getOvnControllerVersion() {
        return this.ovnControllerVersion;
    }

    public List<IPAddress> getEniPrimaryIpList() {
        return this.eniPrimaryIpList;
    }

    @JsonProperty(value="chassisUuid")
    public void setChassisUuid(String chassisUuid) {
        this.chassisUuid = chassisUuid;
    }

    @JsonProperty(value="gatewayStatus")
    public void setGatewayStatus(FlowGatewayStatus gatewayStatus) {
        this.gatewayStatus = gatewayStatus;
    }

    @JsonProperty(value="ovnControllerVersion")
    public void setOvnControllerVersion(String ovnControllerVersion) {
        this.ovnControllerVersion = ovnControllerVersion;
    }

    @JsonProperty(value="eniPrimaryIpList")
    public void setEniPrimaryIpList(List<IPAddress> eniPrimaryIpList) {
        this.eniPrimaryIpList = eniPrimaryIpList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowGatewayKeepAliveRequestSpec)) {
            return false;
        }
        FlowGatewayKeepAliveRequestSpec other = (FlowGatewayKeepAliveRequestSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chassisUuid = this.getChassisUuid();
        String other$chassisUuid = other.getChassisUuid();
        if (this$chassisUuid == null ? other$chassisUuid != null : !this$chassisUuid.equals(other$chassisUuid)) {
            return false;
        }
        FlowGatewayStatus this$gatewayStatus = this.getGatewayStatus();
        FlowGatewayStatus other$gatewayStatus = other.getGatewayStatus();
        if (this$gatewayStatus == null ? other$gatewayStatus != null : !((Object)this$gatewayStatus).equals(other$gatewayStatus)) {
            return false;
        }
        String this$ovnControllerVersion = this.getOvnControllerVersion();
        String other$ovnControllerVersion = other.getOvnControllerVersion();
        if (this$ovnControllerVersion == null ? other$ovnControllerVersion != null : !this$ovnControllerVersion.equals(other$ovnControllerVersion)) {
            return false;
        }
        List<IPAddress> this$eniPrimaryIpList = this.getEniPrimaryIpList();
        List<IPAddress> other$eniPrimaryIpList = other.getEniPrimaryIpList();
        return !(this$eniPrimaryIpList == null ? other$eniPrimaryIpList != null : !((Object)this$eniPrimaryIpList).equals(other$eniPrimaryIpList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowGatewayKeepAliveRequestSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chassisUuid = this.getChassisUuid();
        result = result * 59 + ($chassisUuid == null ? 43 : $chassisUuid.hashCode());
        FlowGatewayStatus $gatewayStatus = this.getGatewayStatus();
        result = result * 59 + ($gatewayStatus == null ? 43 : ((Object)$gatewayStatus).hashCode());
        String $ovnControllerVersion = this.getOvnControllerVersion();
        result = result * 59 + ($ovnControllerVersion == null ? 43 : $ovnControllerVersion.hashCode());
        List<IPAddress> $eniPrimaryIpList = this.getEniPrimaryIpList();
        result = result * 59 + ($eniPrimaryIpList == null ? 43 : ((Object)$eniPrimaryIpList).hashCode());
        return result;
    }

    public String toString() {
        return "FlowGatewayKeepAliveRequestSpec(chassisUuid=" + this.getChassisUuid() + ", gatewayStatus=" + this.getGatewayStatus() + ", ovnControllerVersion=" + this.getOvnControllerVersion() + ", eniPrimaryIpList=" + this.getEniPrimaryIpList() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class FlowGatewayKeepAliveRequestSpecBuilder {
        private String chassisUuid;
        private FlowGatewayStatus gatewayStatus;
        private String ovnControllerVersion;
        private List<IPAddress> eniPrimaryIpList;

        FlowGatewayKeepAliveRequestSpecBuilder() {
        }

        public FlowGatewayKeepAliveRequestSpecBuilder chassisUuid(String chassisUuid) {
            this.chassisUuid = chassisUuid;
            return this;
        }

        public FlowGatewayKeepAliveRequestSpecBuilder gatewayStatus(FlowGatewayStatus gatewayStatus) {
            this.gatewayStatus = gatewayStatus;
            return this;
        }

        public FlowGatewayKeepAliveRequestSpecBuilder ovnControllerVersion(String ovnControllerVersion) {
            this.ovnControllerVersion = ovnControllerVersion;
            return this;
        }

        public FlowGatewayKeepAliveRequestSpecBuilder eniPrimaryIpList(List<IPAddress> eniPrimaryIpList) {
            this.eniPrimaryIpList = eniPrimaryIpList;
            return this;
        }

        public FlowGatewayKeepAliveRequestSpec build() {
            return new FlowGatewayKeepAliveRequestSpec(this.chassisUuid, this.gatewayStatus, this.ovnControllerVersion, this.eniPrimaryIpList);
        }

        public String toString() {
            return "FlowGatewayKeepAliveRequestSpec.FlowGatewayKeepAliveRequestSpecBuilder(chassisUuid=" + this.chassisUuid + ", gatewayStatus=" + this.gatewayStatus + ", ovnControllerVersion=" + this.ovnControllerVersion + ", eniPrimaryIpList=" + this.eniPrimaryIpList + ")";
        }
    }
}

