/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.net.annotations.NetJsonDeserializer;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.deserializers.NetOneOfDeserializer;
import com.nutanix.dp1.net.networking.v4.config.GatewayDeployment;
import com.nutanix.dp1.net.networking.v4.config.LocalNetworkServices;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.RemoteNetworkServices;
import com.nutanix.dp1.net.networking.v4.config.Status;
import com.nutanix.dp1.net.networking.v4.config.Vm;
import com.nutanix.dp1.net.networking.v4.config.Vpc;
import com.nutanix.dp1.net.serializers.NetOneOfSerializer;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gateway
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Gateway.class);
    private String installedSoftwareVersion = null;
    private String supportedSoftwareVersion = null;
    private String vmReference = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="cloudNetworkReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String cloudNetworkReference = null;
    @JsonProperty(value="deployment")
    public GatewayDeployment deployment = null;
    @JsonProperty(value="gatewayDeviceVendor")
    public String gatewayDeviceVendor = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $servicesItemDiscriminator = null;
    private OneOfServicesWrapper services = null;
    @JsonProperty(value="status")
    public Status status = null;
    @JsonProperty(value="vpc")
    public Vpc vpc = null;
    @JsonProperty(value="vm")
    public Vm vm = null;

    public Gateway() {
    }

    public Gateway(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, String vpcReference, String cloudNetworkReference, String installedSoftwareVersion, String supportedSoftwareVersion, String vmReference, GatewayDeployment deployment, String gatewayDeviceVendor, Object services, Status status, Vpc vpc, Vm vm) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setVpcReference(vpcReference);
        this.setCloudNetworkReference(cloudNetworkReference);
        this.setInstalledSoftwareVersion(installedSoftwareVersion);
        this.setSupportedSoftwareVersion(supportedSoftwareVersion);
        this.setVmReference(vmReference);
        this.setDeployment(deployment);
        this.setGatewayDeviceVendor(gatewayDeviceVendor);
        this.setServicesInWrapper(services);
        this.setStatus(status);
        this.setVpc(vpc);
        this.setVm(vm);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Gateway";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setInstalledSoftwareVersion(String installedSoftwareVersion) {
        if (this.installedSoftwareVersion == null) {
            this.installedSoftwareVersion = installedSoftwareVersion;
        } else {
            log.warn("Read-only property installedSoftwareVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setSupportedSoftwareVersion(String supportedSoftwareVersion) {
        if (this.supportedSoftwareVersion == null) {
            this.supportedSoftwareVersion = supportedSoftwareVersion;
        } else {
            log.warn("Read-only property supportedSoftwareVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setVmReference(String vmReference) {
        if (this.vmReference == null) {
            this.vmReference = vmReference;
        } else {
            log.warn("Read-only property vmReference already contains a non-null value and cannot be set again");
        }
    }

    public String get$servicesItemDiscriminator() {
        if (this.services != null && this.$servicesItemDiscriminator == null) {
            this.$servicesItemDiscriminator = this.services.getDiscriminator();
        }
        return this.$servicesItemDiscriminator;
    }

    @JsonIgnore
    public void setServicesInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.services == null) {
            this.services = new OneOfServicesWrapper();
        }
        this.services.setValue(value);
        this.$servicesItemDiscriminator = this.services.getDiscriminator();
    }

    @JsonSerialize(using=NetOneOfSerializer.class)
    public Object getServices() {
        if (this.services == null) {
            log.debug("OneOf property services was never set. Returning null...");
            return null;
        }
        return this.services.getValue();
    }

    public static GatewayBuilder GatewayBuilder() {
        return new GatewayBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Gateway)) {
            return false;
        }
        Gateway other = (Gateway)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$installedSoftwareVersion = this.getInstalledSoftwareVersion();
        String other$installedSoftwareVersion = other.getInstalledSoftwareVersion();
        if (this$installedSoftwareVersion == null ? other$installedSoftwareVersion != null : !this$installedSoftwareVersion.equals(other$installedSoftwareVersion)) {
            return false;
        }
        String this$supportedSoftwareVersion = this.getSupportedSoftwareVersion();
        String other$supportedSoftwareVersion = other.getSupportedSoftwareVersion();
        if (this$supportedSoftwareVersion == null ? other$supportedSoftwareVersion != null : !this$supportedSoftwareVersion.equals(other$supportedSoftwareVersion)) {
            return false;
        }
        String this$vmReference = this.getVmReference();
        String other$vmReference = other.getVmReference();
        if (this$vmReference == null ? other$vmReference != null : !this$vmReference.equals(other$vmReference)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        String this$cloudNetworkReference = this.getCloudNetworkReference();
        String other$cloudNetworkReference = other.getCloudNetworkReference();
        if (this$cloudNetworkReference == null ? other$cloudNetworkReference != null : !this$cloudNetworkReference.equals(other$cloudNetworkReference)) {
            return false;
        }
        GatewayDeployment this$deployment = this.getDeployment();
        GatewayDeployment other$deployment = other.getDeployment();
        if (this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment)) {
            return false;
        }
        String this$gatewayDeviceVendor = this.getGatewayDeviceVendor();
        String other$gatewayDeviceVendor = other.getGatewayDeviceVendor();
        if (this$gatewayDeviceVendor == null ? other$gatewayDeviceVendor != null : !this$gatewayDeviceVendor.equals(other$gatewayDeviceVendor)) {
            return false;
        }
        Object this$services = this.getServices();
        Object other$services = other.getServices();
        if (this$services == null ? other$services != null : !this$services.equals(other$services)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Vpc this$vpc = this.getVpc();
        Vpc other$vpc = other.getVpc();
        if (this$vpc == null ? other$vpc != null : !((Object)this$vpc).equals(other$vpc)) {
            return false;
        }
        Vm this$vm = this.getVm();
        Vm other$vm = other.getVm();
        return !(this$vm == null ? other$vm != null : !((Object)this$vm).equals(other$vm));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Gateway;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $installedSoftwareVersion = this.getInstalledSoftwareVersion();
        result = result * 59 + ($installedSoftwareVersion == null ? 43 : $installedSoftwareVersion.hashCode());
        String $supportedSoftwareVersion = this.getSupportedSoftwareVersion();
        result = result * 59 + ($supportedSoftwareVersion == null ? 43 : $supportedSoftwareVersion.hashCode());
        String $vmReference = this.getVmReference();
        result = result * 59 + ($vmReference == null ? 43 : $vmReference.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        String $cloudNetworkReference = this.getCloudNetworkReference();
        result = result * 59 + ($cloudNetworkReference == null ? 43 : $cloudNetworkReference.hashCode());
        GatewayDeployment $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        String $gatewayDeviceVendor = this.getGatewayDeviceVendor();
        result = result * 59 + ($gatewayDeviceVendor == null ? 43 : $gatewayDeviceVendor.hashCode());
        Object $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : $services.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Vpc $vpc = this.getVpc();
        result = result * 59 + ($vpc == null ? 43 : ((Object)$vpc).hashCode());
        Vm $vm = this.getVm();
        result = result * 59 + ($vm == null ? 43 : ((Object)$vm).hashCode());
        return result;
    }

    public String getInstalledSoftwareVersion() {
        return this.installedSoftwareVersion;
    }

    public String getSupportedSoftwareVersion() {
        return this.supportedSoftwareVersion;
    }

    public String getVmReference() {
        return this.vmReference;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public String getCloudNetworkReference() {
        return this.cloudNetworkReference;
    }

    public GatewayDeployment getDeployment() {
        return this.deployment;
    }

    public String getGatewayDeviceVendor() {
        return this.gatewayDeviceVendor;
    }

    public Status getStatus() {
        return this.status;
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public Vm getVm() {
        return this.vm;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="cloudNetworkReference")
    public void setCloudNetworkReference(String cloudNetworkReference) {
        this.cloudNetworkReference = cloudNetworkReference;
    }

    @JsonProperty(value="deployment")
    public void setDeployment(GatewayDeployment deployment) {
        this.deployment = deployment;
    }

    @JsonProperty(value="gatewayDeviceVendor")
    public void setGatewayDeviceVendor(String gatewayDeviceVendor) {
        this.gatewayDeviceVendor = gatewayDeviceVendor;
    }

    public void setServices(OneOfServicesWrapper services) {
        this.services = services;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty(value="vpc")
    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    @JsonProperty(value="vm")
    public void setVm(Vm vm) {
        this.vm = vm;
    }

    @Override
    public String toString() {
        return "Gateway(installedSoftwareVersion=" + this.getInstalledSoftwareVersion() + ", supportedSoftwareVersion=" + this.getSupportedSoftwareVersion() + ", vmReference=" + this.getVmReference() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", vpcReference=" + this.getVpcReference() + ", cloudNetworkReference=" + this.getCloudNetworkReference() + ", deployment=" + this.getDeployment() + ", gatewayDeviceVendor=" + this.getGatewayDeviceVendor() + ", services=" + this.getServices() + ", status=" + this.getStatus() + ", vpc=" + this.getVpc() + ", vm=" + this.getVm() + ")";
    }

    public static class GatewayBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private String vpcReference;
        private String cloudNetworkReference;
        private String installedSoftwareVersion;
        private String supportedSoftwareVersion;
        private String vmReference;
        private GatewayDeployment deployment;
        private String gatewayDeviceVendor;
        private Object services;
        private Status status;
        private Vpc vpc;
        private Vm vm;

        GatewayBuilder() {
        }

        public GatewayBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public GatewayBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public GatewayBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public GatewayBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public GatewayBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GatewayBuilder description(String description) {
            this.description = description;
            return this;
        }

        public GatewayBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public GatewayBuilder cloudNetworkReference(String cloudNetworkReference) {
            this.cloudNetworkReference = cloudNetworkReference;
            return this;
        }

        public GatewayBuilder installedSoftwareVersion(String installedSoftwareVersion) {
            this.installedSoftwareVersion = installedSoftwareVersion;
            return this;
        }

        public GatewayBuilder supportedSoftwareVersion(String supportedSoftwareVersion) {
            this.supportedSoftwareVersion = supportedSoftwareVersion;
            return this;
        }

        public GatewayBuilder vmReference(String vmReference) {
            this.vmReference = vmReference;
            return this;
        }

        public GatewayBuilder deployment(GatewayDeployment deployment) {
            this.deployment = deployment;
            return this;
        }

        public GatewayBuilder gatewayDeviceVendor(String gatewayDeviceVendor) {
            this.gatewayDeviceVendor = gatewayDeviceVendor;
            return this;
        }

        public GatewayBuilder services(Object services) {
            this.services = services;
            return this;
        }

        public GatewayBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public GatewayBuilder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public GatewayBuilder vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        public Gateway build() {
            return new Gateway(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.vpcReference, this.cloudNetworkReference, this.installedSoftwareVersion, this.supportedSoftwareVersion, this.vmReference, this.deployment, this.gatewayDeviceVendor, this.services, this.status, this.vpc, this.vm);
        }

        public String toString() {
            return "Gateway.GatewayBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", vpcReference=" + this.vpcReference + ", cloudNetworkReference=" + this.cloudNetworkReference + ", installedSoftwareVersion=" + this.installedSoftwareVersion + ", supportedSoftwareVersion=" + this.supportedSoftwareVersion + ", vmReference=" + this.vmReference + ", deployment=" + this.deployment + ", gatewayDeviceVendor=" + this.gatewayDeviceVendor + ", services=" + this.services + ", status=" + this.status + ", vpc=" + this.vpc + ", vm=" + this.vm + ")";
        }
    }

    @JsonDeserialize(using=OneOfServicesWrapperJsonDeserializer.class)
    public static class OneOfServicesWrapper {
        @JsonIgnore
        private LocalNetworkServices oneOfType0;
        @JsonIgnore
        private RemoteNetworkServices oneOfType1;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfServicesWrapper() {
        }

        public OneOfServicesWrapper(LocalNetworkServices data) {
            this.oneOfType0 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfServicesWrapper(RemoteNetworkServices data) {
            this.oneOfType1 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType0 != null && this.oneOfType0.get$objectType().equals(this.discriminator)) {
                return this.oneOfType0;
            }
            if (this.oneOfType1 != null && this.oneOfType1.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof LocalNetworkServices) {
                this.oneOfType0 = (LocalNetworkServices)value;
                this.discriminator = this.oneOfType0.get$objectType();
                this.$objectType = this.oneOfType0.get$objectType();
                return;
            }
            if (value instanceof RemoteNetworkServices) {
                this.oneOfType1 = (RemoteNetworkServices)value;
                this.discriminator = this.oneOfType1.get$objectType();
                this.$objectType = this.oneOfType1.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfServicesWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfServicesWrapper)) {
                return false;
            }
            OneOfServicesWrapper other = (OneOfServicesWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LocalNetworkServices this$oneOfType0 = this.oneOfType0;
            LocalNetworkServices other$oneOfType0 = other.oneOfType0;
            if (this$oneOfType0 == null ? other$oneOfType0 != null : !((Object)this$oneOfType0).equals(other$oneOfType0)) {
                return false;
            }
            RemoteNetworkServices this$oneOfType1 = this.oneOfType1;
            RemoteNetworkServices other$oneOfType1 = other.oneOfType1;
            if (this$oneOfType1 == null ? other$oneOfType1 != null : !((Object)this$oneOfType1).equals(other$oneOfType1)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfServicesWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalNetworkServices $oneOfType0 = this.oneOfType0;
            result = result * 59 + ($oneOfType0 == null ? 43 : ((Object)$oneOfType0).hashCode());
            RemoteNetworkServices $oneOfType1 = this.oneOfType1;
            result = result * 59 + ($oneOfType1 == null ? 43 : ((Object)$oneOfType1).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "Gateway.OneOfServicesWrapper(oneOfType0=" + this.oneOfType0 + ", oneOfType1=" + this.oneOfType1 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @NetJsonDeserializer
        private static class OneOfServicesWrapperJsonDeserializer
        extends NetOneOfDeserializer<OneOfServicesWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE0 = TYPE_FACTORY.constructType(LocalNetworkServices.class);
            private static final JavaType ONE_OF_TYPE1 = TYPE_FACTORY.constructType(RemoteNetworkServices.class);

            public OneOfServicesWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfServicesWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfServicesWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfServicesWrapper provided is null");
                }
                if (ONE_OF_TYPE0.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfServicesWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.net";
            }
        }
    }
}

