/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.GatewayInterface;
import com.nutanix.dp1.net.networking.v4.config.GatewayManagementInterface;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayDeployment
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(GatewayDeployment.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterReference = null;
    @JsonProperty(value="managementInterface")
    public GatewayManagementInterface managementInterface = null;
    @Size(min=0, max=4)
    @JsonProperty(value="interfaces")
    public @Size(min=0, max=4) List<GatewayInterface> interfaces = null;
    @Size(max=128)
    @JsonProperty(value="vcenterDatastoreName")
    public @Size(max=128) String vcenterDatastoreName = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public GatewayDeployment() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public GatewayDeployment(String clusterReference, GatewayManagementInterface managementInterface, List<GatewayInterface> interfaces, String vcenterDatastoreName) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setClusterReference(clusterReference);
        this.setManagementInterface(managementInterface);
        this.setInterfaces(interfaces);
        this.setVcenterDatastoreName(vcenterDatastoreName);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.GatewayDeployment";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static GatewayDeploymentBuilder GatewayDeploymentBuilder() {
        return new GatewayDeploymentBuilder();
    }

    public String getClusterReference() {
        return this.clusterReference;
    }

    public GatewayManagementInterface getManagementInterface() {
        return this.managementInterface;
    }

    public List<GatewayInterface> getInterfaces() {
        return this.interfaces;
    }

    public String getVcenterDatastoreName() {
        return this.vcenterDatastoreName;
    }

    @JsonProperty(value="clusterReference")
    public void setClusterReference(String clusterReference) {
        this.clusterReference = clusterReference;
    }

    @JsonProperty(value="managementInterface")
    public void setManagementInterface(GatewayManagementInterface managementInterface) {
        this.managementInterface = managementInterface;
    }

    @JsonProperty(value="interfaces")
    public void setInterfaces(List<GatewayInterface> interfaces) {
        this.interfaces = interfaces;
    }

    @JsonProperty(value="vcenterDatastoreName")
    public void setVcenterDatastoreName(String vcenterDatastoreName) {
        this.vcenterDatastoreName = vcenterDatastoreName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GatewayDeployment)) {
            return false;
        }
        GatewayDeployment other = (GatewayDeployment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clusterReference = this.getClusterReference();
        String other$clusterReference = other.getClusterReference();
        if (this$clusterReference == null ? other$clusterReference != null : !this$clusterReference.equals(other$clusterReference)) {
            return false;
        }
        GatewayManagementInterface this$managementInterface = this.getManagementInterface();
        GatewayManagementInterface other$managementInterface = other.getManagementInterface();
        if (this$managementInterface == null ? other$managementInterface != null : !((Object)this$managementInterface).equals(other$managementInterface)) {
            return false;
        }
        List<GatewayInterface> this$interfaces = this.getInterfaces();
        List<GatewayInterface> other$interfaces = other.getInterfaces();
        if (this$interfaces == null ? other$interfaces != null : !((Object)this$interfaces).equals(other$interfaces)) {
            return false;
        }
        String this$vcenterDatastoreName = this.getVcenterDatastoreName();
        String other$vcenterDatastoreName = other.getVcenterDatastoreName();
        return !(this$vcenterDatastoreName == null ? other$vcenterDatastoreName != null : !this$vcenterDatastoreName.equals(other$vcenterDatastoreName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GatewayDeployment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clusterReference = this.getClusterReference();
        result = result * 59 + ($clusterReference == null ? 43 : $clusterReference.hashCode());
        GatewayManagementInterface $managementInterface = this.getManagementInterface();
        result = result * 59 + ($managementInterface == null ? 43 : ((Object)$managementInterface).hashCode());
        List<GatewayInterface> $interfaces = this.getInterfaces();
        result = result * 59 + ($interfaces == null ? 43 : ((Object)$interfaces).hashCode());
        String $vcenterDatastoreName = this.getVcenterDatastoreName();
        result = result * 59 + ($vcenterDatastoreName == null ? 43 : $vcenterDatastoreName.hashCode());
        return result;
    }

    public String toString() {
        return "GatewayDeployment(clusterReference=" + this.getClusterReference() + ", managementInterface=" + this.getManagementInterface() + ", interfaces=" + this.getInterfaces() + ", vcenterDatastoreName=" + this.getVcenterDatastoreName() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class GatewayDeploymentBuilder {
        private String clusterReference;
        private GatewayManagementInterface managementInterface;
        private List<GatewayInterface> interfaces;
        private String vcenterDatastoreName;

        GatewayDeploymentBuilder() {
        }

        public GatewayDeploymentBuilder clusterReference(String clusterReference) {
            this.clusterReference = clusterReference;
            return this;
        }

        public GatewayDeploymentBuilder managementInterface(GatewayManagementInterface managementInterface) {
            this.managementInterface = managementInterface;
            return this;
        }

        public GatewayDeploymentBuilder interfaces(List<GatewayInterface> interfaces) {
            this.interfaces = interfaces;
            return this;
        }

        public GatewayDeploymentBuilder vcenterDatastoreName(String vcenterDatastoreName) {
            this.vcenterDatastoreName = vcenterDatastoreName;
            return this;
        }

        public GatewayDeployment build() {
            return new GatewayDeployment(this.clusterReference, this.managementInterface, this.interfaces, this.vcenterDatastoreName);
        }

        public String toString() {
            return "GatewayDeployment.GatewayDeploymentBuilder(clusterReference=" + this.clusterReference + ", managementInterface=" + this.managementInterface + ", interfaces=" + this.interfaces + ", vcenterDatastoreName=" + this.vcenterDatastoreName + ")";
        }
    }
}

