/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayInterface
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(GatewayInterface.class);
    private Integer mtu = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="subnetReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String subnetReference = null;
    @JsonProperty(value="ipAddress")
    public IPAddress ipAddress = null;
    @JsonProperty(value="defaultGatewayAddress")
    public IPAddress defaultGatewayAddress = null;
    @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$")
    @JsonProperty(value="macAddress")
    public @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$") String macAddress = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public GatewayInterface() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public GatewayInterface(String subnetReference, IPAddress ipAddress, IPAddress defaultGatewayAddress, String macAddress, Integer mtu) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setSubnetReference(subnetReference);
        this.setIpAddress(ipAddress);
        this.setDefaultGatewayAddress(defaultGatewayAddress);
        this.setMacAddress(macAddress);
        this.setMtu(mtu);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.GatewayInterface";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setMtu(Integer mtu) {
        if (this.mtu == null) {
            this.mtu = mtu;
        } else {
            log.warn("Read-only property mtu already contains a non-null value and cannot be set again");
        }
    }

    public static GatewayInterfaceBuilder GatewayInterfaceBuilder() {
        return new GatewayInterfaceBuilder();
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public String getSubnetReference() {
        return this.subnetReference;
    }

    public IPAddress getIpAddress() {
        return this.ipAddress;
    }

    public IPAddress getDefaultGatewayAddress() {
        return this.defaultGatewayAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    @JsonProperty(value="subnetReference")
    public void setSubnetReference(String subnetReference) {
        this.subnetReference = subnetReference;
    }

    @JsonProperty(value="ipAddress")
    public void setIpAddress(IPAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    @JsonProperty(value="defaultGatewayAddress")
    public void setDefaultGatewayAddress(IPAddress defaultGatewayAddress) {
        this.defaultGatewayAddress = defaultGatewayAddress;
    }

    @JsonProperty(value="macAddress")
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GatewayInterface)) {
            return false;
        }
        GatewayInterface other = (GatewayInterface)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$mtu = this.getMtu();
        Integer other$mtu = other.getMtu();
        if (this$mtu == null ? other$mtu != null : !((Object)this$mtu).equals(other$mtu)) {
            return false;
        }
        String this$subnetReference = this.getSubnetReference();
        String other$subnetReference = other.getSubnetReference();
        if (this$subnetReference == null ? other$subnetReference != null : !this$subnetReference.equals(other$subnetReference)) {
            return false;
        }
        IPAddress this$ipAddress = this.getIpAddress();
        IPAddress other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !((Object)this$ipAddress).equals(other$ipAddress)) {
            return false;
        }
        IPAddress this$defaultGatewayAddress = this.getDefaultGatewayAddress();
        IPAddress other$defaultGatewayAddress = other.getDefaultGatewayAddress();
        if (this$defaultGatewayAddress == null ? other$defaultGatewayAddress != null : !((Object)this$defaultGatewayAddress).equals(other$defaultGatewayAddress)) {
            return false;
        }
        String this$macAddress = this.getMacAddress();
        String other$macAddress = other.getMacAddress();
        return !(this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GatewayInterface;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $mtu = this.getMtu();
        result = result * 59 + ($mtu == null ? 43 : ((Object)$mtu).hashCode());
        String $subnetReference = this.getSubnetReference();
        result = result * 59 + ($subnetReference == null ? 43 : $subnetReference.hashCode());
        IPAddress $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : ((Object)$ipAddress).hashCode());
        IPAddress $defaultGatewayAddress = this.getDefaultGatewayAddress();
        result = result * 59 + ($defaultGatewayAddress == null ? 43 : ((Object)$defaultGatewayAddress).hashCode());
        String $macAddress = this.getMacAddress();
        result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
        return result;
    }

    public String toString() {
        return "GatewayInterface(mtu=" + this.getMtu() + ", subnetReference=" + this.getSubnetReference() + ", ipAddress=" + this.getIpAddress() + ", defaultGatewayAddress=" + this.getDefaultGatewayAddress() + ", macAddress=" + this.getMacAddress() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class GatewayInterfaceBuilder {
        private String subnetReference;
        private IPAddress ipAddress;
        private IPAddress defaultGatewayAddress;
        private String macAddress;
        private Integer mtu;

        GatewayInterfaceBuilder() {
        }

        public GatewayInterfaceBuilder subnetReference(String subnetReference) {
            this.subnetReference = subnetReference;
            return this;
        }

        public GatewayInterfaceBuilder ipAddress(IPAddress ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public GatewayInterfaceBuilder defaultGatewayAddress(IPAddress defaultGatewayAddress) {
            this.defaultGatewayAddress = defaultGatewayAddress;
            return this;
        }

        public GatewayInterfaceBuilder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public GatewayInterfaceBuilder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public GatewayInterface build() {
            return new GatewayInterface(this.subnetReference, this.ipAddress, this.defaultGatewayAddress, this.macAddress, this.mtu);
        }

        public String toString() {
            return "GatewayInterface.GatewayInterfaceBuilder(subnetReference=" + this.subnetReference + ", ipAddress=" + this.ipAddress + ", defaultGatewayAddress=" + this.defaultGatewayAddress + ", macAddress=" + this.macAddress + ", mtu=" + this.mtu + ")";
        }
    }
}

