/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayManagementInterface
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(GatewayManagementInterface.class);
    private Integer mtu = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="subnetReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String subnetReference = null;
    @Max(value=4095L)
    @Min(value=0L)
    @JsonProperty(value="vlanId")
    public @Max(value=4095L) @Min(value=0L) Integer vlanId = null;
    @JsonProperty(value="address")
    public IPAddress address = null;
    @JsonProperty(value="defaultGateway")
    public IPAddress defaultGateway = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public GatewayManagementInterface() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public GatewayManagementInterface(String subnetReference, Integer vlanId, IPAddress address, IPAddress defaultGateway, Integer mtu) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setSubnetReference(subnetReference);
        this.setVlanId(vlanId);
        this.setAddress(address);
        this.setDefaultGateway(defaultGateway);
        this.setMtu(mtu);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.GatewayManagementInterface";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setMtu(Integer mtu) {
        if (this.mtu == null) {
            this.mtu = mtu;
        } else {
            log.warn("Read-only property mtu already contains a non-null value and cannot be set again");
        }
    }

    public static GatewayManagementInterfaceBuilder GatewayManagementInterfaceBuilder() {
        return new GatewayManagementInterfaceBuilder();
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public String getSubnetReference() {
        return this.subnetReference;
    }

    public Integer getVlanId() {
        return this.vlanId;
    }

    public IPAddress getAddress() {
        return this.address;
    }

    public IPAddress getDefaultGateway() {
        return this.defaultGateway;
    }

    @JsonProperty(value="subnetReference")
    public void setSubnetReference(String subnetReference) {
        this.subnetReference = subnetReference;
    }

    @JsonProperty(value="vlanId")
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @JsonProperty(value="address")
    public void setAddress(IPAddress address) {
        this.address = address;
    }

    @JsonProperty(value="defaultGateway")
    public void setDefaultGateway(IPAddress defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GatewayManagementInterface)) {
            return false;
        }
        GatewayManagementInterface other = (GatewayManagementInterface)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$mtu = this.getMtu();
        Integer other$mtu = other.getMtu();
        if (this$mtu == null ? other$mtu != null : !((Object)this$mtu).equals(other$mtu)) {
            return false;
        }
        String this$subnetReference = this.getSubnetReference();
        String other$subnetReference = other.getSubnetReference();
        if (this$subnetReference == null ? other$subnetReference != null : !this$subnetReference.equals(other$subnetReference)) {
            return false;
        }
        Integer this$vlanId = this.getVlanId();
        Integer other$vlanId = other.getVlanId();
        if (this$vlanId == null ? other$vlanId != null : !((Object)this$vlanId).equals(other$vlanId)) {
            return false;
        }
        IPAddress this$address = this.getAddress();
        IPAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        IPAddress this$defaultGateway = this.getDefaultGateway();
        IPAddress other$defaultGateway = other.getDefaultGateway();
        return !(this$defaultGateway == null ? other$defaultGateway != null : !((Object)this$defaultGateway).equals(other$defaultGateway));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GatewayManagementInterface;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $mtu = this.getMtu();
        result = result * 59 + ($mtu == null ? 43 : ((Object)$mtu).hashCode());
        String $subnetReference = this.getSubnetReference();
        result = result * 59 + ($subnetReference == null ? 43 : $subnetReference.hashCode());
        Integer $vlanId = this.getVlanId();
        result = result * 59 + ($vlanId == null ? 43 : ((Object)$vlanId).hashCode());
        IPAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        IPAddress $defaultGateway = this.getDefaultGateway();
        result = result * 59 + ($defaultGateway == null ? 43 : ((Object)$defaultGateway).hashCode());
        return result;
    }

    public String toString() {
        return "GatewayManagementInterface(mtu=" + this.getMtu() + ", subnetReference=" + this.getSubnetReference() + ", vlanId=" + this.getVlanId() + ", address=" + this.getAddress() + ", defaultGateway=" + this.getDefaultGateway() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class GatewayManagementInterfaceBuilder {
        private String subnetReference;
        private Integer vlanId;
        private IPAddress address;
        private IPAddress defaultGateway;
        private Integer mtu;

        GatewayManagementInterfaceBuilder() {
        }

        public GatewayManagementInterfaceBuilder subnetReference(String subnetReference) {
            this.subnetReference = subnetReference;
            return this;
        }

        public GatewayManagementInterfaceBuilder vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public GatewayManagementInterfaceBuilder address(IPAddress address) {
            this.address = address;
            return this;
        }

        public GatewayManagementInterfaceBuilder defaultGateway(IPAddress defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        public GatewayManagementInterfaceBuilder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public GatewayManagementInterface build() {
            return new GatewayManagementInterface(this.subnetReference, this.vlanId, this.address, this.defaultGateway, this.mtu);
        }

        public String toString() {
            return "GatewayManagementInterface.GatewayManagementInterfaceBuilder(subnetReference=" + this.subnetReference + ", vlanId=" + this.vlanId + ", address=" + this.address + ", defaultGateway=" + this.defaultGateway + ", mtu=" + this.mtu + ")";
        }
    }
}

