/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPv4Subnet;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Host.class);
    @Size(max=128)
    private @Size(max=128) String internalBridgeName = null;
    private Integer routeTable = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="extId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String extId = null;
    @Size(min=0, max=32)
    @JsonProperty(value="hostNics")
    public @Size(min=0, max=32) List<String> hostNics = null;
    @JsonProperty(value="ipAddress")
    public IPv4Subnet ipAddress = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public Host() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public Host(String extId, String internalBridgeName, List<String> hostNics, IPv4Subnet ipAddress, Integer routeTable) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setExtId(extId);
        this.setInternalBridgeName(internalBridgeName);
        this.setHostNics(hostNics);
        this.setIpAddress(ipAddress);
        this.setRouteTable(routeTable);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.Host";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setInternalBridgeName(String internalBridgeName) {
        if (this.internalBridgeName == null) {
            this.internalBridgeName = internalBridgeName;
        } else {
            log.warn("Read-only property internalBridgeName already contains a non-null value and cannot be set again");
        }
    }

    public void setRouteTable(Integer routeTable) {
        if (this.routeTable == null) {
            this.routeTable = routeTable;
        } else {
            log.warn("Read-only property routeTable already contains a non-null value and cannot be set again");
        }
    }

    public static HostBuilder HostBuilder() {
        return new HostBuilder();
    }

    public String getInternalBridgeName() {
        return this.internalBridgeName;
    }

    public Integer getRouteTable() {
        return this.routeTable;
    }

    public String getExtId() {
        return this.extId;
    }

    public List<String> getHostNics() {
        return this.hostNics;
    }

    public IPv4Subnet getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="extId")
    public void setExtId(String extId) {
        this.extId = extId;
    }

    @JsonProperty(value="hostNics")
    public void setHostNics(List<String> hostNics) {
        this.hostNics = hostNics;
    }

    @JsonProperty(value="ipAddress")
    public void setIpAddress(IPv4Subnet ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Host)) {
            return false;
        }
        Host other = (Host)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$internalBridgeName = this.getInternalBridgeName();
        String other$internalBridgeName = other.getInternalBridgeName();
        if (this$internalBridgeName == null ? other$internalBridgeName != null : !this$internalBridgeName.equals(other$internalBridgeName)) {
            return false;
        }
        Integer this$routeTable = this.getRouteTable();
        Integer other$routeTable = other.getRouteTable();
        if (this$routeTable == null ? other$routeTable != null : !((Object)this$routeTable).equals(other$routeTable)) {
            return false;
        }
        String this$extId = this.getExtId();
        String other$extId = other.getExtId();
        if (this$extId == null ? other$extId != null : !this$extId.equals(other$extId)) {
            return false;
        }
        List<String> this$hostNics = this.getHostNics();
        List<String> other$hostNics = other.getHostNics();
        if (this$hostNics == null ? other$hostNics != null : !((Object)this$hostNics).equals(other$hostNics)) {
            return false;
        }
        IPv4Subnet this$ipAddress = this.getIpAddress();
        IPv4Subnet other$ipAddress = other.getIpAddress();
        return !(this$ipAddress == null ? other$ipAddress != null : !((Object)this$ipAddress).equals(other$ipAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Host;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $internalBridgeName = this.getInternalBridgeName();
        result = result * 59 + ($internalBridgeName == null ? 43 : $internalBridgeName.hashCode());
        Integer $routeTable = this.getRouteTable();
        result = result * 59 + ($routeTable == null ? 43 : ((Object)$routeTable).hashCode());
        String $extId = this.getExtId();
        result = result * 59 + ($extId == null ? 43 : $extId.hashCode());
        List<String> $hostNics = this.getHostNics();
        result = result * 59 + ($hostNics == null ? 43 : ((Object)$hostNics).hashCode());
        IPv4Subnet $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : ((Object)$ipAddress).hashCode());
        return result;
    }

    public String toString() {
        return "Host(internalBridgeName=" + this.getInternalBridgeName() + ", routeTable=" + this.getRouteTable() + ", extId=" + this.getExtId() + ", hostNics=" + this.getHostNics() + ", ipAddress=" + this.getIpAddress() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class HostBuilder {
        private String extId;
        private String internalBridgeName;
        private List<String> hostNics;
        private IPv4Subnet ipAddress;
        private Integer routeTable;

        HostBuilder() {
        }

        public HostBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public HostBuilder internalBridgeName(String internalBridgeName) {
            this.internalBridgeName = internalBridgeName;
            return this;
        }

        public HostBuilder hostNics(List<String> hostNics) {
            this.hostNics = hostNics;
            return this;
        }

        public HostBuilder ipAddress(IPv4Subnet ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public HostBuilder routeTable(Integer routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public Host build() {
            return new Host(this.extId, this.internalBridgeName, this.hostNics, this.ipAddress, this.routeTable);
        }

        public String toString() {
            return "Host.HostBuilder(extId=" + this.extId + ", internalBridgeName=" + this.internalBridgeName + ", hostNics=" + this.hostNics + ", ipAddress=" + this.ipAddress + ", routeTable=" + this.routeTable + ")";
        }
    }
}

