/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPv4Config;
import com.nutanix.dp1.net.networking.v4.config.IPv6Config;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPConfig
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPConfig.class);
    @JsonProperty(value="ipv4")
    public IPv4Config ipv4 = null;
    @JsonProperty(value="ipv6")
    public IPv6Config ipv6 = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IPConfig() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IPConfig(IPv4Config ipv4, IPv6Config ipv6) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setIpv4(ipv4);
        this.setIpv6(ipv6);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.IPConfig";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public boolean hasIpv4() {
        return this.ipv4 != null;
    }

    public boolean hasIpv6() {
        return this.ipv6 != null;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.hasIpv4() || this.hasIpv6();
    }

    public static IPConfigBuilder IPConfigBuilder() {
        return new IPConfigBuilder();
    }

    public IPv4Config getIpv4() {
        return this.ipv4;
    }

    public IPv6Config getIpv6() {
        return this.ipv6;
    }

    @JsonProperty(value="ipv4")
    public void setIpv4(IPv4Config ipv4) {
        this.ipv4 = ipv4;
    }

    @JsonProperty(value="ipv6")
    public void setIpv6(IPv6Config ipv6) {
        this.ipv6 = ipv6;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPConfig)) {
            return false;
        }
        IPConfig other = (IPConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPv4Config this$ipv4 = this.getIpv4();
        IPv4Config other$ipv4 = other.getIpv4();
        if (this$ipv4 == null ? other$ipv4 != null : !((Object)this$ipv4).equals(other$ipv4)) {
            return false;
        }
        IPv6Config this$ipv6 = this.getIpv6();
        IPv6Config other$ipv6 = other.getIpv6();
        return !(this$ipv6 == null ? other$ipv6 != null : !((Object)this$ipv6).equals(other$ipv6));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPv4Config $ipv4 = this.getIpv4();
        result = result * 59 + ($ipv4 == null ? 43 : ((Object)$ipv4).hashCode());
        IPv6Config $ipv6 = this.getIpv6();
        result = result * 59 + ($ipv6 == null ? 43 : ((Object)$ipv6).hashCode());
        return result;
    }

    public String toString() {
        return "IPConfig(ipv4=" + this.getIpv4() + ", ipv6=" + this.getIpv6() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IPConfigBuilder {
        private IPv4Config ipv4;
        private IPv6Config ipv6;

        IPConfigBuilder() {
        }

        public IPConfigBuilder ipv4(IPv4Config ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public IPConfigBuilder ipv6(IPv6Config ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public IPConfig build() {
            return new IPConfig(this.ipv4, this.ipv6);
        }

        public String toString() {
            return "IPConfig.IPConfigBuilder(ipv4=" + this.ipv4 + ", ipv6=" + this.ipv6 + ")";
        }
    }
}

