/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.ExportScope;
import com.nutanix.dp1.net.networking.v4.config.ExporterProtocol;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFIXExporter
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPFIXExporter.class);
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Pattern(regexp="^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$")
    @JsonProperty(value="collectorIp")
    public @Pattern(regexp="^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$") String collectorIp = null;
    @JsonProperty(value="protocol")
    public ExporterProtocol protocol = null;
    @JsonProperty(value="collectorPort")
    public Long collectorPort = null;
    @JsonProperty(value="exportRateLimitPerNodeBps")
    public Long exportRateLimitPerNodeBps = null;
    @Size(min=1, max=64)
    @JsonProperty(value="exportScopes")
    public @Size(min=1, max=64) List<ExportScope> exportScopes = null;
    @JsonProperty(value="description")
    public String description = null;

    public IPFIXExporter() {
    }

    public IPFIXExporter(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String collectorIp, ExporterProtocol protocol, Long collectorPort, Long exportRateLimitPerNodeBps, List<ExportScope> exportScopes, String description) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setCollectorIp(collectorIp);
        this.setProtocol(protocol);
        this.setCollectorPort(collectorPort);
        this.setExportRateLimitPerNodeBps(exportRateLimitPerNodeBps);
        this.setExportScopes(exportScopes);
        this.setDescription(description);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.IPFIXExporter";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static IPFIXExporterBuilder IPFIXExporterBuilder() {
        return new IPFIXExporterBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPFIXExporter)) {
            return false;
        }
        IPFIXExporter other = (IPFIXExporter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$collectorIp = this.getCollectorIp();
        String other$collectorIp = other.getCollectorIp();
        if (this$collectorIp == null ? other$collectorIp != null : !this$collectorIp.equals(other$collectorIp)) {
            return false;
        }
        ExporterProtocol this$protocol = this.getProtocol();
        ExporterProtocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        Long this$collectorPort = this.getCollectorPort();
        Long other$collectorPort = other.getCollectorPort();
        if (this$collectorPort == null ? other$collectorPort != null : !((Object)this$collectorPort).equals(other$collectorPort)) {
            return false;
        }
        Long this$exportRateLimitPerNodeBps = this.getExportRateLimitPerNodeBps();
        Long other$exportRateLimitPerNodeBps = other.getExportRateLimitPerNodeBps();
        if (this$exportRateLimitPerNodeBps == null ? other$exportRateLimitPerNodeBps != null : !((Object)this$exportRateLimitPerNodeBps).equals(other$exportRateLimitPerNodeBps)) {
            return false;
        }
        List<ExportScope> this$exportScopes = this.getExportScopes();
        List<ExportScope> other$exportScopes = other.getExportScopes();
        if (this$exportScopes == null ? other$exportScopes != null : !((Object)this$exportScopes).equals(other$exportScopes)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IPFIXExporter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $collectorIp = this.getCollectorIp();
        result = result * 59 + ($collectorIp == null ? 43 : $collectorIp.hashCode());
        ExporterProtocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        Long $collectorPort = this.getCollectorPort();
        result = result * 59 + ($collectorPort == null ? 43 : ((Object)$collectorPort).hashCode());
        Long $exportRateLimitPerNodeBps = this.getExportRateLimitPerNodeBps();
        result = result * 59 + ($exportRateLimitPerNodeBps == null ? 43 : ((Object)$exportRateLimitPerNodeBps).hashCode());
        List<ExportScope> $exportScopes = this.getExportScopes();
        result = result * 59 + ($exportScopes == null ? 43 : ((Object)$exportScopes).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getCollectorIp() {
        return this.collectorIp;
    }

    public ExporterProtocol getProtocol() {
        return this.protocol;
    }

    public Long getCollectorPort() {
        return this.collectorPort;
    }

    public Long getExportRateLimitPerNodeBps() {
        return this.exportRateLimitPerNodeBps;
    }

    public List<ExportScope> getExportScopes() {
        return this.exportScopes;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="collectorIp")
    public void setCollectorIp(String collectorIp) {
        this.collectorIp = collectorIp;
    }

    @JsonProperty(value="protocol")
    public void setProtocol(ExporterProtocol protocol) {
        this.protocol = protocol;
    }

    @JsonProperty(value="collectorPort")
    public void setCollectorPort(Long collectorPort) {
        this.collectorPort = collectorPort;
    }

    @JsonProperty(value="exportRateLimitPerNodeBps")
    public void setExportRateLimitPerNodeBps(Long exportRateLimitPerNodeBps) {
        this.exportRateLimitPerNodeBps = exportRateLimitPerNodeBps;
    }

    @JsonProperty(value="exportScopes")
    public void setExportScopes(List<ExportScope> exportScopes) {
        this.exportScopes = exportScopes;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "IPFIXExporter(name=" + this.getName() + ", collectorIp=" + this.getCollectorIp() + ", protocol=" + (Object)((Object)this.getProtocol()) + ", collectorPort=" + this.getCollectorPort() + ", exportRateLimitPerNodeBps=" + this.getExportRateLimitPerNodeBps() + ", exportScopes=" + this.getExportScopes() + ", description=" + this.getDescription() + ")";
    }

    public static class IPFIXExporterBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String collectorIp;
        private ExporterProtocol protocol;
        private Long collectorPort;
        private Long exportRateLimitPerNodeBps;
        private List<ExportScope> exportScopes;
        private String description;

        IPFIXExporterBuilder() {
        }

        public IPFIXExporterBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public IPFIXExporterBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public IPFIXExporterBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public IPFIXExporterBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public IPFIXExporterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public IPFIXExporterBuilder collectorIp(String collectorIp) {
            this.collectorIp = collectorIp;
            return this;
        }

        public IPFIXExporterBuilder protocol(ExporterProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public IPFIXExporterBuilder collectorPort(Long collectorPort) {
            this.collectorPort = collectorPort;
            return this;
        }

        public IPFIXExporterBuilder exportRateLimitPerNodeBps(Long exportRateLimitPerNodeBps) {
            this.exportRateLimitPerNodeBps = exportRateLimitPerNodeBps;
            return this;
        }

        public IPFIXExporterBuilder exportScopes(List<ExportScope> exportScopes) {
            this.exportScopes = exportScopes;
            return this;
        }

        public IPFIXExporterBuilder description(String description) {
            this.description = description;
            return this;
        }

        public IPFIXExporter build() {
            return new IPFIXExporter(this.tenantId, this.extId, this.links, this.metadata, this.name, this.collectorIp, this.protocol, this.collectorPort, this.exportRateLimitPerNodeBps, this.exportScopes, this.description);
        }

        public String toString() {
            return "IPFIXExporter.IPFIXExporterBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", collectorIp=" + this.collectorIp + ", protocol=" + (Object)((Object)this.protocol) + ", collectorPort=" + this.collectorPort + ", exportRateLimitPerNodeBps=" + this.exportRateLimitPerNodeBps + ", exportScopes=" + this.exportScopes + ", description=" + this.description + ")";
        }
    }
}

