/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPv4Pool;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPPoolUsage
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPPoolUsage.class);
    @Min(value=0L)
    @JsonProperty(value="numFreeIPs")
    public @Min(value=0L) Long numFreeIPs = null;
    @Min(value=0L)
    @JsonProperty(value="numTotalIPs")
    public @Min(value=0L) Long numTotalIPs = null;
    @JsonProperty(value="range")
    public IPv4Pool range = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IPPoolUsage() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IPPoolUsage(Long numFreeIPs, Long numTotalIPs, IPv4Pool range) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setNumFreeIPs(numFreeIPs);
        this.setNumTotalIPs(numTotalIPs);
        this.setRange(range);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.IPPoolUsage";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static IPPoolUsageBuilder IPPoolUsageBuilder() {
        return new IPPoolUsageBuilder();
    }

    public Long getNumFreeIPs() {
        return this.numFreeIPs;
    }

    public Long getNumTotalIPs() {
        return this.numTotalIPs;
    }

    public IPv4Pool getRange() {
        return this.range;
    }

    @JsonProperty(value="numFreeIPs")
    public void setNumFreeIPs(Long numFreeIPs) {
        this.numFreeIPs = numFreeIPs;
    }

    @JsonProperty(value="numTotalIPs")
    public void setNumTotalIPs(Long numTotalIPs) {
        this.numTotalIPs = numTotalIPs;
    }

    @JsonProperty(value="range")
    public void setRange(IPv4Pool range) {
        this.range = range;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPPoolUsage)) {
            return false;
        }
        IPPoolUsage other = (IPPoolUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$numFreeIPs = this.getNumFreeIPs();
        Long other$numFreeIPs = other.getNumFreeIPs();
        if (this$numFreeIPs == null ? other$numFreeIPs != null : !((Object)this$numFreeIPs).equals(other$numFreeIPs)) {
            return false;
        }
        Long this$numTotalIPs = this.getNumTotalIPs();
        Long other$numTotalIPs = other.getNumTotalIPs();
        if (this$numTotalIPs == null ? other$numTotalIPs != null : !((Object)this$numTotalIPs).equals(other$numTotalIPs)) {
            return false;
        }
        IPv4Pool this$range = this.getRange();
        IPv4Pool other$range = other.getRange();
        return !(this$range == null ? other$range != null : !((Object)this$range).equals(other$range));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPPoolUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numFreeIPs = this.getNumFreeIPs();
        result = result * 59 + ($numFreeIPs == null ? 43 : ((Object)$numFreeIPs).hashCode());
        Long $numTotalIPs = this.getNumTotalIPs();
        result = result * 59 + ($numTotalIPs == null ? 43 : ((Object)$numTotalIPs).hashCode());
        IPv4Pool $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        return result;
    }

    public String toString() {
        return "IPPoolUsage(numFreeIPs=" + this.getNumFreeIPs() + ", numTotalIPs=" + this.getNumTotalIPs() + ", range=" + this.getRange() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IPPoolUsageBuilder {
        private Long numFreeIPs;
        private Long numTotalIPs;
        private IPv4Pool range;

        IPPoolUsageBuilder() {
        }

        public IPPoolUsageBuilder numFreeIPs(Long numFreeIPs) {
            this.numFreeIPs = numFreeIPs;
            return this;
        }

        public IPPoolUsageBuilder numTotalIPs(Long numTotalIPs) {
            this.numTotalIPs = numTotalIPs;
            return this;
        }

        public IPPoolUsageBuilder range(IPv4Pool range) {
            this.range = range;
            return this;
        }

        public IPPoolUsage build() {
            return new IPPoolUsage(this.numFreeIPs, this.numTotalIPs, this.range);
        }

        public String toString() {
            return "IPPoolUsage.IPPoolUsageBuilder(numFreeIPs=" + this.numFreeIPs + ", numTotalIPs=" + this.numTotalIPs + ", range=" + this.range + ")";
        }
    }
}

