/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPPoolUsage;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUsage
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPUsage.class);
    @Size(min=0, max=255)
    private @Size(min=0, max=255) List<IPPoolUsage> ipPoolUsages = null;
    @Min(value=0L)
    @JsonProperty(value="numMacs")
    public @Min(value=0L) Long numMacs = null;
    @Min(value=0L)
    @JsonProperty(value="numFreeIPs")
    public @Min(value=0L) Long numFreeIPs = null;
    @Min(value=0L)
    @JsonProperty(value="numAssignedIPs")
    public @Min(value=0L) Long numAssignedIPs = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IPUsage() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IPUsage(Long numMacs, Long numFreeIPs, Long numAssignedIPs, List<IPPoolUsage> ipPoolUsages) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setNumMacs(numMacs);
        this.setNumFreeIPs(numFreeIPs);
        this.setNumAssignedIPs(numAssignedIPs);
        this.setIpPoolUsages(ipPoolUsages);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.IPUsage";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setIpPoolUsages(List<IPPoolUsage> ipPoolUsages) {
        if (this.ipPoolUsages == null) {
            this.ipPoolUsages = ipPoolUsages;
        } else {
            log.warn("Read-only property ipPoolUsages already contains a non-null value and cannot be set again");
        }
    }

    public static IPUsageBuilder IPUsageBuilder() {
        return new IPUsageBuilder();
    }

    public List<IPPoolUsage> getIpPoolUsages() {
        return this.ipPoolUsages;
    }

    public Long getNumMacs() {
        return this.numMacs;
    }

    public Long getNumFreeIPs() {
        return this.numFreeIPs;
    }

    public Long getNumAssignedIPs() {
        return this.numAssignedIPs;
    }

    @JsonProperty(value="numMacs")
    public void setNumMacs(Long numMacs) {
        this.numMacs = numMacs;
    }

    @JsonProperty(value="numFreeIPs")
    public void setNumFreeIPs(Long numFreeIPs) {
        this.numFreeIPs = numFreeIPs;
    }

    @JsonProperty(value="numAssignedIPs")
    public void setNumAssignedIPs(Long numAssignedIPs) {
        this.numAssignedIPs = numAssignedIPs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPUsage)) {
            return false;
        }
        IPUsage other = (IPUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IPPoolUsage> this$ipPoolUsages = this.getIpPoolUsages();
        List<IPPoolUsage> other$ipPoolUsages = other.getIpPoolUsages();
        if (this$ipPoolUsages == null ? other$ipPoolUsages != null : !((Object)this$ipPoolUsages).equals(other$ipPoolUsages)) {
            return false;
        }
        Long this$numMacs = this.getNumMacs();
        Long other$numMacs = other.getNumMacs();
        if (this$numMacs == null ? other$numMacs != null : !((Object)this$numMacs).equals(other$numMacs)) {
            return false;
        }
        Long this$numFreeIPs = this.getNumFreeIPs();
        Long other$numFreeIPs = other.getNumFreeIPs();
        if (this$numFreeIPs == null ? other$numFreeIPs != null : !((Object)this$numFreeIPs).equals(other$numFreeIPs)) {
            return false;
        }
        Long this$numAssignedIPs = this.getNumAssignedIPs();
        Long other$numAssignedIPs = other.getNumAssignedIPs();
        return !(this$numAssignedIPs == null ? other$numAssignedIPs != null : !((Object)this$numAssignedIPs).equals(other$numAssignedIPs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IPPoolUsage> $ipPoolUsages = this.getIpPoolUsages();
        result = result * 59 + ($ipPoolUsages == null ? 43 : ((Object)$ipPoolUsages).hashCode());
        Long $numMacs = this.getNumMacs();
        result = result * 59 + ($numMacs == null ? 43 : ((Object)$numMacs).hashCode());
        Long $numFreeIPs = this.getNumFreeIPs();
        result = result * 59 + ($numFreeIPs == null ? 43 : ((Object)$numFreeIPs).hashCode());
        Long $numAssignedIPs = this.getNumAssignedIPs();
        result = result * 59 + ($numAssignedIPs == null ? 43 : ((Object)$numAssignedIPs).hashCode());
        return result;
    }

    public String toString() {
        return "IPUsage(ipPoolUsages=" + this.getIpPoolUsages() + ", numMacs=" + this.getNumMacs() + ", numFreeIPs=" + this.getNumFreeIPs() + ", numAssignedIPs=" + this.getNumAssignedIPs() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IPUsageBuilder {
        private Long numMacs;
        private Long numFreeIPs;
        private Long numAssignedIPs;
        private List<IPPoolUsage> ipPoolUsages;

        IPUsageBuilder() {
        }

        public IPUsageBuilder numMacs(Long numMacs) {
            this.numMacs = numMacs;
            return this;
        }

        public IPUsageBuilder numFreeIPs(Long numFreeIPs) {
            this.numFreeIPs = numFreeIPs;
            return this;
        }

        public IPUsageBuilder numAssignedIPs(Long numAssignedIPs) {
            this.numAssignedIPs = numAssignedIPs;
            return this;
        }

        public IPUsageBuilder ipPoolUsages(List<IPPoolUsage> ipPoolUsages) {
            this.ipPoolUsages = ipPoolUsages;
            return this;
        }

        public IPUsage build() {
            return new IPUsage(this.numMacs, this.numFreeIPs, this.numAssignedIPs, this.ipPoolUsages);
        }

        public String toString() {
            return "IPUsage.IPUsageBuilder(numMacs=" + this.numMacs + ", numFreeIPs=" + this.numFreeIPs + ", numAssignedIPs=" + this.numAssignedIPs + ", ipPoolUsages=" + this.ipPoolUsages + ")";
        }
    }
}

