/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPv4Address;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPv4Pool;
import com.nutanix.dp1.net.networking.v4.config.IPv4Subnet;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv4Config
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPv4Config.class);
    @JsonProperty(value="ipSubnet")
    public IPv4Subnet ipSubnet = null;
    @JsonProperty(value="defaultGatewayIp")
    public IPv4Address defaultGatewayIp = null;
    @JsonProperty(value="dhcpServerAddress")
    public IPv4Address dhcpServerAddress = null;
    @Size(min=0, max=255)
    @JsonProperty(value="poolList")
    public @Size(min=0, max=255) List<IPv4Pool> poolList = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IPv4Config() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IPv4Config(IPv4Subnet ipSubnet, IPv4Address defaultGatewayIp, IPv4Address dhcpServerAddress, List<IPv4Pool> poolList) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setIpSubnet(ipSubnet);
        this.setDefaultGatewayIp(defaultGatewayIp);
        this.setDhcpServerAddress(dhcpServerAddress);
        this.setPoolList(poolList);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.IPv4Config";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static IPv4ConfigBuilder IPv4ConfigBuilder() {
        return new IPv4ConfigBuilder();
    }

    public IPv4Subnet getIpSubnet() {
        return this.ipSubnet;
    }

    public IPv4Address getDefaultGatewayIp() {
        return this.defaultGatewayIp;
    }

    public IPv4Address getDhcpServerAddress() {
        return this.dhcpServerAddress;
    }

    public List<IPv4Pool> getPoolList() {
        return this.poolList;
    }

    @JsonProperty(value="ipSubnet")
    public void setIpSubnet(IPv4Subnet ipSubnet) {
        this.ipSubnet = ipSubnet;
    }

    @JsonProperty(value="defaultGatewayIp")
    public void setDefaultGatewayIp(IPv4Address defaultGatewayIp) {
        this.defaultGatewayIp = defaultGatewayIp;
    }

    @JsonProperty(value="dhcpServerAddress")
    public void setDhcpServerAddress(IPv4Address dhcpServerAddress) {
        this.dhcpServerAddress = dhcpServerAddress;
    }

    @JsonProperty(value="poolList")
    public void setPoolList(List<IPv4Pool> poolList) {
        this.poolList = poolList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPv4Config)) {
            return false;
        }
        IPv4Config other = (IPv4Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPv4Subnet this$ipSubnet = this.getIpSubnet();
        IPv4Subnet other$ipSubnet = other.getIpSubnet();
        if (this$ipSubnet == null ? other$ipSubnet != null : !((Object)this$ipSubnet).equals(other$ipSubnet)) {
            return false;
        }
        IPv4Address this$defaultGatewayIp = this.getDefaultGatewayIp();
        IPv4Address other$defaultGatewayIp = other.getDefaultGatewayIp();
        if (this$defaultGatewayIp == null ? other$defaultGatewayIp != null : !((Object)this$defaultGatewayIp).equals(other$defaultGatewayIp)) {
            return false;
        }
        IPv4Address this$dhcpServerAddress = this.getDhcpServerAddress();
        IPv4Address other$dhcpServerAddress = other.getDhcpServerAddress();
        if (this$dhcpServerAddress == null ? other$dhcpServerAddress != null : !((Object)this$dhcpServerAddress).equals(other$dhcpServerAddress)) {
            return false;
        }
        List<IPv4Pool> this$poolList = this.getPoolList();
        List<IPv4Pool> other$poolList = other.getPoolList();
        return !(this$poolList == null ? other$poolList != null : !((Object)this$poolList).equals(other$poolList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPv4Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPv4Subnet $ipSubnet = this.getIpSubnet();
        result = result * 59 + ($ipSubnet == null ? 43 : ((Object)$ipSubnet).hashCode());
        IPv4Address $defaultGatewayIp = this.getDefaultGatewayIp();
        result = result * 59 + ($defaultGatewayIp == null ? 43 : ((Object)$defaultGatewayIp).hashCode());
        IPv4Address $dhcpServerAddress = this.getDhcpServerAddress();
        result = result * 59 + ($dhcpServerAddress == null ? 43 : ((Object)$dhcpServerAddress).hashCode());
        List<IPv4Pool> $poolList = this.getPoolList();
        result = result * 59 + ($poolList == null ? 43 : ((Object)$poolList).hashCode());
        return result;
    }

    public String toString() {
        return "IPv4Config(ipSubnet=" + this.getIpSubnet() + ", defaultGatewayIp=" + this.getDefaultGatewayIp() + ", dhcpServerAddress=" + this.getDhcpServerAddress() + ", poolList=" + this.getPoolList() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IPv4ConfigBuilder {
        private IPv4Subnet ipSubnet;
        private IPv4Address defaultGatewayIp;
        private IPv4Address dhcpServerAddress;
        private List<IPv4Pool> poolList;

        IPv4ConfigBuilder() {
        }

        public IPv4ConfigBuilder ipSubnet(IPv4Subnet ipSubnet) {
            this.ipSubnet = ipSubnet;
            return this;
        }

        public IPv4ConfigBuilder defaultGatewayIp(IPv4Address defaultGatewayIp) {
            this.defaultGatewayIp = defaultGatewayIp;
            return this;
        }

        public IPv4ConfigBuilder dhcpServerAddress(IPv4Address dhcpServerAddress) {
            this.dhcpServerAddress = dhcpServerAddress;
            return this;
        }

        public IPv4ConfigBuilder poolList(List<IPv4Pool> poolList) {
            this.poolList = poolList;
            return this;
        }

        public IPv4Config build() {
            return new IPv4Config(this.ipSubnet, this.defaultGatewayIp, this.dhcpServerAddress, this.poolList);
        }

        public String toString() {
            return "IPv4Config.IPv4ConfigBuilder(ipSubnet=" + this.ipSubnet + ", defaultGatewayIp=" + this.defaultGatewayIp + ", dhcpServerAddress=" + this.dhcpServerAddress + ", poolList=" + this.poolList + ")";
        }
    }
}

