/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPv6Address;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPv6Pool;
import com.nutanix.dp1.net.networking.v4.config.IPv6Subnet;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv6Config
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPv6Config.class);
    @JsonProperty(value="ipSubnet")
    public IPv6Subnet ipSubnet = null;
    @JsonProperty(value="defaultGatewayIp")
    public IPv6Address defaultGatewayIp = null;
    @JsonProperty(value="dhcpServerAddress")
    public IPv6Address dhcpServerAddress = null;
    @Size(min=0, max=255)
    @JsonProperty(value="poolList")
    public @Size(min=0, max=255) List<IPv6Pool> poolList = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IPv6Config() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IPv6Config(IPv6Subnet ipSubnet, IPv6Address defaultGatewayIp, IPv6Address dhcpServerAddress, List<IPv6Pool> poolList) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setIpSubnet(ipSubnet);
        this.setDefaultGatewayIp(defaultGatewayIp);
        this.setDhcpServerAddress(dhcpServerAddress);
        this.setPoolList(poolList);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.IPv6Config";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static IPv6ConfigBuilder IPv6ConfigBuilder() {
        return new IPv6ConfigBuilder();
    }

    public IPv6Subnet getIpSubnet() {
        return this.ipSubnet;
    }

    public IPv6Address getDefaultGatewayIp() {
        return this.defaultGatewayIp;
    }

    public IPv6Address getDhcpServerAddress() {
        return this.dhcpServerAddress;
    }

    public List<IPv6Pool> getPoolList() {
        return this.poolList;
    }

    @JsonProperty(value="ipSubnet")
    public void setIpSubnet(IPv6Subnet ipSubnet) {
        this.ipSubnet = ipSubnet;
    }

    @JsonProperty(value="defaultGatewayIp")
    public void setDefaultGatewayIp(IPv6Address defaultGatewayIp) {
        this.defaultGatewayIp = defaultGatewayIp;
    }

    @JsonProperty(value="dhcpServerAddress")
    public void setDhcpServerAddress(IPv6Address dhcpServerAddress) {
        this.dhcpServerAddress = dhcpServerAddress;
    }

    @JsonProperty(value="poolList")
    public void setPoolList(List<IPv6Pool> poolList) {
        this.poolList = poolList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPv6Config)) {
            return false;
        }
        IPv6Config other = (IPv6Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPv6Subnet this$ipSubnet = this.getIpSubnet();
        IPv6Subnet other$ipSubnet = other.getIpSubnet();
        if (this$ipSubnet == null ? other$ipSubnet != null : !((Object)this$ipSubnet).equals(other$ipSubnet)) {
            return false;
        }
        IPv6Address this$defaultGatewayIp = this.getDefaultGatewayIp();
        IPv6Address other$defaultGatewayIp = other.getDefaultGatewayIp();
        if (this$defaultGatewayIp == null ? other$defaultGatewayIp != null : !((Object)this$defaultGatewayIp).equals(other$defaultGatewayIp)) {
            return false;
        }
        IPv6Address this$dhcpServerAddress = this.getDhcpServerAddress();
        IPv6Address other$dhcpServerAddress = other.getDhcpServerAddress();
        if (this$dhcpServerAddress == null ? other$dhcpServerAddress != null : !((Object)this$dhcpServerAddress).equals(other$dhcpServerAddress)) {
            return false;
        }
        List<IPv6Pool> this$poolList = this.getPoolList();
        List<IPv6Pool> other$poolList = other.getPoolList();
        return !(this$poolList == null ? other$poolList != null : !((Object)this$poolList).equals(other$poolList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPv6Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPv6Subnet $ipSubnet = this.getIpSubnet();
        result = result * 59 + ($ipSubnet == null ? 43 : ((Object)$ipSubnet).hashCode());
        IPv6Address $defaultGatewayIp = this.getDefaultGatewayIp();
        result = result * 59 + ($defaultGatewayIp == null ? 43 : ((Object)$defaultGatewayIp).hashCode());
        IPv6Address $dhcpServerAddress = this.getDhcpServerAddress();
        result = result * 59 + ($dhcpServerAddress == null ? 43 : ((Object)$dhcpServerAddress).hashCode());
        List<IPv6Pool> $poolList = this.getPoolList();
        result = result * 59 + ($poolList == null ? 43 : ((Object)$poolList).hashCode());
        return result;
    }

    public String toString() {
        return "IPv6Config(ipSubnet=" + this.getIpSubnet() + ", defaultGatewayIp=" + this.getDefaultGatewayIp() + ", dhcpServerAddress=" + this.getDhcpServerAddress() + ", poolList=" + this.getPoolList() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IPv6ConfigBuilder {
        private IPv6Subnet ipSubnet;
        private IPv6Address defaultGatewayIp;
        private IPv6Address dhcpServerAddress;
        private List<IPv6Pool> poolList;

        IPv6ConfigBuilder() {
        }

        public IPv6ConfigBuilder ipSubnet(IPv6Subnet ipSubnet) {
            this.ipSubnet = ipSubnet;
            return this;
        }

        public IPv6ConfigBuilder defaultGatewayIp(IPv6Address defaultGatewayIp) {
            this.defaultGatewayIp = defaultGatewayIp;
            return this;
        }

        public IPv6ConfigBuilder dhcpServerAddress(IPv6Address dhcpServerAddress) {
            this.dhcpServerAddress = dhcpServerAddress;
            return this;
        }

        public IPv6ConfigBuilder poolList(List<IPv6Pool> poolList) {
            this.poolList = poolList;
            return this;
        }

        public IPv6Config build() {
            return new IPv6Config(this.ipSubnet, this.defaultGatewayIp, this.dhcpServerAddress, this.poolList);
        }

        public String toString() {
            return "IPv6Config.IPv6ConfigBuilder(ipSubnet=" + this.ipSubnet + ", defaultGatewayIp=" + this.defaultGatewayIp + ", dhcpServerAddress=" + this.dhcpServerAddress + ", poolList=" + this.poolList + ")";
        }
    }
}

