/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPv6Address;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv6Subnet
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPv6Subnet.class);
    @JsonProperty(value="ip")
    public IPv6Address ip = null;
    @Max(value=128L)
    @Min(value=0L)
    @JsonProperty(value="prefixLength")
    public @Max(value=128L) @Min(value=0L) Integer prefixLength = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IPv6Subnet() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IPv6Subnet(IPv6Address ip, Integer prefixLength) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setIp(ip);
        this.setPrefixLength(prefixLength);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.IPv6Subnet";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static IPv6SubnetBuilder IPv6SubnetBuilder() {
        return new IPv6SubnetBuilder();
    }

    public IPv6Address getIp() {
        return this.ip;
    }

    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    @JsonProperty(value="ip")
    public void setIp(IPv6Address ip) {
        this.ip = ip;
    }

    @JsonProperty(value="prefixLength")
    public void setPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPv6Subnet)) {
            return false;
        }
        IPv6Subnet other = (IPv6Subnet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPv6Address this$ip = this.getIp();
        IPv6Address other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !((Object)this$ip).equals(other$ip)) {
            return false;
        }
        Integer this$prefixLength = this.getPrefixLength();
        Integer other$prefixLength = other.getPrefixLength();
        return !(this$prefixLength == null ? other$prefixLength != null : !((Object)this$prefixLength).equals(other$prefixLength));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPv6Subnet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPv6Address $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : ((Object)$ip).hashCode());
        Integer $prefixLength = this.getPrefixLength();
        result = result * 59 + ($prefixLength == null ? 43 : ((Object)$prefixLength).hashCode());
        return result;
    }

    public String toString() {
        return "IPv6Subnet(ip=" + this.getIp() + ", prefixLength=" + this.getPrefixLength() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IPv6SubnetBuilder {
        private IPv6Address ip;
        private Integer prefixLength;

        IPv6SubnetBuilder() {
        }

        public IPv6SubnetBuilder ip(IPv6Address ip) {
            this.ip = ip;
            return this;
        }

        public IPv6SubnetBuilder prefixLength(Integer prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public IPv6Subnet build() {
            return new IPv6Subnet(this.ip, this.prefixLength);
        }

        public String toString() {
            return "IPv6Subnet.IPv6SubnetBuilder(ip=" + this.ip + ", prefixLength=" + this.prefixLength + ")";
        }
    }
}

