/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.BgpConfig;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbgpConfig
extends BgpConfig
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IbgpConfig.class);
    @JsonProperty(value="peerIp")
    public IPAddress peerIp = null;

    public IbgpConfig() {
    }

    public IbgpConfig(Long asn, String password, Boolean shouldRedistributeRoutes, IPAddress peerIp) {
        super(asn, password, shouldRedistributeRoutes);
        this.setPeerIp(peerIp);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.IbgpConfig";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static IbgpConfigBuilder IbgpConfigBuilder() {
        return new IbgpConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IbgpConfig)) {
            return false;
        }
        IbgpConfig other = (IbgpConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPAddress this$peerIp = this.getPeerIp();
        IPAddress other$peerIp = other.getPeerIp();
        return !(this$peerIp == null ? other$peerIp != null : !((Object)this$peerIp).equals(other$peerIp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IbgpConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IPAddress $peerIp = this.getPeerIp();
        result = result * 59 + ($peerIp == null ? 43 : ((Object)$peerIp).hashCode());
        return result;
    }

    public IPAddress getPeerIp() {
        return this.peerIp;
    }

    @JsonProperty(value="peerIp")
    public void setPeerIp(IPAddress peerIp) {
        this.peerIp = peerIp;
    }

    @Override
    public String toString() {
        return "IbgpConfig(peerIp=" + this.getPeerIp() + ")";
    }

    public static class IbgpConfigBuilder {
        private Long asn;
        private String password;
        private Boolean shouldRedistributeRoutes;
        private IPAddress peerIp;

        IbgpConfigBuilder() {
        }

        public IbgpConfigBuilder asn(Long asn) {
            this.asn = asn;
            return this;
        }

        public IbgpConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public IbgpConfigBuilder shouldRedistributeRoutes(Boolean shouldRedistributeRoutes) {
            this.shouldRedistributeRoutes = shouldRedistributeRoutes;
            return this;
        }

        public IbgpConfigBuilder peerIp(IPAddress peerIp) {
            this.peerIp = peerIp;
            return this;
        }

        public IbgpConfig build() {
            return new IbgpConfig(this.asn, this.password, this.shouldRedistributeRoutes, this.peerIp);
        }

        public String toString() {
            return "IbgpConfig.IbgpConfigBuilder(asn=" + this.asn + ", password=" + this.password + ", shouldRedistributeRoutes=" + this.shouldRedistributeRoutes + ", peerIp=" + this.peerIp + ")";
        }
    }
}

