/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.IPSubnet;
import com.nutanix.dp1.net.networking.v4.config.IbgpConfig;
import com.nutanix.dp1.net.networking.v4.config.OspfConfig;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalRoutingConfig
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(InternalRoutingConfig.class);
    @JsonProperty(value="ospfConfig")
    public OspfConfig ospfConfig = null;
    @Size(min=0, max=32)
    @JsonProperty(value="ibgpConfigList")
    public @Size(min=0, max=32) List<IbgpConfig> ibgpConfigList = null;
    @Size(min=0, max=250)
    @JsonProperty(value="localPrefixList")
    public @Size(min=0, max=250) List<IPSubnet> localPrefixList = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public InternalRoutingConfig() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public InternalRoutingConfig(OspfConfig ospfConfig, List<IbgpConfig> ibgpConfigList, List<IPSubnet> localPrefixList) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setOspfConfig(ospfConfig);
        this.setIbgpConfigList(ibgpConfigList);
        this.setLocalPrefixList(localPrefixList);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.InternalRoutingConfig";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static InternalRoutingConfigBuilder InternalRoutingConfigBuilder() {
        return new InternalRoutingConfigBuilder();
    }

    public OspfConfig getOspfConfig() {
        return this.ospfConfig;
    }

    public List<IbgpConfig> getIbgpConfigList() {
        return this.ibgpConfigList;
    }

    public List<IPSubnet> getLocalPrefixList() {
        return this.localPrefixList;
    }

    @JsonProperty(value="ospfConfig")
    public void setOspfConfig(OspfConfig ospfConfig) {
        this.ospfConfig = ospfConfig;
    }

    @JsonProperty(value="ibgpConfigList")
    public void setIbgpConfigList(List<IbgpConfig> ibgpConfigList) {
        this.ibgpConfigList = ibgpConfigList;
    }

    @JsonProperty(value="localPrefixList")
    public void setLocalPrefixList(List<IPSubnet> localPrefixList) {
        this.localPrefixList = localPrefixList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalRoutingConfig)) {
            return false;
        }
        InternalRoutingConfig other = (InternalRoutingConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OspfConfig this$ospfConfig = this.getOspfConfig();
        OspfConfig other$ospfConfig = other.getOspfConfig();
        if (this$ospfConfig == null ? other$ospfConfig != null : !((Object)this$ospfConfig).equals(other$ospfConfig)) {
            return false;
        }
        List<IbgpConfig> this$ibgpConfigList = this.getIbgpConfigList();
        List<IbgpConfig> other$ibgpConfigList = other.getIbgpConfigList();
        if (this$ibgpConfigList == null ? other$ibgpConfigList != null : !((Object)this$ibgpConfigList).equals(other$ibgpConfigList)) {
            return false;
        }
        List<IPSubnet> this$localPrefixList = this.getLocalPrefixList();
        List<IPSubnet> other$localPrefixList = other.getLocalPrefixList();
        return !(this$localPrefixList == null ? other$localPrefixList != null : !((Object)this$localPrefixList).equals(other$localPrefixList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalRoutingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OspfConfig $ospfConfig = this.getOspfConfig();
        result = result * 59 + ($ospfConfig == null ? 43 : ((Object)$ospfConfig).hashCode());
        List<IbgpConfig> $ibgpConfigList = this.getIbgpConfigList();
        result = result * 59 + ($ibgpConfigList == null ? 43 : ((Object)$ibgpConfigList).hashCode());
        List<IPSubnet> $localPrefixList = this.getLocalPrefixList();
        result = result * 59 + ($localPrefixList == null ? 43 : ((Object)$localPrefixList).hashCode());
        return result;
    }

    public String toString() {
        return "InternalRoutingConfig(ospfConfig=" + this.getOspfConfig() + ", ibgpConfigList=" + this.getIbgpConfigList() + ", localPrefixList=" + this.getLocalPrefixList() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class InternalRoutingConfigBuilder {
        private OspfConfig ospfConfig;
        private List<IbgpConfig> ibgpConfigList;
        private List<IPSubnet> localPrefixList;

        InternalRoutingConfigBuilder() {
        }

        public InternalRoutingConfigBuilder ospfConfig(OspfConfig ospfConfig) {
            this.ospfConfig = ospfConfig;
            return this;
        }

        public InternalRoutingConfigBuilder ibgpConfigList(List<IbgpConfig> ibgpConfigList) {
            this.ibgpConfigList = ibgpConfigList;
            return this;
        }

        public InternalRoutingConfigBuilder localPrefixList(List<IPSubnet> localPrefixList) {
            this.localPrefixList = localPrefixList;
            return this;
        }

        public InternalRoutingConfig build() {
            return new InternalRoutingConfig(this.ospfConfig, this.ibgpConfigList, this.localPrefixList);
        }

        public String toString() {
            return "InternalRoutingConfig.InternalRoutingConfigBuilder(ospfConfig=" + this.ospfConfig + ", ibgpConfigList=" + this.ibgpConfigList + ", localPrefixList=" + this.localPrefixList + ")";
        }
    }
}

