/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.RemoteVtepStretchStatus;
import com.nutanix.dp1.net.networking.v4.config.SiteParams;
import com.nutanix.dp1.net.networking.v4.config.StretchConnectionType;
import com.nutanix.dp1.net.networking.v4.config.StretchStatus;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Layer2Stretch
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Layer2Stretch.class);
    @Size(min=0, max=10)
    private @Size(min=0, max=10) List<RemoteVtepStretchStatus> remoteStretchStatus = null;
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="localSiteParams")
    public SiteParams localSiteParams = null;
    @JsonProperty(value="remoteSiteParams")
    public SiteParams remoteSiteParams = null;
    @JsonProperty(value="connectionType")
    public StretchConnectionType connectionType = null;
    @JsonProperty(value="stretchStatus")
    public StretchStatus stretchStatus = null;
    @Max(value=8950L)
    @Min(value=500L)
    @JsonProperty(value="mtu")
    public @Max(value=8950L) @Min(value=500L) Integer mtu = null;
    @Max(value=0xFFFFFFL)
    @Min(value=1L)
    @JsonProperty(value="vni")
    public @Max(value=0xFFFFFFL) @Min(value=1L) Integer vni = null;

    public Layer2Stretch() {
    }

    public Layer2Stretch(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, SiteParams localSiteParams, SiteParams remoteSiteParams, StretchConnectionType connectionType, StretchStatus stretchStatus, List<RemoteVtepStretchStatus> remoteStretchStatus, Integer mtu, Integer vni) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setLocalSiteParams(localSiteParams);
        this.setRemoteSiteParams(remoteSiteParams);
        this.setConnectionType(connectionType);
        this.setStretchStatus(stretchStatus);
        this.setRemoteStretchStatus(remoteStretchStatus);
        this.setMtu(mtu);
        this.setVni(vni);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Layer2Stretch";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setRemoteStretchStatus(List<RemoteVtepStretchStatus> remoteStretchStatus) {
        if (this.remoteStretchStatus == null) {
            this.remoteStretchStatus = remoteStretchStatus;
        } else {
            log.warn("Read-only property remoteStretchStatus already contains a non-null value and cannot be set again");
        }
    }

    public static Layer2StretchBuilder Layer2StretchBuilder() {
        return new Layer2StretchBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer2Stretch)) {
            return false;
        }
        Layer2Stretch other = (Layer2Stretch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<RemoteVtepStretchStatus> this$remoteStretchStatus = this.getRemoteStretchStatus();
        List<RemoteVtepStretchStatus> other$remoteStretchStatus = other.getRemoteStretchStatus();
        if (this$remoteStretchStatus == null ? other$remoteStretchStatus != null : !((Object)this$remoteStretchStatus).equals(other$remoteStretchStatus)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        SiteParams this$localSiteParams = this.getLocalSiteParams();
        SiteParams other$localSiteParams = other.getLocalSiteParams();
        if (this$localSiteParams == null ? other$localSiteParams != null : !((Object)this$localSiteParams).equals(other$localSiteParams)) {
            return false;
        }
        SiteParams this$remoteSiteParams = this.getRemoteSiteParams();
        SiteParams other$remoteSiteParams = other.getRemoteSiteParams();
        if (this$remoteSiteParams == null ? other$remoteSiteParams != null : !((Object)this$remoteSiteParams).equals(other$remoteSiteParams)) {
            return false;
        }
        StretchConnectionType this$connectionType = this.getConnectionType();
        StretchConnectionType other$connectionType = other.getConnectionType();
        if (this$connectionType == null ? other$connectionType != null : !((Object)((Object)this$connectionType)).equals((Object)other$connectionType)) {
            return false;
        }
        StretchStatus this$stretchStatus = this.getStretchStatus();
        StretchStatus other$stretchStatus = other.getStretchStatus();
        if (this$stretchStatus == null ? other$stretchStatus != null : !((Object)this$stretchStatus).equals(other$stretchStatus)) {
            return false;
        }
        Integer this$mtu = this.getMtu();
        Integer other$mtu = other.getMtu();
        if (this$mtu == null ? other$mtu != null : !((Object)this$mtu).equals(other$mtu)) {
            return false;
        }
        Integer this$vni = this.getVni();
        Integer other$vni = other.getVni();
        return !(this$vni == null ? other$vni != null : !((Object)this$vni).equals(other$vni));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Layer2Stretch;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<RemoteVtepStretchStatus> $remoteStretchStatus = this.getRemoteStretchStatus();
        result = result * 59 + ($remoteStretchStatus == null ? 43 : ((Object)$remoteStretchStatus).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        SiteParams $localSiteParams = this.getLocalSiteParams();
        result = result * 59 + ($localSiteParams == null ? 43 : ((Object)$localSiteParams).hashCode());
        SiteParams $remoteSiteParams = this.getRemoteSiteParams();
        result = result * 59 + ($remoteSiteParams == null ? 43 : ((Object)$remoteSiteParams).hashCode());
        StretchConnectionType $connectionType = this.getConnectionType();
        result = result * 59 + ($connectionType == null ? 43 : ((Object)((Object)$connectionType)).hashCode());
        StretchStatus $stretchStatus = this.getStretchStatus();
        result = result * 59 + ($stretchStatus == null ? 43 : ((Object)$stretchStatus).hashCode());
        Integer $mtu = this.getMtu();
        result = result * 59 + ($mtu == null ? 43 : ((Object)$mtu).hashCode());
        Integer $vni = this.getVni();
        result = result * 59 + ($vni == null ? 43 : ((Object)$vni).hashCode());
        return result;
    }

    public List<RemoteVtepStretchStatus> getRemoteStretchStatus() {
        return this.remoteStretchStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SiteParams getLocalSiteParams() {
        return this.localSiteParams;
    }

    public SiteParams getRemoteSiteParams() {
        return this.remoteSiteParams;
    }

    public StretchConnectionType getConnectionType() {
        return this.connectionType;
    }

    public StretchStatus getStretchStatus() {
        return this.stretchStatus;
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public Integer getVni() {
        return this.vni;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="localSiteParams")
    public void setLocalSiteParams(SiteParams localSiteParams) {
        this.localSiteParams = localSiteParams;
    }

    @JsonProperty(value="remoteSiteParams")
    public void setRemoteSiteParams(SiteParams remoteSiteParams) {
        this.remoteSiteParams = remoteSiteParams;
    }

    @JsonProperty(value="connectionType")
    public void setConnectionType(StretchConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    @JsonProperty(value="stretchStatus")
    public void setStretchStatus(StretchStatus stretchStatus) {
        this.stretchStatus = stretchStatus;
    }

    @JsonProperty(value="mtu")
    public void setMtu(Integer mtu) {
        this.mtu = mtu;
    }

    @JsonProperty(value="vni")
    public void setVni(Integer vni) {
        this.vni = vni;
    }

    @Override
    public String toString() {
        return "Layer2Stretch(remoteStretchStatus=" + this.getRemoteStretchStatus() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", localSiteParams=" + this.getLocalSiteParams() + ", remoteSiteParams=" + this.getRemoteSiteParams() + ", connectionType=" + (Object)((Object)this.getConnectionType()) + ", stretchStatus=" + this.getStretchStatus() + ", mtu=" + this.getMtu() + ", vni=" + this.getVni() + ")";
    }

    public static class Layer2StretchBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private SiteParams localSiteParams;
        private SiteParams remoteSiteParams;
        private StretchConnectionType connectionType;
        private StretchStatus stretchStatus;
        private List<RemoteVtepStretchStatus> remoteStretchStatus;
        private Integer mtu;
        private Integer vni;

        Layer2StretchBuilder() {
        }

        public Layer2StretchBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Layer2StretchBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public Layer2StretchBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public Layer2StretchBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Layer2StretchBuilder name(String name) {
            this.name = name;
            return this;
        }

        public Layer2StretchBuilder description(String description) {
            this.description = description;
            return this;
        }

        public Layer2StretchBuilder localSiteParams(SiteParams localSiteParams) {
            this.localSiteParams = localSiteParams;
            return this;
        }

        public Layer2StretchBuilder remoteSiteParams(SiteParams remoteSiteParams) {
            this.remoteSiteParams = remoteSiteParams;
            return this;
        }

        public Layer2StretchBuilder connectionType(StretchConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Layer2StretchBuilder stretchStatus(StretchStatus stretchStatus) {
            this.stretchStatus = stretchStatus;
            return this;
        }

        public Layer2StretchBuilder remoteStretchStatus(List<RemoteVtepStretchStatus> remoteStretchStatus) {
            this.remoteStretchStatus = remoteStretchStatus;
            return this;
        }

        public Layer2StretchBuilder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public Layer2StretchBuilder vni(Integer vni) {
            this.vni = vni;
            return this;
        }

        public Layer2Stretch build() {
            return new Layer2Stretch(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.localSiteParams, this.remoteSiteParams, this.connectionType, this.stretchStatus, this.remoteStretchStatus, this.mtu, this.vni);
        }

        public String toString() {
            return "Layer2Stretch.Layer2StretchBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", localSiteParams=" + this.localSiteParams + ", remoteSiteParams=" + this.remoteSiteParams + ", connectionType=" + (Object)((Object)this.connectionType) + ", stretchStatus=" + this.stretchStatus + ", remoteStretchStatus=" + this.remoteStretchStatus + ", mtu=" + this.mtu + ", vni=" + this.vni + ")";
        }
    }
}

