/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.MacAddress;
import com.nutanix.dp1.net.networking.v4.config.MacType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnedMacAddress
extends MacAddress
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(LearnedMacAddress.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="remoteGatewayReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String remoteGatewayReference = null;
    @JsonProperty(value="vtepIPAddress")
    public IPAddress vtepIPAddress = null;

    public LearnedMacAddress() {
    }

    public LearnedMacAddress(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String value, MacType macType, String remoteGatewayReference, IPAddress vtepIPAddress) {
        super(tenantId, extId, links, metadata, value, macType);
        this.setRemoteGatewayReference(remoteGatewayReference);
        this.setVtepIPAddress(vtepIPAddress);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.LearnedMacAddress";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static LearnedMacAddressBuilder LearnedMacAddressBuilder() {
        return new LearnedMacAddressBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LearnedMacAddress)) {
            return false;
        }
        LearnedMacAddress other = (LearnedMacAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$remoteGatewayReference = this.getRemoteGatewayReference();
        String other$remoteGatewayReference = other.getRemoteGatewayReference();
        if (this$remoteGatewayReference == null ? other$remoteGatewayReference != null : !this$remoteGatewayReference.equals(other$remoteGatewayReference)) {
            return false;
        }
        IPAddress this$vtepIPAddress = this.getVtepIPAddress();
        IPAddress other$vtepIPAddress = other.getVtepIPAddress();
        return !(this$vtepIPAddress == null ? other$vtepIPAddress != null : !((Object)this$vtepIPAddress).equals(other$vtepIPAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LearnedMacAddress;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $remoteGatewayReference = this.getRemoteGatewayReference();
        result = result * 59 + ($remoteGatewayReference == null ? 43 : $remoteGatewayReference.hashCode());
        IPAddress $vtepIPAddress = this.getVtepIPAddress();
        result = result * 59 + ($vtepIPAddress == null ? 43 : ((Object)$vtepIPAddress).hashCode());
        return result;
    }

    public String getRemoteGatewayReference() {
        return this.remoteGatewayReference;
    }

    public IPAddress getVtepIPAddress() {
        return this.vtepIPAddress;
    }

    @JsonProperty(value="remoteGatewayReference")
    public void setRemoteGatewayReference(String remoteGatewayReference) {
        this.remoteGatewayReference = remoteGatewayReference;
    }

    @JsonProperty(value="vtepIPAddress")
    public void setVtepIPAddress(IPAddress vtepIPAddress) {
        this.vtepIPAddress = vtepIPAddress;
    }

    @Override
    public String toString() {
        return "LearnedMacAddress(remoteGatewayReference=" + this.getRemoteGatewayReference() + ", vtepIPAddress=" + this.getVtepIPAddress() + ")";
    }

    public static class LearnedMacAddressBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String value;
        private MacType macType;
        private String remoteGatewayReference;
        private IPAddress vtepIPAddress;

        LearnedMacAddressBuilder() {
        }

        public LearnedMacAddressBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public LearnedMacAddressBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public LearnedMacAddressBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public LearnedMacAddressBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public LearnedMacAddressBuilder value(String value) {
            this.value = value;
            return this;
        }

        public LearnedMacAddressBuilder macType(MacType macType) {
            this.macType = macType;
            return this;
        }

        public LearnedMacAddressBuilder remoteGatewayReference(String remoteGatewayReference) {
            this.remoteGatewayReference = remoteGatewayReference;
            return this;
        }

        public LearnedMacAddressBuilder vtepIPAddress(IPAddress vtepIPAddress) {
            this.vtepIPAddress = vtepIPAddress;
            return this;
        }

        public LearnedMacAddress build() {
            return new LearnedMacAddress(this.tenantId, this.extId, this.links, this.metadata, this.value, this.macType, this.remoteGatewayReference, this.vtepIPAddress);
        }

        public String toString() {
            return "LearnedMacAddress.LearnedMacAddressBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", value=" + this.value + ", macType=" + (Object)((Object)this.macType) + ", remoteGatewayReference=" + this.remoteGatewayReference + ", vtepIPAddress=" + this.vtepIPAddress + ")";
        }
    }
}

