/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.Algorithm;
import com.nutanix.dp1.net.networking.v4.config.HealthCheck;
import com.nutanix.dp1.net.networking.v4.config.Listener;
import com.nutanix.dp1.net.networking.v4.config.LoadBalancerSessionType;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import com.nutanix.dp1.net.networking.v4.config.Target;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerSession
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(LoadBalancerSession.class);
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="type")
    public LoadBalancerSessionType type = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @JsonProperty(value="listener")
    public Listener listener = null;
    @JsonProperty(value="algorithm")
    public Algorithm algorithm = null;
    @JsonProperty(value="targetsConfig")
    public Target targetsConfig = null;
    @JsonProperty(value="healthCheckConfig")
    public HealthCheck healthCheckConfig = null;

    public LoadBalancerSession() {
    }

    public LoadBalancerSession(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, LoadBalancerSessionType type, String vpcReference, Listener listener, Algorithm algorithm, Target targetsConfig, HealthCheck healthCheckConfig) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setDescription(description);
        this.setType(type);
        this.setVpcReference(vpcReference);
        this.setListener(listener);
        this.setAlgorithm(algorithm);
        this.setTargetsConfig(targetsConfig);
        this.setHealthCheckConfig(healthCheckConfig);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.LoadBalancerSession";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static LoadBalancerSessionBuilder LoadBalancerSessionBuilder() {
        return new LoadBalancerSessionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadBalancerSession)) {
            return false;
        }
        LoadBalancerSession other = (LoadBalancerSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LoadBalancerSessionType this$type = this.getType();
        LoadBalancerSessionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        Listener this$listener = this.getListener();
        Listener other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !((Object)this$listener).equals(other$listener)) {
            return false;
        }
        Algorithm this$algorithm = this.getAlgorithm();
        Algorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        Target this$targetsConfig = this.getTargetsConfig();
        Target other$targetsConfig = other.getTargetsConfig();
        if (this$targetsConfig == null ? other$targetsConfig != null : !((Object)this$targetsConfig).equals(other$targetsConfig)) {
            return false;
        }
        HealthCheck this$healthCheckConfig = this.getHealthCheckConfig();
        HealthCheck other$healthCheckConfig = other.getHealthCheckConfig();
        return !(this$healthCheckConfig == null ? other$healthCheckConfig != null : !((Object)this$healthCheckConfig).equals(other$healthCheckConfig));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LoadBalancerSession;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LoadBalancerSessionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        Listener $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : ((Object)$listener).hashCode());
        Algorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        Target $targetsConfig = this.getTargetsConfig();
        result = result * 59 + ($targetsConfig == null ? 43 : ((Object)$targetsConfig).hashCode());
        HealthCheck $healthCheckConfig = this.getHealthCheckConfig();
        result = result * 59 + ($healthCheckConfig == null ? 43 : ((Object)$healthCheckConfig).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public LoadBalancerSessionType getType() {
        return this.type;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public Listener getListener() {
        return this.listener;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Target getTargetsConfig() {
        return this.targetsConfig;
    }

    public HealthCheck getHealthCheckConfig() {
        return this.healthCheckConfig;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="type")
    public void setType(LoadBalancerSessionType type) {
        this.type = type;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="listener")
    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @JsonProperty(value="targetsConfig")
    public void setTargetsConfig(Target targetsConfig) {
        this.targetsConfig = targetsConfig;
    }

    @JsonProperty(value="healthCheckConfig")
    public void setHealthCheckConfig(HealthCheck healthCheckConfig) {
        this.healthCheckConfig = healthCheckConfig;
    }

    @Override
    public String toString() {
        return "LoadBalancerSession(name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + (Object)((Object)this.getType()) + ", vpcReference=" + this.getVpcReference() + ", listener=" + this.getListener() + ", algorithm=" + (Object)((Object)this.getAlgorithm()) + ", targetsConfig=" + this.getTargetsConfig() + ", healthCheckConfig=" + this.getHealthCheckConfig() + ")";
    }

    public static class LoadBalancerSessionBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private LoadBalancerSessionType type;
        private String vpcReference;
        private Listener listener;
        private Algorithm algorithm;
        private Target targetsConfig;
        private HealthCheck healthCheckConfig;

        LoadBalancerSessionBuilder() {
        }

        public LoadBalancerSessionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public LoadBalancerSessionBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public LoadBalancerSessionBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public LoadBalancerSessionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public LoadBalancerSessionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LoadBalancerSessionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public LoadBalancerSessionBuilder type(LoadBalancerSessionType type) {
            this.type = type;
            return this;
        }

        public LoadBalancerSessionBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public LoadBalancerSessionBuilder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public LoadBalancerSessionBuilder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public LoadBalancerSessionBuilder targetsConfig(Target targetsConfig) {
            this.targetsConfig = targetsConfig;
            return this;
        }

        public LoadBalancerSessionBuilder healthCheckConfig(HealthCheck healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public LoadBalancerSession build() {
            return new LoadBalancerSession(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.type, this.vpcReference, this.listener, this.algorithm, this.targetsConfig, this.healthCheckConfig);
        }

        public String toString() {
            return "LoadBalancerSession.LoadBalancerSessionBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", type=" + (Object)((Object)this.type) + ", vpcReference=" + this.vpcReference + ", listener=" + this.listener + ", algorithm=" + (Object)((Object)this.algorithm) + ", targetsConfig=" + this.targetsConfig + ", healthCheckConfig=" + this.healthCheckConfig + ")";
        }
    }
}

