/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.MacType;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacAddress
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(MacAddress.class);
    @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$")
    @JsonProperty(value="value")
    public @Pattern(regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$") String value = null;
    @JsonProperty(value="macType")
    public MacType macType = null;

    public MacAddress() {
    }

    public MacAddress(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String value, MacType macType) {
        super(tenantId, extId, links, metadata);
        this.setValue(value);
        this.setMacType(macType);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.MacAddress";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static MacAddressBuilder MacAddressBuilder() {
        return new MacAddressBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MacAddress)) {
            return false;
        }
        MacAddress other = (MacAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        MacType this$macType = this.getMacType();
        MacType other$macType = other.getMacType();
        return !(this$macType == null ? other$macType != null : !((Object)((Object)this$macType)).equals((Object)other$macType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MacAddress;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        MacType $macType = this.getMacType();
        result = result * 59 + ($macType == null ? 43 : ((Object)((Object)$macType)).hashCode());
        return result;
    }

    public String getValue() {
        return this.value;
    }

    public MacType getMacType() {
        return this.macType;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="macType")
    public void setMacType(MacType macType) {
        this.macType = macType;
    }

    @Override
    public String toString() {
        return "MacAddress(value=" + this.getValue() + ", macType=" + (Object)((Object)this.getMacType()) + ")";
    }

    public static class MacAddressBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String value;
        private MacType macType;

        MacAddressBuilder() {
        }

        public MacAddressBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MacAddressBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public MacAddressBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public MacAddressBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public MacAddressBuilder value(String value) {
            this.value = value;
            return this;
        }

        public MacAddressBuilder macType(MacType macType) {
            this.macType = macType;
            return this;
        }

        public MacAddress build() {
            return new MacAddress(this.tenantId, this.extId, this.links, this.metadata, this.value, this.macType);
        }

        public String toString() {
            return "MacAddress.MacAddressBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", value=" + this.value + ", macType=" + (Object)((Object)this.macType) + ")";
        }
    }
}

