/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.AwsConfig;
import com.nutanix.dp1.net.networking.v4.config.AzureConfig;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkCloudConfig
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(NetworkCloudConfig.class);
    @JsonProperty(value="azureConfig")
    public AzureConfig azureConfig = null;
    @JsonProperty(value="awsConfig")
    public AwsConfig awsConfig = null;

    public NetworkCloudConfig() {
    }

    public NetworkCloudConfig(String tenantId, String extId, List<ApiLink> links, Metadata metadata, AzureConfig azureConfig, AwsConfig awsConfig) {
        super(tenantId, extId, links, metadata);
        this.setAzureConfig(azureConfig);
        this.setAwsConfig(awsConfig);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.NetworkCloudConfig";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static NetworkCloudConfigBuilder NetworkCloudConfigBuilder() {
        return new NetworkCloudConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkCloudConfig)) {
            return false;
        }
        NetworkCloudConfig other = (NetworkCloudConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureConfig this$azureConfig = this.getAzureConfig();
        AzureConfig other$azureConfig = other.getAzureConfig();
        if (this$azureConfig == null ? other$azureConfig != null : !((Object)this$azureConfig).equals(other$azureConfig)) {
            return false;
        }
        AwsConfig this$awsConfig = this.getAwsConfig();
        AwsConfig other$awsConfig = other.getAwsConfig();
        return !(this$awsConfig == null ? other$awsConfig != null : !((Object)this$awsConfig).equals(other$awsConfig));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NetworkCloudConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AzureConfig $azureConfig = this.getAzureConfig();
        result = result * 59 + ($azureConfig == null ? 43 : ((Object)$azureConfig).hashCode());
        AwsConfig $awsConfig = this.getAwsConfig();
        result = result * 59 + ($awsConfig == null ? 43 : ((Object)$awsConfig).hashCode());
        return result;
    }

    public AzureConfig getAzureConfig() {
        return this.azureConfig;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    @JsonProperty(value="azureConfig")
    public void setAzureConfig(AzureConfig azureConfig) {
        this.azureConfig = azureConfig;
    }

    @JsonProperty(value="awsConfig")
    public void setAwsConfig(AwsConfig awsConfig) {
        this.awsConfig = awsConfig;
    }

    @Override
    public String toString() {
        return "NetworkCloudConfig(azureConfig=" + this.getAzureConfig() + ", awsConfig=" + this.getAwsConfig() + ")";
    }

    public static class NetworkCloudConfigBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private AzureConfig azureConfig;
        private AwsConfig awsConfig;

        NetworkCloudConfigBuilder() {
        }

        public NetworkCloudConfigBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public NetworkCloudConfigBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public NetworkCloudConfigBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public NetworkCloudConfigBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public NetworkCloudConfigBuilder azureConfig(AzureConfig azureConfig) {
            this.azureConfig = azureConfig;
            return this;
        }

        public NetworkCloudConfigBuilder awsConfig(AwsConfig awsConfig) {
            this.awsConfig = awsConfig;
            return this;
        }

        public NetworkCloudConfig build() {
            return new NetworkCloudConfig(this.tenantId, this.extId, this.links, this.metadata, this.azureConfig, this.awsConfig);
        }

        public String toString() {
            return "NetworkCloudConfig.NetworkCloudConfigBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", azureConfig=" + this.azureConfig + ", awsConfig=" + this.awsConfig + ")";
        }
    }
}

