/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.CloudSubstrate;
import com.nutanix.dp1.net.networking.v4.config.ControllerStatus;
import com.nutanix.dp1.net.networking.v4.config.DefaultVlanStack;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkController
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(NetworkController.class);
    private String controllerVersion = null;
    private String minimumAHVVersion = null;
    private String minimumNOSVersion = null;
    @JsonProperty(value="controllerStatus")
    public ControllerStatus controllerStatus = null;
    @JsonProperty(value="cloudSubstrate")
    public CloudSubstrate cloudSubstrate = null;
    @JsonProperty(value="defaultVlanStack")
    public DefaultVlanStack defaultVlanStack = null;

    public NetworkController() {
    }

    public NetworkController(String tenantId, String extId, List<ApiLink> links, Metadata metadata, ControllerStatus controllerStatus, String controllerVersion, String minimumAHVVersion, String minimumNOSVersion, CloudSubstrate cloudSubstrate, DefaultVlanStack defaultVlanStack) {
        super(tenantId, extId, links, metadata);
        this.setControllerStatus(controllerStatus);
        this.setControllerVersion(controllerVersion);
        this.setMinimumAHVVersion(minimumAHVVersion);
        this.setMinimumNOSVersion(minimumNOSVersion);
        this.setCloudSubstrate(cloudSubstrate);
        this.setDefaultVlanStack(defaultVlanStack);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.NetworkController";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setControllerVersion(String controllerVersion) {
        if (this.controllerVersion == null) {
            this.controllerVersion = controllerVersion;
        } else {
            log.warn("Read-only property controllerVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setMinimumAHVVersion(String minimumAHVVersion) {
        if (this.minimumAHVVersion == null) {
            this.minimumAHVVersion = minimumAHVVersion;
        } else {
            log.warn("Read-only property minimumAHVVersion already contains a non-null value and cannot be set again");
        }
    }

    public void setMinimumNOSVersion(String minimumNOSVersion) {
        if (this.minimumNOSVersion == null) {
            this.minimumNOSVersion = minimumNOSVersion;
        } else {
            log.warn("Read-only property minimumNOSVersion already contains a non-null value and cannot be set again");
        }
    }

    public static NetworkControllerBuilder NetworkControllerBuilder() {
        return new NetworkControllerBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkController)) {
            return false;
        }
        NetworkController other = (NetworkController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$controllerVersion = this.getControllerVersion();
        String other$controllerVersion = other.getControllerVersion();
        if (this$controllerVersion == null ? other$controllerVersion != null : !this$controllerVersion.equals(other$controllerVersion)) {
            return false;
        }
        String this$minimumAHVVersion = this.getMinimumAHVVersion();
        String other$minimumAHVVersion = other.getMinimumAHVVersion();
        if (this$minimumAHVVersion == null ? other$minimumAHVVersion != null : !this$minimumAHVVersion.equals(other$minimumAHVVersion)) {
            return false;
        }
        String this$minimumNOSVersion = this.getMinimumNOSVersion();
        String other$minimumNOSVersion = other.getMinimumNOSVersion();
        if (this$minimumNOSVersion == null ? other$minimumNOSVersion != null : !this$minimumNOSVersion.equals(other$minimumNOSVersion)) {
            return false;
        }
        ControllerStatus this$controllerStatus = this.getControllerStatus();
        ControllerStatus other$controllerStatus = other.getControllerStatus();
        if (this$controllerStatus == null ? other$controllerStatus != null : !((Object)((Object)this$controllerStatus)).equals((Object)other$controllerStatus)) {
            return false;
        }
        CloudSubstrate this$cloudSubstrate = this.getCloudSubstrate();
        CloudSubstrate other$cloudSubstrate = other.getCloudSubstrate();
        if (this$cloudSubstrate == null ? other$cloudSubstrate != null : !((Object)((Object)this$cloudSubstrate)).equals((Object)other$cloudSubstrate)) {
            return false;
        }
        DefaultVlanStack this$defaultVlanStack = this.getDefaultVlanStack();
        DefaultVlanStack other$defaultVlanStack = other.getDefaultVlanStack();
        return !(this$defaultVlanStack == null ? other$defaultVlanStack != null : !((Object)((Object)this$defaultVlanStack)).equals((Object)other$defaultVlanStack));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NetworkController;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $controllerVersion = this.getControllerVersion();
        result = result * 59 + ($controllerVersion == null ? 43 : $controllerVersion.hashCode());
        String $minimumAHVVersion = this.getMinimumAHVVersion();
        result = result * 59 + ($minimumAHVVersion == null ? 43 : $minimumAHVVersion.hashCode());
        String $minimumNOSVersion = this.getMinimumNOSVersion();
        result = result * 59 + ($minimumNOSVersion == null ? 43 : $minimumNOSVersion.hashCode());
        ControllerStatus $controllerStatus = this.getControllerStatus();
        result = result * 59 + ($controllerStatus == null ? 43 : ((Object)((Object)$controllerStatus)).hashCode());
        CloudSubstrate $cloudSubstrate = this.getCloudSubstrate();
        result = result * 59 + ($cloudSubstrate == null ? 43 : ((Object)((Object)$cloudSubstrate)).hashCode());
        DefaultVlanStack $defaultVlanStack = this.getDefaultVlanStack();
        result = result * 59 + ($defaultVlanStack == null ? 43 : ((Object)((Object)$defaultVlanStack)).hashCode());
        return result;
    }

    public String getControllerVersion() {
        return this.controllerVersion;
    }

    public String getMinimumAHVVersion() {
        return this.minimumAHVVersion;
    }

    public String getMinimumNOSVersion() {
        return this.minimumNOSVersion;
    }

    public ControllerStatus getControllerStatus() {
        return this.controllerStatus;
    }

    public CloudSubstrate getCloudSubstrate() {
        return this.cloudSubstrate;
    }

    public DefaultVlanStack getDefaultVlanStack() {
        return this.defaultVlanStack;
    }

    @JsonProperty(value="controllerStatus")
    public void setControllerStatus(ControllerStatus controllerStatus) {
        this.controllerStatus = controllerStatus;
    }

    @JsonProperty(value="cloudSubstrate")
    public void setCloudSubstrate(CloudSubstrate cloudSubstrate) {
        this.cloudSubstrate = cloudSubstrate;
    }

    @JsonProperty(value="defaultVlanStack")
    public void setDefaultVlanStack(DefaultVlanStack defaultVlanStack) {
        this.defaultVlanStack = defaultVlanStack;
    }

    @Override
    public String toString() {
        return "NetworkController(controllerVersion=" + this.getControllerVersion() + ", minimumAHVVersion=" + this.getMinimumAHVVersion() + ", minimumNOSVersion=" + this.getMinimumNOSVersion() + ", controllerStatus=" + (Object)((Object)this.getControllerStatus()) + ", cloudSubstrate=" + (Object)((Object)this.getCloudSubstrate()) + ", defaultVlanStack=" + (Object)((Object)this.getDefaultVlanStack()) + ")";
    }

    public static class NetworkControllerBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private ControllerStatus controllerStatus;
        private String controllerVersion;
        private String minimumAHVVersion;
        private String minimumNOSVersion;
        private CloudSubstrate cloudSubstrate;
        private DefaultVlanStack defaultVlanStack;

        NetworkControllerBuilder() {
        }

        public NetworkControllerBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public NetworkControllerBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public NetworkControllerBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public NetworkControllerBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public NetworkControllerBuilder controllerStatus(ControllerStatus controllerStatus) {
            this.controllerStatus = controllerStatus;
            return this;
        }

        public NetworkControllerBuilder controllerVersion(String controllerVersion) {
            this.controllerVersion = controllerVersion;
            return this;
        }

        public NetworkControllerBuilder minimumAHVVersion(String minimumAHVVersion) {
            this.minimumAHVVersion = minimumAHVVersion;
            return this;
        }

        public NetworkControllerBuilder minimumNOSVersion(String minimumNOSVersion) {
            this.minimumNOSVersion = minimumNOSVersion;
            return this;
        }

        public NetworkControllerBuilder cloudSubstrate(CloudSubstrate cloudSubstrate) {
            this.cloudSubstrate = cloudSubstrate;
            return this;
        }

        public NetworkControllerBuilder defaultVlanStack(DefaultVlanStack defaultVlanStack) {
            this.defaultVlanStack = defaultVlanStack;
            return this;
        }

        public NetworkController build() {
            return new NetworkController(this.tenantId, this.extId, this.links, this.metadata, this.controllerStatus, this.controllerVersion, this.minimumAHVVersion, this.minimumNOSVersion, this.cloudSubstrate, this.defaultVlanStack);
        }

        public String toString() {
            return "NetworkController.NetworkControllerBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", controllerStatus=" + (Object)((Object)this.controllerStatus) + ", controllerVersion=" + this.controllerVersion + ", minimumAHVVersion=" + this.minimumAHVVersion + ", minimumNOSVersion=" + this.minimumNOSVersion + ", cloudSubstrate=" + (Object)((Object)this.cloudSubstrate) + ", defaultVlanStack=" + (Object)((Object)this.defaultVlanStack) + ")";
        }
    }
}

