/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.net.common.v1.config.IPAddress;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NexthopType;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nexthop
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Nexthop.class);
    @Size(max=128)
    private @Size(max=128) String nexthopName = null;
    @JsonProperty(value="nexthopType")
    public NexthopType nexthopType = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="nexthopReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String nexthopReference = null;
    @JsonProperty(value="nexthopIpAddress")
    public IPAddress nexthopIpAddress = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public Nexthop() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public Nexthop(NexthopType nexthopType, String nexthopReference, IPAddress nexthopIpAddress, String nexthopName) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setNexthopType(nexthopType);
        this.setNexthopReference(nexthopReference);
        this.setNexthopIpAddress(nexthopIpAddress);
        this.setNexthopName(nexthopName);
    }

    protected String initialize$objectType() {
        return "networking.v4.config.Nexthop";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setNexthopName(String nexthopName) {
        if (this.nexthopName == null) {
            this.nexthopName = nexthopName;
        } else {
            log.warn("Read-only property nexthopName already contains a non-null value and cannot be set again");
        }
    }

    public static NexthopBuilder NexthopBuilder() {
        return new NexthopBuilder();
    }

    public String getNexthopName() {
        return this.nexthopName;
    }

    public NexthopType getNexthopType() {
        return this.nexthopType;
    }

    public String getNexthopReference() {
        return this.nexthopReference;
    }

    public IPAddress getNexthopIpAddress() {
        return this.nexthopIpAddress;
    }

    @JsonProperty(value="nexthopType")
    public void setNexthopType(NexthopType nexthopType) {
        this.nexthopType = nexthopType;
    }

    @JsonProperty(value="nexthopReference")
    public void setNexthopReference(String nexthopReference) {
        this.nexthopReference = nexthopReference;
    }

    @JsonProperty(value="nexthopIpAddress")
    public void setNexthopIpAddress(IPAddress nexthopIpAddress) {
        this.nexthopIpAddress = nexthopIpAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nexthop)) {
            return false;
        }
        Nexthop other = (Nexthop)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nexthopName = this.getNexthopName();
        String other$nexthopName = other.getNexthopName();
        if (this$nexthopName == null ? other$nexthopName != null : !this$nexthopName.equals(other$nexthopName)) {
            return false;
        }
        NexthopType this$nexthopType = this.getNexthopType();
        NexthopType other$nexthopType = other.getNexthopType();
        if (this$nexthopType == null ? other$nexthopType != null : !((Object)((Object)this$nexthopType)).equals((Object)other$nexthopType)) {
            return false;
        }
        String this$nexthopReference = this.getNexthopReference();
        String other$nexthopReference = other.getNexthopReference();
        if (this$nexthopReference == null ? other$nexthopReference != null : !this$nexthopReference.equals(other$nexthopReference)) {
            return false;
        }
        IPAddress this$nexthopIpAddress = this.getNexthopIpAddress();
        IPAddress other$nexthopIpAddress = other.getNexthopIpAddress();
        return !(this$nexthopIpAddress == null ? other$nexthopIpAddress != null : !((Object)this$nexthopIpAddress).equals(other$nexthopIpAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nexthop;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nexthopName = this.getNexthopName();
        result = result * 59 + ($nexthopName == null ? 43 : $nexthopName.hashCode());
        NexthopType $nexthopType = this.getNexthopType();
        result = result * 59 + ($nexthopType == null ? 43 : ((Object)((Object)$nexthopType)).hashCode());
        String $nexthopReference = this.getNexthopReference();
        result = result * 59 + ($nexthopReference == null ? 43 : $nexthopReference.hashCode());
        IPAddress $nexthopIpAddress = this.getNexthopIpAddress();
        result = result * 59 + ($nexthopIpAddress == null ? 43 : ((Object)$nexthopIpAddress).hashCode());
        return result;
    }

    public String toString() {
        return "Nexthop(nexthopName=" + this.getNexthopName() + ", nexthopType=" + (Object)((Object)this.getNexthopType()) + ", nexthopReference=" + this.getNexthopReference() + ", nexthopIpAddress=" + this.getNexthopIpAddress() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class NexthopBuilder {
        private NexthopType nexthopType;
        private String nexthopReference;
        private IPAddress nexthopIpAddress;
        private String nexthopName;

        NexthopBuilder() {
        }

        public NexthopBuilder nexthopType(NexthopType nexthopType) {
            this.nexthopType = nexthopType;
            return this;
        }

        public NexthopBuilder nexthopReference(String nexthopReference) {
            this.nexthopReference = nexthopReference;
            return this;
        }

        public NexthopBuilder nexthopIpAddress(IPAddress nexthopIpAddress) {
            this.nexthopIpAddress = nexthopIpAddress;
            return this;
        }

        public NexthopBuilder nexthopName(String nexthopName) {
            this.nexthopName = nexthopName;
            return this;
        }

        public Nexthop build() {
            return new Nexthop(this.nexthopType, this.nexthopReference, this.nexthopIpAddress, this.nexthopName);
        }

        public String toString() {
            return "Nexthop.NexthopBuilder(nexthopType=" + (Object)((Object)this.nexthopType) + ", nexthopReference=" + this.nexthopReference + ", nexthopIpAddress=" + this.nexthopIpAddress + ", nexthopName=" + this.nexthopName + ")";
        }
    }
}

