/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.DpdConfig;
import com.nutanix.dp1.net.networking.v4.config.GatewayRole;
import com.nutanix.dp1.net.networking.v4.config.IPSubnet;
import com.nutanix.dp1.net.networking.v4.config.IpsecConfig;
import com.nutanix.dp1.net.networking.v4.config.QosConfig;
import com.nutanix.dp1.net.networking.v4.config.Status;
import com.nutanix.dp1.net.networking.v4.config.VpnConnection;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteVpnConnection
extends VpnConnection
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(RemoteVpnConnection.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterReference = null;
    @Size(max=128)
    @JsonProperty(value="clusterName")
    public @Size(max=128) String clusterName = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @Size(max=128)
    @JsonProperty(value="vpcName")
    public @Size(max=128) String vpcName = null;

    public RemoteVpnConnection() {
    }

    public RemoteVpnConnection(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, String localGatewayReference, String remoteGatewayReference, IpsecConfig ipsecConfig, DpdConfig dpdConfig, QosConfig qosConfig, GatewayRole localGatewayRole, Integer dynamicRoutePriority, List<IPSubnet> advertisedPrefixes, List<IPSubnet> learnedPrefixes, Status ipsecTunnelStatus, Status ebgpStatus, String clusterReference, String clusterName, String vpcReference, String vpcName) {
        super(tenantId, extId, links, metadata, name, description, localGatewayReference, remoteGatewayReference, ipsecConfig, dpdConfig, qosConfig, localGatewayRole, dynamicRoutePriority, advertisedPrefixes, learnedPrefixes, ipsecTunnelStatus, ebgpStatus);
        this.setClusterReference(clusterReference);
        this.setClusterName(clusterName);
        this.setVpcReference(vpcReference);
        this.setVpcName(vpcName);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.RemoteVpnConnection";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static RemoteVpnConnectionBuilder RemoteVpnConnectionBuilder() {
        return new RemoteVpnConnectionBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteVpnConnection)) {
            return false;
        }
        RemoteVpnConnection other = (RemoteVpnConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterReference = this.getClusterReference();
        String other$clusterReference = other.getClusterReference();
        if (this$clusterReference == null ? other$clusterReference != null : !this$clusterReference.equals(other$clusterReference)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        String this$vpcName = this.getVpcName();
        String other$vpcName = other.getVpcName();
        return !(this$vpcName == null ? other$vpcName != null : !this$vpcName.equals(other$vpcName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RemoteVpnConnection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clusterReference = this.getClusterReference();
        result = result * 59 + ($clusterReference == null ? 43 : $clusterReference.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        String $vpcName = this.getVpcName();
        result = result * 59 + ($vpcName == null ? 43 : $vpcName.hashCode());
        return result;
    }

    public String getClusterReference() {
        return this.clusterReference;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public String getVpcName() {
        return this.vpcName;
    }

    @JsonProperty(value="clusterReference")
    public void setClusterReference(String clusterReference) {
        this.clusterReference = clusterReference;
    }

    @JsonProperty(value="clusterName")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="vpcName")
    public void setVpcName(String vpcName) {
        this.vpcName = vpcName;
    }

    @Override
    public String toString() {
        return "RemoteVpnConnection(clusterReference=" + this.getClusterReference() + ", clusterName=" + this.getClusterName() + ", vpcReference=" + this.getVpcReference() + ", vpcName=" + this.getVpcName() + ")";
    }

    public static class RemoteVpnConnectionBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private String localGatewayReference;
        private String remoteGatewayReference;
        private IpsecConfig ipsecConfig;
        private DpdConfig dpdConfig;
        private QosConfig qosConfig;
        private GatewayRole localGatewayRole;
        private Integer dynamicRoutePriority;
        private List<IPSubnet> advertisedPrefixes;
        private List<IPSubnet> learnedPrefixes;
        private Status ipsecTunnelStatus;
        private Status ebgpStatus;
        private String clusterReference;
        private String clusterName;
        private String vpcReference;
        private String vpcName;

        RemoteVpnConnectionBuilder() {
        }

        public RemoteVpnConnectionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RemoteVpnConnectionBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RemoteVpnConnectionBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RemoteVpnConnectionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public RemoteVpnConnectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RemoteVpnConnectionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RemoteVpnConnectionBuilder localGatewayReference(String localGatewayReference) {
            this.localGatewayReference = localGatewayReference;
            return this;
        }

        public RemoteVpnConnectionBuilder remoteGatewayReference(String remoteGatewayReference) {
            this.remoteGatewayReference = remoteGatewayReference;
            return this;
        }

        public RemoteVpnConnectionBuilder ipsecConfig(IpsecConfig ipsecConfig) {
            this.ipsecConfig = ipsecConfig;
            return this;
        }

        public RemoteVpnConnectionBuilder dpdConfig(DpdConfig dpdConfig) {
            this.dpdConfig = dpdConfig;
            return this;
        }

        public RemoteVpnConnectionBuilder qosConfig(QosConfig qosConfig) {
            this.qosConfig = qosConfig;
            return this;
        }

        public RemoteVpnConnectionBuilder localGatewayRole(GatewayRole localGatewayRole) {
            this.localGatewayRole = localGatewayRole;
            return this;
        }

        public RemoteVpnConnectionBuilder dynamicRoutePriority(Integer dynamicRoutePriority) {
            this.dynamicRoutePriority = dynamicRoutePriority;
            return this;
        }

        public RemoteVpnConnectionBuilder advertisedPrefixes(List<IPSubnet> advertisedPrefixes) {
            this.advertisedPrefixes = advertisedPrefixes;
            return this;
        }

        public RemoteVpnConnectionBuilder learnedPrefixes(List<IPSubnet> learnedPrefixes) {
            this.learnedPrefixes = learnedPrefixes;
            return this;
        }

        public RemoteVpnConnectionBuilder ipsecTunnelStatus(Status ipsecTunnelStatus) {
            this.ipsecTunnelStatus = ipsecTunnelStatus;
            return this;
        }

        public RemoteVpnConnectionBuilder ebgpStatus(Status ebgpStatus) {
            this.ebgpStatus = ebgpStatus;
            return this;
        }

        public RemoteVpnConnectionBuilder clusterReference(String clusterReference) {
            this.clusterReference = clusterReference;
            return this;
        }

        public RemoteVpnConnectionBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public RemoteVpnConnectionBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public RemoteVpnConnectionBuilder vpcName(String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        public RemoteVpnConnection build() {
            return new RemoteVpnConnection(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.localGatewayReference, this.remoteGatewayReference, this.ipsecConfig, this.dpdConfig, this.qosConfig, this.localGatewayRole, this.dynamicRoutePriority, this.advertisedPrefixes, this.learnedPrefixes, this.ipsecTunnelStatus, this.ebgpStatus, this.clusterReference, this.clusterName, this.vpcReference, this.vpcName);
        }

        public String toString() {
            return "RemoteVpnConnection.RemoteVpnConnectionBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", localGatewayReference=" + this.localGatewayReference + ", remoteGatewayReference=" + this.remoteGatewayReference + ", ipsecConfig=" + this.ipsecConfig + ", dpdConfig=" + this.dpdConfig + ", qosConfig=" + this.qosConfig + ", localGatewayRole=" + (Object)((Object)this.localGatewayRole) + ", dynamicRoutePriority=" + this.dynamicRoutePriority + ", advertisedPrefixes=" + this.advertisedPrefixes + ", learnedPrefixes=" + this.learnedPrefixes + ", ipsecTunnelStatus=" + this.ipsecTunnelStatus + ", ebgpStatus=" + this.ebgpStatus + ", clusterReference=" + this.clusterReference + ", clusterName=" + this.clusterName + ", vpcReference=" + this.vpcReference + ", vpcName=" + this.vpcName + ")";
        }
    }
}

