/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteVtepGateway
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(RemoteVtepGateway.class);
    @Size(max=128)
    @JsonProperty(value="name")
    public @Size(max=128) String name = null;
    @JsonProperty(value="isLocal")
    public Boolean isLocal = null;
    @Max(value=65535L)
    @Min(value=0L)
    @JsonProperty(value="vxlanPort")
    public @Max(value=65535L) @Min(value=0L) Integer vxlanPort = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterReference = null;
    @Size(max=128)
    @JsonProperty(value="clusterName")
    public @Size(max=128) String clusterName = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @Size(max=128)
    @JsonProperty(value="vpcName")
    public @Size(max=128) String vpcName = null;

    public RemoteVtepGateway() {
    }

    public RemoteVtepGateway(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, Boolean isLocal, Integer vxlanPort, String clusterReference, String clusterName, String vpcReference, String vpcName) {
        super(tenantId, extId, links, metadata);
        this.setName(name);
        this.setIsLocal(isLocal);
        this.setVxlanPort(vxlanPort);
        this.setClusterReference(clusterReference);
        this.setClusterName(clusterName);
        this.setVpcReference(vpcReference);
        this.setVpcName(vpcName);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.RemoteVtepGateway";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static RemoteVtepGatewayBuilder RemoteVtepGatewayBuilder() {
        return new RemoteVtepGatewayBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteVtepGateway)) {
            return false;
        }
        RemoteVtepGateway other = (RemoteVtepGateway)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Boolean this$isLocal = this.getIsLocal();
        Boolean other$isLocal = other.getIsLocal();
        if (this$isLocal == null ? other$isLocal != null : !((Object)this$isLocal).equals(other$isLocal)) {
            return false;
        }
        Integer this$vxlanPort = this.getVxlanPort();
        Integer other$vxlanPort = other.getVxlanPort();
        if (this$vxlanPort == null ? other$vxlanPort != null : !((Object)this$vxlanPort).equals(other$vxlanPort)) {
            return false;
        }
        String this$clusterReference = this.getClusterReference();
        String other$clusterReference = other.getClusterReference();
        if (this$clusterReference == null ? other$clusterReference != null : !this$clusterReference.equals(other$clusterReference)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        String this$vpcName = this.getVpcName();
        String other$vpcName = other.getVpcName();
        return !(this$vpcName == null ? other$vpcName != null : !this$vpcName.equals(other$vpcName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RemoteVtepGateway;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Boolean $isLocal = this.getIsLocal();
        result = result * 59 + ($isLocal == null ? 43 : ((Object)$isLocal).hashCode());
        Integer $vxlanPort = this.getVxlanPort();
        result = result * 59 + ($vxlanPort == null ? 43 : ((Object)$vxlanPort).hashCode());
        String $clusterReference = this.getClusterReference();
        result = result * 59 + ($clusterReference == null ? 43 : $clusterReference.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        String $vpcName = this.getVpcName();
        result = result * 59 + ($vpcName == null ? 43 : $vpcName.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsLocal() {
        return this.isLocal;
    }

    public Integer getVxlanPort() {
        return this.vxlanPort;
    }

    public String getClusterReference() {
        return this.clusterReference;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public String getVpcName() {
        return this.vpcName;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="isLocal")
    public void setIsLocal(Boolean isLocal) {
        this.isLocal = isLocal;
    }

    @JsonProperty(value="vxlanPort")
    public void setVxlanPort(Integer vxlanPort) {
        this.vxlanPort = vxlanPort;
    }

    @JsonProperty(value="clusterReference")
    public void setClusterReference(String clusterReference) {
        this.clusterReference = clusterReference;
    }

    @JsonProperty(value="clusterName")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="vpcName")
    public void setVpcName(String vpcName) {
        this.vpcName = vpcName;
    }

    @Override
    public String toString() {
        return "RemoteVtepGateway(name=" + this.getName() + ", isLocal=" + this.getIsLocal() + ", vxlanPort=" + this.getVxlanPort() + ", clusterReference=" + this.getClusterReference() + ", clusterName=" + this.getClusterName() + ", vpcReference=" + this.getVpcReference() + ", vpcName=" + this.getVpcName() + ")";
    }

    public static class RemoteVtepGatewayBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private Boolean isLocal;
        private Integer vxlanPort;
        private String clusterReference;
        private String clusterName;
        private String vpcReference;
        private String vpcName;

        RemoteVtepGatewayBuilder() {
        }

        public RemoteVtepGatewayBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RemoteVtepGatewayBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RemoteVtepGatewayBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RemoteVtepGatewayBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public RemoteVtepGatewayBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RemoteVtepGatewayBuilder isLocal(Boolean isLocal) {
            this.isLocal = isLocal;
            return this;
        }

        public RemoteVtepGatewayBuilder vxlanPort(Integer vxlanPort) {
            this.vxlanPort = vxlanPort;
            return this;
        }

        public RemoteVtepGatewayBuilder clusterReference(String clusterReference) {
            this.clusterReference = clusterReference;
            return this;
        }

        public RemoteVtepGatewayBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public RemoteVtepGatewayBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public RemoteVtepGatewayBuilder vpcName(String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        public RemoteVtepGateway build() {
            return new RemoteVtepGateway(this.tenantId, this.extId, this.links, this.metadata, this.name, this.isLocal, this.vxlanPort, this.clusterReference, this.clusterName, this.vpcReference, this.vpcName);
        }

        public String toString() {
            return "RemoteVtepGateway.RemoteVtepGatewayBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", isLocal=" + this.isLocal + ", vxlanPort=" + this.vxlanPort + ", clusterReference=" + this.clusterReference + ", clusterName=" + this.clusterName + ", vpcReference=" + this.vpcReference + ", vpcName=" + this.vpcName + ")";
        }
    }
}

