/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservedIp
extends ExternalizableAbstractModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(ReservedIp.class);
    @JsonProperty(value="ipv4Address")
    public String ipv4Address = null;
    @Size(min=1, max=64)
    @JsonProperty(value="clientContext")
    public @Size(min=1, max=64) String clientContext = null;

    public ReservedIp() {
    }

    public ReservedIp(String tenantId, String extId, List<ApiLink> links, String ipv4Address, String clientContext) {
        super(tenantId, extId, links);
        this.setIpv4Address(ipv4Address);
        this.setClientContext(clientContext);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.ReservedIp";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static ReservedIpBuilder ReservedIpBuilder() {
        return new ReservedIpBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReservedIp)) {
            return false;
        }
        ReservedIp other = (ReservedIp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ipv4Address = this.getIpv4Address();
        String other$ipv4Address = other.getIpv4Address();
        if (this$ipv4Address == null ? other$ipv4Address != null : !this$ipv4Address.equals(other$ipv4Address)) {
            return false;
        }
        String this$clientContext = this.getClientContext();
        String other$clientContext = other.getClientContext();
        return !(this$clientContext == null ? other$clientContext != null : !this$clientContext.equals(other$clientContext));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReservedIp;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ipv4Address = this.getIpv4Address();
        result = result * 59 + ($ipv4Address == null ? 43 : $ipv4Address.hashCode());
        String $clientContext = this.getClientContext();
        result = result * 59 + ($clientContext == null ? 43 : $clientContext.hashCode());
        return result;
    }

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public String getClientContext() {
        return this.clientContext;
    }

    @JsonProperty(value="ipv4Address")
    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    @JsonProperty(value="clientContext")
    public void setClientContext(String clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public String toString() {
        return "ReservedIp(ipv4Address=" + this.getIpv4Address() + ", clientContext=" + this.getClientContext() + ")";
    }

    public static class ReservedIpBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String ipv4Address;
        private String clientContext;

        ReservedIpBuilder() {
        }

        public ReservedIpBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ReservedIpBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ReservedIpBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ReservedIpBuilder ipv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public ReservedIpBuilder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public ReservedIp build() {
            return new ReservedIp(this.tenantId, this.extId, this.links, this.ipv4Address, this.clientContext);
        }

        public String toString() {
            return "ReservedIp.ReservedIpBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", ipv4Address=" + this.ipv4Address + ", clientContext=" + this.clientContext + ")";
        }
    }
}

