/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.BaseRoute;
import com.nutanix.dp1.net.networking.v4.config.IPSubnet;
import com.nutanix.dp1.net.networking.v4.config.Nexthop;
import com.nutanix.dp1.net.networking.v4.config.RouteType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Route
extends BaseRoute
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Route.class);
    private Boolean isActive = null;
    private Integer priority = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="routeTableReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String routeTableReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="externalRoutingDomainReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String externalRoutingDomainReference = null;
    @JsonProperty(value="routeType")
    public RouteType routeType = null;

    public Route() {
    }

    public Route(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String name, String description, IPSubnet destination, Nexthop nexthop, String routeTableReference, String vpcReference, String externalRoutingDomainReference, RouteType routeType, Boolean isActive, Integer priority) {
        super(tenantId, extId, links, metadata, name, description, destination, nexthop);
        this.setRouteTableReference(routeTableReference);
        this.setVpcReference(vpcReference);
        this.setExternalRoutingDomainReference(externalRoutingDomainReference);
        this.setRouteType(routeType);
        this.setIsActive(isActive);
        this.setPriority(priority);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.Route";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setIsActive(Boolean isActive) {
        if (this.isActive == null) {
            this.isActive = isActive;
        } else {
            log.warn("Read-only property isActive already contains a non-null value and cannot be set again");
        }
    }

    public void setPriority(Integer priority) {
        if (this.priority == null) {
            this.priority = priority;
        } else {
            log.warn("Read-only property priority already contains a non-null value and cannot be set again");
        }
    }

    public static RouteBuilder RouteBuilder() {
        return new RouteBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route other = (Route)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isActive = this.getIsActive();
        Boolean other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$routeTableReference = this.getRouteTableReference();
        String other$routeTableReference = other.getRouteTableReference();
        if (this$routeTableReference == null ? other$routeTableReference != null : !this$routeTableReference.equals(other$routeTableReference)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        String this$externalRoutingDomainReference = this.getExternalRoutingDomainReference();
        String other$externalRoutingDomainReference = other.getExternalRoutingDomainReference();
        if (this$externalRoutingDomainReference == null ? other$externalRoutingDomainReference != null : !this$externalRoutingDomainReference.equals(other$externalRoutingDomainReference)) {
            return false;
        }
        RouteType this$routeType = this.getRouteType();
        RouteType other$routeType = other.getRouteType();
        return !(this$routeType == null ? other$routeType != null : !((Object)((Object)this$routeType)).equals((Object)other$routeType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Route;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $routeTableReference = this.getRouteTableReference();
        result = result * 59 + ($routeTableReference == null ? 43 : $routeTableReference.hashCode());
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        String $externalRoutingDomainReference = this.getExternalRoutingDomainReference();
        result = result * 59 + ($externalRoutingDomainReference == null ? 43 : $externalRoutingDomainReference.hashCode());
        RouteType $routeType = this.getRouteType();
        result = result * 59 + ($routeType == null ? 43 : ((Object)((Object)$routeType)).hashCode());
        return result;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getRouteTableReference() {
        return this.routeTableReference;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public String getExternalRoutingDomainReference() {
        return this.externalRoutingDomainReference;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    @JsonProperty(value="routeTableReference")
    public void setRouteTableReference(String routeTableReference) {
        this.routeTableReference = routeTableReference;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="externalRoutingDomainReference")
    public void setExternalRoutingDomainReference(String externalRoutingDomainReference) {
        this.externalRoutingDomainReference = externalRoutingDomainReference;
    }

    @JsonProperty(value="routeType")
    public void setRouteType(RouteType routeType) {
        this.routeType = routeType;
    }

    @Override
    public String toString() {
        return "Route(isActive=" + this.getIsActive() + ", priority=" + this.getPriority() + ", routeTableReference=" + this.getRouteTableReference() + ", vpcReference=" + this.getVpcReference() + ", externalRoutingDomainReference=" + this.getExternalRoutingDomainReference() + ", routeType=" + (Object)((Object)this.getRouteType()) + ")";
    }

    public static class RouteBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String name;
        private String description;
        private IPSubnet destination;
        private Nexthop nexthop;
        private String routeTableReference;
        private String vpcReference;
        private String externalRoutingDomainReference;
        private RouteType routeType;
        private Boolean isActive;
        private Integer priority;

        RouteBuilder() {
        }

        public RouteBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RouteBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RouteBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RouteBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public RouteBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RouteBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RouteBuilder destination(IPSubnet destination) {
            this.destination = destination;
            return this;
        }

        public RouteBuilder nexthop(Nexthop nexthop) {
            this.nexthop = nexthop;
            return this;
        }

        public RouteBuilder routeTableReference(String routeTableReference) {
            this.routeTableReference = routeTableReference;
            return this;
        }

        public RouteBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public RouteBuilder externalRoutingDomainReference(String externalRoutingDomainReference) {
            this.externalRoutingDomainReference = externalRoutingDomainReference;
            return this;
        }

        public RouteBuilder routeType(RouteType routeType) {
            this.routeType = routeType;
            return this;
        }

        public RouteBuilder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public RouteBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Route build() {
            return new Route(this.tenantId, this.extId, this.links, this.metadata, this.name, this.description, this.destination, this.nexthop, this.routeTableReference, this.vpcReference, this.externalRoutingDomainReference, this.routeType, this.isActive, this.priority);
        }

        public String toString() {
            return "Route.RouteBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", destination=" + this.destination + ", nexthop=" + this.nexthop + ", routeTableReference=" + this.routeTableReference + ", vpcReference=" + this.vpcReference + ", externalRoutingDomainReference=" + this.externalRoutingDomainReference + ", routeType=" + (Object)((Object)this.routeType) + ", isActive=" + this.isActive + ", priority=" + this.priority + ")";
        }
    }
}

