/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.net.networking.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.net.common.v1.config.Metadata;
import com.nutanix.dp1.net.common.v1.response.ApiLink;
import com.nutanix.dp1.net.deserializers.NetObjectTypeTypedObject;
import com.nutanix.dp1.net.networking.v4.config.NetworkingBaseModel;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteTable
extends NetworkingBaseModel
implements Serializable,
NetObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(RouteTable.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vpcReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vpcReference = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="externalRoutingDomainReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String externalRoutingDomainReference = null;

    public RouteTable() {
    }

    public RouteTable(String tenantId, String extId, List<ApiLink> links, Metadata metadata, String vpcReference, String externalRoutingDomainReference) {
        super(tenantId, extId, links, metadata);
        this.setVpcReference(vpcReference);
        this.setExternalRoutingDomainReference(externalRoutingDomainReference);
    }

    @Override
    protected String initialize$objectType() {
        return "networking.v4.config.RouteTable";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static RouteTableBuilder RouteTableBuilder() {
        return new RouteTableBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$vpcReference = this.getVpcReference();
        String other$vpcReference = other.getVpcReference();
        if (this$vpcReference == null ? other$vpcReference != null : !this$vpcReference.equals(other$vpcReference)) {
            return false;
        }
        String this$externalRoutingDomainReference = this.getExternalRoutingDomainReference();
        String other$externalRoutingDomainReference = other.getExternalRoutingDomainReference();
        return !(this$externalRoutingDomainReference == null ? other$externalRoutingDomainReference != null : !this$externalRoutingDomainReference.equals(other$externalRoutingDomainReference));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RouteTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $vpcReference = this.getVpcReference();
        result = result * 59 + ($vpcReference == null ? 43 : $vpcReference.hashCode());
        String $externalRoutingDomainReference = this.getExternalRoutingDomainReference();
        result = result * 59 + ($externalRoutingDomainReference == null ? 43 : $externalRoutingDomainReference.hashCode());
        return result;
    }

    public String getVpcReference() {
        return this.vpcReference;
    }

    public String getExternalRoutingDomainReference() {
        return this.externalRoutingDomainReference;
    }

    @JsonProperty(value="vpcReference")
    public void setVpcReference(String vpcReference) {
        this.vpcReference = vpcReference;
    }

    @JsonProperty(value="externalRoutingDomainReference")
    public void setExternalRoutingDomainReference(String externalRoutingDomainReference) {
        this.externalRoutingDomainReference = externalRoutingDomainReference;
    }

    @Override
    public String toString() {
        return "RouteTable(vpcReference=" + this.getVpcReference() + ", externalRoutingDomainReference=" + this.getExternalRoutingDomainReference() + ")";
    }

    public static class RouteTableBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Metadata metadata;
        private String vpcReference;
        private String externalRoutingDomainReference;

        RouteTableBuilder() {
        }

        public RouteTableBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RouteTableBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RouteTableBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RouteTableBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public RouteTableBuilder vpcReference(String vpcReference) {
            this.vpcReference = vpcReference;
            return this;
        }

        public RouteTableBuilder externalRoutingDomainReference(String externalRoutingDomainReference) {
            this.externalRoutingDomainReference = externalRoutingDomainReference;
            return this;
        }

        public RouteTable build() {
            return new RouteTable(this.tenantId, this.extId, this.links, this.metadata, this.vpcReference, this.externalRoutingDomainReference);
        }

        public String toString() {
            return "RouteTable.RouteTableBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", metadata=" + this.metadata + ", vpcReference=" + this.vpcReference + ", externalRoutingDomainReference=" + this.externalRoutingDomainReference + ")";
        }
    }
}

